/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkBasedPropertyValue;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.Types;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PropertiesChunk
extends Chunk {
    public static final String NAME = "__properties_version1.0";
    private POILogger logger = POILogFactory.getLogger(PropertiesChunk.class);
    private Map<MAPIProperty, List<PropertyValue>> properties = new HashMap<MAPIProperty, List<PropertyValue>>();
    private ChunkGroup parentGroup;

    protected PropertiesChunk(ChunkGroup parentGroup) {
        super(NAME, -1, Types.UNKNOWN);
        this.parentGroup = parentGroup;
    }

    @Override
    public String getEntryName() {
        return NAME;
    }

    public Map<MAPIProperty, List<PropertyValue>> getProperties() {
        return this.properties;
    }

    public List<PropertyValue> getValues(MAPIProperty property) {
        return this.properties.get(property);
    }

    public PropertyValue getValue(MAPIProperty property) {
        List<PropertyValue> values = this.properties.get(property);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    protected void matchVariableSizedPropertiesToChunks() {
        HashMap<Integer, Chunk> chunks = new HashMap<Integer, Chunk>();
        for (Chunk chunk : this.parentGroup.getChunks()) {
            chunks.put(chunk.chunkId, chunk);
        }
        for (List<PropertyValue> vals : this.properties.values()) {
            if (vals == null) continue;
            for (PropertyValue val : vals) {
                if (!(val instanceof ChunkBasedPropertyValue)) continue;
                ChunkBasedPropertyValue cVal = (ChunkBasedPropertyValue)val;
                Chunk chunk = (Chunk)chunks.get(cVal.getProperty().id);
                if (chunk != null) {
                    cVal.setValue(chunk);
                    continue;
                }
                this.logger.log(5, "No chunk found matching Property " + cVal);
            }
        }
    }

    protected void readProperties(InputStream value) throws IOException {
        boolean going = true;
        while (going) {
            try {
                int typeID = LittleEndian.readUShort(value);
                int id = LittleEndian.readUShort(value);
                long flags = LittleEndian.readUInt(value);
                Types.MAPIType type = Types.getById(typeID);
                MAPIProperty prop = MAPIProperty.get(id);
                if (prop == MAPIProperty.UNKNOWN) {
                    prop = MAPIProperty.createCustom(id, type, "Unknown " + id);
                }
                if (type == null) {
                    this.logger.log(5, (Object)"Invalid type found, expected ", (Object)prop.usualType, (Object)" but got ", (Object)typeID, (Object)" for property ", prop);
                    going = false;
                    break;
                }
                if (!(prop.usualType == type || type == Types.ASCII_STRING && prop.usualType == Types.UNICODE_STRING || type == Types.UNICODE_STRING && prop.usualType == Types.ASCII_STRING)) {
                    if (prop.usualType == Types.UNKNOWN) {
                        this.logger.log(3, (Object)"Property definition for ", (Object)prop, (Object)" is missing a type definition, found a value with type ", type);
                    } else {
                        this.logger.log(5, (Object)"Type mismatch, expected ", (Object)prop.usualType, (Object)" but got ", (Object)type, (Object)" for property ", prop);
                        going = false;
                        break;
                    }
                }
                boolean isPointer = false;
                int length = type.getLength();
                if (!type.isFixedLength()) {
                    isPointer = true;
                    length = 8;
                }
                byte[] data = new byte[length];
                IOUtils.readFully(value, data);
                if (length < 8) {
                    byte[] padding = new byte[8 - length];
                    IOUtils.readFully(value, padding);
                }
                PropertyValue propVal = null;
                propVal = isPointer ? new ChunkBasedPropertyValue(prop, flags, data) : (type == Types.SHORT ? new PropertyValue.ShortPropertyValue(prop, flags, data) : (type == Types.LONG ? new PropertyValue.LongPropertyValue(prop, flags, data) : (type == Types.LONG_LONG ? new PropertyValue.LongLongPropertyValue(prop, flags, data) : (type == Types.TIME ? new PropertyValue.TimePropertyValue(prop, flags, data) : new PropertyValue(prop, flags, data)))));
                if (this.properties.get(prop) == null) {
                    this.properties.put(prop, new ArrayList());
                }
                this.properties.get(prop).add(propVal);
            }
            catch (LittleEndian.BufferUnderrunException e) {
                going = false;
            }
        }
    }

    protected void writeProperties(OutputStream out) throws IOException {
    }
}

