/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ImageParser
extends AbstractParser {
    private static final long serialVersionUID = 7852529269245520335L;
    private static final MediaType CANONICAL_BMP_TYPE = MediaType.image("x-ms-bmp");
    private static final MediaType JAVA_BMP_TYPE = MediaType.image("bmp");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(CANONICAL_BMP_TYPE, JAVA_BMP_TYPE, MediaType.image("gif"), MediaType.image("png"), MediaType.image("vnd.wap.wbmp"), MediaType.image("x-icon"), MediaType.image("x-xcf"))));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        block12: {
            String type = metadata.get("Content-Type");
            if (type != null) {
                if (CANONICAL_BMP_TYPE.toString().equals(type)) {
                    type = JAVA_BMP_TYPE.toString();
                }
                try {
                    Iterator<ImageReader> iterator = ImageIO.getImageReadersByMIMEType(type);
                    if (iterator.hasNext()) {
                        ImageReader reader = iterator.next();
                        try {
                            ImageInputStream imageStream = ImageIO.createImageInputStream(new CloseShieldInputStream(stream));
                            try {
                                reader.setInput(imageStream);
                                metadata.set(Metadata.IMAGE_WIDTH, Integer.toString(reader.getWidth(0)));
                                metadata.set(Metadata.IMAGE_LENGTH, Integer.toString(reader.getHeight(0)));
                                metadata.set("height", Integer.toString(reader.getHeight(0)));
                                metadata.set("width", Integer.toString(reader.getWidth(0)));
                                ImageParser.loadMetadata(reader.getImageMetadata(0), metadata);
                            }
                            finally {
                                imageStream.close();
                            }
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                    ImageParser.setIfPresent(metadata, "CommentExtensions CommentExtension", TikaCoreProperties.COMMENTS);
                    ImageParser.setIfPresent(metadata, "markerSequence com", TikaCoreProperties.COMMENTS);
                    ImageParser.setIfPresent(metadata, "Data BitsPerSample", Metadata.BITS_PER_SAMPLE);
                }
                catch (IIOException e) {
                    if (e.getMessage().equals("Unexpected block type 0!") && type.equals("image/gif")) break block12;
                    throw new TikaException(type + " parse error", e);
                }
            }
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    private static void setIfPresent(Metadata metadata, String imageIOkey, String tikaKey) {
        if (metadata.get(imageIOkey) != null) {
            metadata.set(tikaKey, metadata.get(imageIOkey));
        }
    }

    private static void setIfPresent(Metadata metadata, String imageIOkey, Property tikaProp) {
        if (metadata.get(imageIOkey) != null) {
            String v = metadata.get(imageIOkey);
            if (v.endsWith(" ")) {
                v = v.substring(0, v.lastIndexOf(32));
            }
            metadata.set(tikaProp, v);
        }
    }

    private static void loadMetadata(IIOMetadata imageMetadata, Metadata metadata) {
        String[] names = imageMetadata.getMetadataFormatNames();
        if (names == null) {
            return;
        }
        int length = names.length;
        for (int i = 0; i < length; ++i) {
            ImageParser.loadNode(metadata, imageMetadata.getAsTree(names[i]), "", false);
        }
    }

    private static void loadNode(Metadata metadata, Node node, String parents, boolean addThisNodeName) {
        NamedNodeMap map;
        if (addThisNodeName) {
            if (parents.length() > 0) {
                parents = parents + " ";
            }
            parents = parents + node.getNodeName();
        }
        if ((map = node.getAttributes()) != null) {
            int length = map.getLength();
            if (length == 1) {
                metadata.add(parents, ImageParser.normalize(map.item(0).getNodeValue()));
            } else if (length > 1) {
                StringBuilder value = new StringBuilder();
                for (int i = 0; i < length; ++i) {
                    if (i > 0) {
                        value.append(", ");
                    }
                    Node attr = map.item(i);
                    value.append(attr.getNodeName());
                    value.append("=");
                    value.append(ImageParser.normalize(attr.getNodeValue()));
                }
                metadata.add(parents, value.toString());
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            ImageParser.loadNode(metadata, child, parents, true);
        }
    }

    private static String normalize(String value) {
        value = value != null ? value.trim() : "";
        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
            return Boolean.TRUE.toString();
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(value)) {
            return Boolean.FALSE.toString();
        }
        return value;
    }
}

