/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp4;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.MetaBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.UserDataBox;
import com.coremedia.iso.boxes.apple.AbstractAppleMetaDataBox;
import com.coremedia.iso.boxes.apple.AppleAlbumBox;
import com.coremedia.iso.boxes.apple.AppleArtistBox;
import com.coremedia.iso.boxes.apple.AppleCommentBox;
import com.coremedia.iso.boxes.apple.AppleCustomGenreBox;
import com.coremedia.iso.boxes.apple.AppleEncoderBox;
import com.coremedia.iso.boxes.apple.AppleItemListBox;
import com.coremedia.iso.boxes.apple.AppleRecordingYearBox;
import com.coremedia.iso.boxes.apple.AppleStandardGenreBox;
import com.coremedia.iso.boxes.apple.AppleTrackAuthorBox;
import com.coremedia.iso.boxes.apple.AppleTrackNumberBox;
import com.coremedia.iso.boxes.apple.AppleTrackTitleBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.XMPDM;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MP4Parser
extends AbstractParser {
    private static final long serialVersionUID = 84011216792285L;
    private static final Map<MediaType, List<String>> typesMap = new HashMap<MediaType, List<String>>();
    private static final Set<MediaType> SUPPORTED_TYPES;
    private static final long EPOC_AS_MP4_TIME = 2082844800L;

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        MetaBox meta;
        AppleItemListBox apple;
        UserDataBox userData;
        List<TrackBox> tb;
        IsoFile isoFile;
        TikaInputStream tstream = TikaInputStream.get(stream);
        try {
            isoFile = new IsoFile(tstream.getFileChannel());
        }
        finally {
            tstream.close();
        }
        FileTypeBox fileType = MP4Parser.getOrNull(isoFile, FileTypeBox.class);
        if (fileType != null) {
            MediaType type = MediaType.application("mp4");
            for (MediaType t : typesMap.keySet()) {
                if (!typesMap.get(t).contains(fileType.getMajorBrand())) continue;
                type = t;
                break;
            }
            metadata.set("Content-Type", type.toString());
            if (type.getType().equals("audio")) {
                metadata.set(XMPDM.AUDIO_COMPRESSOR, fileType.getMajorBrand().trim());
            }
        } else {
            metadata.set("Content-Type", "video/quicktime");
        }
        MovieBox moov = MP4Parser.getOrNull(isoFile, MovieBox.class);
        if (moov == null) {
            return;
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        MovieHeaderBox mHeader = MP4Parser.getOrNull(moov, MovieHeaderBox.class);
        if (mHeader != null) {
            metadata.set(Metadata.CREATION_DATE, MP4Parser.MP4TimeToDate(mHeader.getCreationTime()));
            metadata.set(TikaCoreProperties.MODIFIED, MP4Parser.MP4TimeToDate(mHeader.getModificationTime()));
            double durationSeconds = (double)mHeader.getDuration() / (double)mHeader.getTimescale();
            metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)mHeader.getTimescale());
        }
        if ((tb = moov.getBoxes(TrackBox.class)).size() > 0) {
            AudioSampleEntry sample;
            TrackBox track = tb.get(0);
            TrackHeaderBox header = track.getTrackHeaderBox();
            metadata.set(TikaCoreProperties.CREATED, MP4Parser.MP4TimeToDate(header.getCreationTime()));
            metadata.set(TikaCoreProperties.MODIFIED, MP4Parser.MP4TimeToDate(header.getModificationTime()));
            metadata.set(Metadata.IMAGE_WIDTH, (int)header.getWidth());
            metadata.set(Metadata.IMAGE_LENGTH, (int)header.getHeight());
            SampleTableBox samples = track.getSampleTableBox();
            SampleDescriptionBox sampleDesc = samples.getSampleDescriptionBox();
            if (sampleDesc != null && (sample = MP4Parser.getOrNull(sampleDesc, AudioSampleEntry.class)) != null) {
                XMPDM.ChannelTypePropertyConverter.convertAndSet(metadata, sample.getChannelCount());
                metadata.set(XMPDM.AUDIO_SAMPLE_RATE, (int)sample.getSampleRate());
            }
        }
        if ((userData = MP4Parser.getOrNull(moov, UserDataBox.class)) != null && (apple = MP4Parser.getOrNull(meta = MP4Parser.getOrNull(userData, MetaBox.class), AppleItemListBox.class)) != null) {
            AppleTrackTitleBox title = MP4Parser.getOrNull(apple, AppleTrackTitleBox.class);
            MP4Parser.addMetadata(TikaCoreProperties.TITLE, metadata, (AbstractAppleMetaDataBox)title);
            AppleArtistBox artist = MP4Parser.getOrNull(apple, AppleArtistBox.class);
            MP4Parser.addMetadata(TikaCoreProperties.CREATOR, metadata, (AbstractAppleMetaDataBox)artist);
            MP4Parser.addMetadata(XMPDM.ARTIST, metadata, (AbstractAppleMetaDataBox)artist);
            AppleAlbumBox album = MP4Parser.getOrNull(apple, AppleAlbumBox.class);
            MP4Parser.addMetadata(XMPDM.ALBUM, metadata, (AbstractAppleMetaDataBox)album);
            AppleTrackAuthorBox composer = MP4Parser.getOrNull(apple, AppleTrackAuthorBox.class);
            MP4Parser.addMetadata(XMPDM.COMPOSER, metadata, (AbstractAppleMetaDataBox)composer);
            AppleStandardGenreBox sGenre = MP4Parser.getOrNull(apple, AppleStandardGenreBox.class);
            AppleCustomGenreBox cGenre = MP4Parser.getOrNull(apple, AppleCustomGenreBox.class);
            MP4Parser.addMetadata(XMPDM.GENRE, metadata, (AbstractAppleMetaDataBox)sGenre);
            MP4Parser.addMetadata(XMPDM.GENRE, metadata, (AbstractAppleMetaDataBox)cGenre);
            AppleRecordingYearBox year = MP4Parser.getOrNull(apple, AppleRecordingYearBox.class);
            MP4Parser.addMetadata(XMPDM.RELEASE_DATE, metadata, (AbstractAppleMetaDataBox)year);
            AppleTrackNumberBox trackNum = MP4Parser.getOrNull(apple, AppleTrackNumberBox.class);
            if (trackNum != null) {
                metadata.set(XMPDM.TRACK_NUMBER, trackNum.getTrackNumber());
            }
            AppleCommentBox comment = MP4Parser.getOrNull(apple, AppleCommentBox.class);
            MP4Parser.addMetadata(XMPDM.LOG_COMMENT, metadata, (AbstractAppleMetaDataBox)comment);
            AppleEncoderBox encoder = MP4Parser.getOrNull(apple, AppleEncoderBox.class);
            for (Box box : apple.getBoxes()) {
                if (!(box instanceof AbstractAppleMetaDataBox)) continue;
                xhtml.element("p", ((AbstractAppleMetaDataBox)box).getValue());
            }
        }
        xhtml.endDocument();
    }

    private static void addMetadata(String key, Metadata m, AbstractAppleMetaDataBox metadata) {
        if (metadata != null) {
            m.add(key, metadata.getValue());
        }
    }

    private static void addMetadata(Property prop, Metadata m, AbstractAppleMetaDataBox metadata) {
        if (metadata != null) {
            m.set(prop, metadata.getValue());
        }
    }

    private static Date MP4TimeToDate(long mp4Time) {
        long unix = mp4Time - 2082844800L;
        return new Date(unix * 1000L);
    }

    private static <T extends Box> T getOrNull(ContainerBox box, Class<T> clazz) {
        if (box == null) {
            return null;
        }
        List<T> boxes = box.getBoxes(clazz);
        if (boxes.size() == 0) {
            return null;
        }
        return (T)((Box)boxes.get(0));
    }

    static {
        typesMap.put(MediaType.audio("mp4"), Arrays.asList("M4A ", "M4B ", "F4A ", "F4B "));
        typesMap.put(MediaType.video("3gpp"), Arrays.asList("3ge6", "3ge7", "3gg6", "3gp1", "3gp2", "3gp3", "3gp4", "3gp5", "3gp6", "3gs7"));
        typesMap.put(MediaType.video("3gpp2"), Arrays.asList("3g2a", "3g2b", "3g2c"));
        typesMap.put(MediaType.video("mp4"), Arrays.asList("mp41", "mp42"));
        typesMap.put(MediaType.video("x-m4v"), Arrays.asList("M4V ", "M4VH", "M4VP"));
        typesMap.put(MediaType.video("quicktime"), Collections.emptyList());
        typesMap.put(MediaType.application("mp4"), Collections.emptyList());
        SUPPORTED_TYPES = Collections.unmodifiableSet(typesMap.keySet());
    }
}

