/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.txt;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.txt.UniversalEncodingListener;

public class UniversalEncodingDetector
implements EncodingDetector {
    private static final int BUFSIZE = 1024;
    private static final int LOOKAHEAD = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Charset detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return null;
        }
        input.mark(16384);
        try {
            UniversalEncodingListener listener = new UniversalEncodingListener(metadata);
            byte[] b = new byte[1024];
            int n = 0;
            int m = input.read(b);
            while (m != -1 && n < 16384 && !listener.isDone()) {
                listener.handleData(b, 0, m);
                m = input.read(b, 0, Math.min(b.length, 16384 - (n += m)));
            }
            Charset charset = listener.dataEnd();
            return charset;
        }
        catch (IOException e) {
            throw e;
        }
        catch (LinkageError e) {
            Charset charset = null;
            return charset;
        }
        finally {
            input.reset();
        }
    }
}

