/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.TreeMap;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.tika.io.IOUtils;
import org.apache.tika.metadata.Metadata;
import org.eclipse.jetty.util.ajax.JSON;

@Provider
@Produces(value={"application/json"})
public class JSONMessageBodyWriter
implements MessageBodyWriter<Metadata> {
    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Metadata.class.isAssignableFrom(type);
    }

    @Override
    public long getSize(Metadata data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(Metadata metadata, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        TreeMap<String, Object> res = new TreeMap<String, Object>();
        for (String name : metadata.names()) {
            String[] values = metadata.getValues(name);
            if (metadata.isMultiValued(name)) {
                res.put(name, values);
                continue;
            }
            res.put(name, values[0]);
        }
        String json = JSON.toString(res);
        System.err.println("JSON : " + json);
        StringReader r = new StringReader(json);
        IOUtils.copy((Reader)r, entityStream);
        entityStream.flush();
    }
}

