/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.InputStream;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.server.TikaResource;
import org.xml.sax.helpers.DefaultHandler;

@Path(value="/metadata")
public class MetadataEP {
    private static final Log logger = LogFactory.getLog(MetadataEP.class);
    private final AutoDetectParser parser;
    private final Metadata metadata = new Metadata();

    public MetadataEP(@Context HttpHeaders httpHeaders, @Context UriInfo info) {
        this.parser = TikaResource.createParser();
        TikaResource.fillMetadata(this.parser, this.metadata, httpHeaders.getRequestHeaders());
        TikaResource.logRequest(logger, info, this.metadata);
    }

    @POST
    public Response getMetadata(InputStream is) throws Exception {
        this.parser.parse(is, new DefaultHandler(), this.metadata);
        return Response.ok(this.metadata).build();
    }

    @POST
    @Path(value="{field}")
    @Produces(value={"text/plain"})
    public Response getSimpleMetadataField(@PathParam(value="field") String field, InputStream is) throws Exception {
        Response.Status defaultErrorResponse = Response.Status.BAD_REQUEST;
        try {
            this.parser.parse(is, new DefaultHandler(), this.metadata);
            defaultErrorResponse = Response.Status.NOT_FOUND;
        }
        catch (Exception e) {
            logger.info("Failed to process field " + field, e);
        }
        String value = this.metadata.get(field);
        if (value == null) {
            return Response.status(defaultErrorResponse).entity("Failed to get metadata field " + field).build();
        }
        return Response.ok((Object)value, MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Path(value="{field}")
    public Response getMetadataField(@PathParam(value="field") String field, InputStream is) throws Exception {
        Response.Status defaultErrorResponse = Response.Status.BAD_REQUEST;
        try {
            this.parser.parse(is, new DefaultHandler(), this.metadata);
            defaultErrorResponse = Response.Status.NOT_FOUND;
        }
        catch (Exception e) {
            logger.info("Failed to process field " + field, e);
        }
        String[] values = this.metadata.getValues(field);
        if (values.length == 0) {
            return Response.status(defaultErrorResponse).entity("Failed to get metadata field " + field).build();
        }
        for (String name : this.metadata.names()) {
            if (field.equals(name)) continue;
            this.metadata.remove(name);
        }
        return Response.ok(this.metadata).build();
    }
}

