/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.apache.tika.server.RichTextContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Path(value="/tika")
public class TikaResource {
    public static final String GREETING = "This is Tika Server. Please PUT\n";
    private final Log logger = LogFactory.getLog(TikaResource.class);

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return GREETING;
    }

    public static AutoDetectParser createParser() {
        final AutoDetectParser parser = new AutoDetectParser();
        Map<MediaType, Parser> parsers = parser.getParsers();
        parsers.put(MediaType.APPLICATION_XML, new HtmlParser());
        parser.setParsers(parsers);
        parser.setFallback(new Parser(){

            @Override
            public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
                return parser.getSupportedTypes(parseContext);
            }

            @Override
            public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
        });
        return parser;
    }

    public static String detectFilename(MultivaluedMap<String, String> httpHeaders) {
        String disposition = httpHeaders.getFirst("Content-Disposition");
        if (disposition != null) {
            try {
                String fn;
                ContentDisposition c = new ContentDisposition(disposition);
                if ("attachment".equals(c.getDisposition()) && (fn = c.getParameter("filename")) != null) {
                    return fn;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return httpHeaders.getFirst("File-Name");
    }

    public static void fillMetadata(AutoDetectParser parser, Metadata metadata, MultivaluedMap<String, String> httpHeaders) {
        String contentTypeHeader;
        javax.ws.rs.core.MediaType mediaType;
        String fileName = TikaResource.detectFilename(httpHeaders);
        if (fileName != null) {
            metadata.set("resourceName", fileName);
        }
        javax.ws.rs.core.MediaType mediaType2 = mediaType = (contentTypeHeader = httpHeaders.getFirst("Content-Type")) == null ? null : javax.ws.rs.core.MediaType.valueOf(contentTypeHeader);
        if (mediaType != null && "xml".equals(mediaType.getSubtype())) {
            mediaType = null;
        }
        if (mediaType != null && mediaType.equals(javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            mediaType = null;
        }
        if (mediaType != null) {
            metadata.add("Content-Type", mediaType.toString());
            final Detector detector = parser.getDetector();
            parser.setDetector(new Detector(){

                @Override
                public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
                    String ct = metadata.get("Content-Type");
                    if (ct != null) {
                        return MediaType.parse(ct);
                    }
                    return detector.detect(inputStream, metadata);
                }
            });
        }
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Path(value="form")
    public StreamingOutput getTextFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceText(att.getObject(InputStream.class), att.getHeaders(), info);
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public StreamingOutput getText(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceText(is, httpHeaders.getRequestHeaders(), info);
    }

    public StreamingOutput produceText(final InputStream is, MultivaluedMap<String, String> httpHeaders, final UriInfo info) {
        final AutoDetectParser parser = TikaResource.createParser();
        final Metadata metadata = new Metadata();
        TikaResource.fillMetadata(parser, metadata, httpHeaders);
        TikaResource.logRequest(this.logger, info, metadata);
        return new StreamingOutput(){

            @Override
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
                BodyContentHandler body = new BodyContentHandler(new RichTextContentHandler(writer));
                TikaInputStream tis = TikaInputStream.get(is);
                try {
                    parser.parse(tis, body, metadata);
                }
                catch (SAXException e) {
                    throw new WebApplicationException(e);
                }
                catch (EncryptedDocumentException e) {
                    TikaResource.this.logger.warn(String.format("%s: Encrypted document", info.getPath()), e);
                    throw new WebApplicationException((Throwable)e, Response.status(422).build());
                }
                catch (TikaException e) {
                    TikaResource.this.logger.warn(String.format("%s: Text extraction failed", info.getPath()), e);
                    if (e.getCause() != null && e.getCause() instanceof WebApplicationException) {
                        throw (WebApplicationException)e.getCause();
                    }
                    if (e.getCause() != null && e.getCause() instanceof IllegalStateException) {
                        throw new WebApplicationException(Response.status(422).build());
                    }
                    if (e.getCause() != null && e.getCause() instanceof OldWordFileFormatException) {
                        throw new WebApplicationException(Response.status(422).build());
                    }
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                finally {
                    tis.close();
                }
            }
        };
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Path(value="form")
    public StreamingOutput getHTMLFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), att.getHeaders(), info, "html");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    public StreamingOutput getHTML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(is, httpHeaders.getRequestHeaders(), info, "html");
    }

    @PUT
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    @Path(value="form")
    public StreamingOutput getXMLFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), att.getHeaders(), info, "xml");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/xml"})
    public StreamingOutput getXML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(is, httpHeaders.getRequestHeaders(), info, "xml");
    }

    private StreamingOutput produceOutput(final InputStream is, MultivaluedMap<String, String> httpHeaders, final UriInfo info, final String format) {
        final AutoDetectParser parser = TikaResource.createParser();
        final Metadata metadata = new Metadata();
        TikaResource.fillMetadata(parser, metadata, httpHeaders);
        TikaResource.logRequest(this.logger, info, metadata);
        return new StreamingOutput(){

            @Override
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                ExpandedTitleContentHandler content;
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
                try {
                    SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    TransformerHandler handler = factory.newTransformerHandler();
                    handler.getTransformer().setOutputProperty("method", format);
                    handler.getTransformer().setOutputProperty("indent", "yes");
                    handler.getTransformer().setOutputProperty("encoding", "UTF-8");
                    handler.setResult(new StreamResult(writer));
                    content = new ExpandedTitleContentHandler(handler);
                }
                catch (TransformerConfigurationException e) {
                    throw new WebApplicationException(e);
                }
                TikaInputStream tis = TikaInputStream.get(is);
                try {
                    parser.parse(tis, content, metadata);
                }
                catch (SAXException e) {
                    throw new WebApplicationException(e);
                }
                catch (EncryptedDocumentException e) {
                    TikaResource.this.logger.warn(String.format("%s: Encrypted document", info.getPath()), e);
                    throw new WebApplicationException((Throwable)e, Response.status(422).build());
                }
                catch (TikaException e) {
                    TikaResource.this.logger.warn(String.format("%s: Text extraction failed", info.getPath()), e);
                    if (e.getCause() != null && e.getCause() instanceof WebApplicationException) {
                        throw (WebApplicationException)e.getCause();
                    }
                    if (e.getCause() != null && e.getCause() instanceof IllegalStateException) {
                        throw new WebApplicationException(Response.status(422).build());
                    }
                    if (e.getCause() != null && e.getCause() instanceof OldWordFileFormatException) {
                        throw new WebApplicationException(Response.status(422).build());
                    }
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                finally {
                    tis.close();
                }
            }
        };
    }

    public static void logRequest(Log logger, UriInfo info, Metadata metadata) {
        if (metadata.get("Content-Type") == null) {
            logger.info(String.format("%s (autodetecting type)", info.getPath()));
        } else {
            logger.info(String.format("%s (%s)", info.getPath(), metadata.get("Content-Type")));
        }
    }

    static {
        ExtractorFactory.setAllThreadsPreferEventExtractors(true);
    }
}

