/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.Tika;
import org.apache.tika.server.CSVMessageBodyWriter;
import org.apache.tika.server.JSONMessageBodyWriter;
import org.apache.tika.server.MetadataEP;
import org.apache.tika.server.MetadataResource;
import org.apache.tika.server.TarWriter;
import org.apache.tika.server.TikaExceptionMapper;
import org.apache.tika.server.TikaResource;
import org.apache.tika.server.TikaVersion;
import org.apache.tika.server.UnpackerResource;
import org.apache.tika.server.ZipWriter;

public class TikaServerCli {
    private static final Log logger = LogFactory.getLog(TikaServerCli.class);
    public static final int DEFAULT_PORT = 9998;
    public static final String DEFAULT_HOST = "localhost";

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("h", "host", true, "host name (default = localhost)");
        options.addOption("p", "port", true, "listen port (default = 9998)");
        options.addOption("h", "help", false, "this help message");
        return options;
    }

    public static void main(String[] args) {
        Properties properties = new Properties();
        try {
            properties.load(TikaServerCli.class.getClassLoader().getResourceAsStream("tikaserver-version.properties"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.info("Starting Tikaserver " + properties.getProperty("tikaserver.version"));
        logger.info("Starting Tika Server " + new Tika().toString());
        try {
            Options options = TikaServerCli.getOptions();
            GnuParser cliParser = new GnuParser();
            CommandLine line = cliParser.parse(options, args);
            if (line.hasOption("help")) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("tikaserver", options);
                System.exit(-1);
            }
            String host = DEFAULT_HOST;
            if (line.hasOption("host")) {
                host = line.getOptionValue("host");
            }
            int port = 9998;
            if (line.hasOption("port")) {
                port = Integer.valueOf(line.getOptionValue("port"));
            }
            JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
            sf.setResourceClasses(MetadataEP.class, MetadataResource.class, TikaResource.class, UnpackerResource.class, TikaVersion.class);
            ArrayList<Object> providers = new ArrayList<Object>();
            providers.add(new TarWriter());
            providers.add(new ZipWriter());
            providers.add(new CSVMessageBodyWriter());
            providers.add(new JSONMessageBodyWriter());
            providers.add(new TikaExceptionMapper());
            providers.add(new SingletonResourceProvider(new MetadataResource()));
            providers.add(new SingletonResourceProvider(new TikaResource()));
            providers.add(new SingletonResourceProvider(new UnpackerResource()));
            providers.add(new SingletonResourceProvider(new TikaVersion()));
            sf.setProviders(providers);
            sf.setAddress("http://" + host + ":" + port + "/");
            BindingFactoryManager manager = sf.getBus().getExtension(BindingFactoryManager.class);
            JAXRSBindingFactory factory = new JAXRSBindingFactory();
            factory.setBus(sf.getBus());
            manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", factory);
            sf.create();
            logger.info("Started");
        }
        catch (Exception ex) {
            logger.fatal("Can't start", ex);
            System.exit(-1);
        }
    }
}

