/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.test.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.definition.dao.DefinitionDAO;
import org.apache.tiles.request.locale.LocaleUtil;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class LocaleDbDefinitionDAO
extends JdbcDaoSupport
implements DefinitionDAO<Locale> {
    private static final String SELECT_CUSTOMIZATION_BY_NAME_SQL = "select ID, PARENT_ID, NAME from CUSTOMIZATION where NAME = ? ";
    private static final String SELECT_CUSTOMIZATION_BY_ID_SQL = "select ID, PARENT_ID, NAME from CUSTOMIZATION where ID = ? ";
    private static final String SELECT_DEFINITION_SQL = "select ID, PARENT_NAME, NAME, PREPARER, TEMPLATE from DEFINITION where NAME = ? and CUSTOMIZATION_ID = ? ";
    private static final String SELECT_ATTRIBUTES_SQL = "select ID, NAME, TYPE, VALUE, CASCADE_ATTRIBUTE from ATTRIBUTE where DEFINITION_ID = ? ";
    private final DefinitionRowMapper definitionRowMapper = new DefinitionRowMapper();

    public Definition getDefinition(String name, Locale locale) {
        List customizations = null;
        Long customizationId = null;
        Long parentCustomizationId = null;
        do {
            if (!(customizations = this.getJdbcTemplate().queryForList(SELECT_CUSTOMIZATION_BY_NAME_SQL, new Object[]{locale.toString()})).isEmpty()) {
                Map customization = (Map)customizations.get(0);
                customizationId = ((Number)customization.get("ID")).longValue();
                parentCustomizationId = LocaleDbDefinitionDAO.numberToLong((Number)customization.get("PARENT_ID"));
                continue;
            }
            locale = LocaleUtil.getParentLocale((Locale)locale);
        } while (customizations.isEmpty());
        return this.getDefinition(name, customizationId, parentCustomizationId, locale);
    }

    public Map<String, Definition> getDefinitions(Locale locale) {
        throw new UnsupportedOperationException("Currently the 'getDefinitions' method is not supported");
    }

    protected DbDefinition getDefinition(String name, Long baseCustomizationId, Long baseParentCustomizationId, Locale locale) {
        DbDefinition definition = null;
        Long customizationId = baseCustomizationId;
        Long parentCustomizationId = baseParentCustomizationId;
        List definitions = null;
        boolean finished = false;
        do {
            if ((definitions = this.getJdbcTemplate().query(SELECT_DEFINITION_SQL, new Object[]{name, customizationId}, (RowMapper)this.definitionRowMapper)).isEmpty()) {
                if (parentCustomizationId != null) {
                    Map customization = this.getJdbcTemplate().queryForMap(SELECT_CUSTOMIZATION_BY_ID_SQL, new Object[]{parentCustomizationId});
                    customizationId = ((Number)customization.get("ID")).longValue();
                    parentCustomizationId = LocaleDbDefinitionDAO.numberToLong((Number)customization.get("PARENT_ID"));
                    continue;
                }
                finished = true;
                continue;
            }
            definition = (DbDefinition)((Object)definitions.get(0));
            finished = true;
        } while (!finished);
        if (definition != null) {
            AttributeRowMapper attributeRowMapper = new AttributeRowMapper(definition);
            this.getJdbcTemplate().query(SELECT_ATTRIBUTES_SQL, new Object[]{definition.getId()}, (RowMapper)attributeRowMapper);
        }
        return definition;
    }

    private static Long numberToLong(Number number) {
        Long retValue = null;
        if (number != null) {
            retValue = number.longValue();
        }
        return retValue;
    }

    private static final class AttributeRowMapper
    implements RowMapper {
        private Definition definition;

        private AttributeRowMapper(Definition definition) {
            this.definition = definition;
        }

        public Object mapRow(ResultSet rs, int row) throws SQLException {
            Attribute attribute = new Attribute();
            attribute.setRenderer(rs.getString("TYPE"));
            attribute.setValue((Object)rs.getString("VALUE"));
            this.definition.putAttribute(rs.getString("NAME"), attribute, rs.getBoolean("CASCADE_ATTRIBUTE"));
            return attribute;
        }
    }

    private static final class DefinitionRowMapper
    implements RowMapper {
        private DefinitionRowMapper() {
        }

        public Object mapRow(ResultSet rs, int row) throws SQLException {
            DbDefinition definition = new DbDefinition();
            definition.setId(LocaleDbDefinitionDAO.numberToLong((Number)rs.getObject("ID")));
            definition.setName(rs.getString("NAME"));
            definition.setTemplateAttribute(Attribute.createTemplateAttribute((String)rs.getString("TEMPLATE")));
            definition.setPreparer(rs.getString("PREPARER"));
            definition.setExtends(rs.getString("PARENT_NAME"));
            return definition;
        }
    }

    private static class DbDefinition
    extends Definition {
        private Long id;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }
}

