/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.remote;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Host;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.process.remote.traversal.AbstractRemoteTraversalSideEffects;

public class DriverRemoteTraversalSideEffects
extends AbstractRemoteTraversalSideEffects {
    private final Client client;
    private Set<String> keys = Collections.emptySet();
    private final UUID serverSideEffect;
    private final Host host;
    private final Map<String, Object> sideEffects = new HashMap<String, Object>();
    private boolean closed = false;

    public DriverRemoteTraversalSideEffects(Client client, UUID serverSideEffect, Host host) {
        this.client = client;
        this.serverSideEffect = serverSideEffect;
        this.host = host;
    }

    public <V> V get(String key) throws IllegalArgumentException {
        if (!this.sideEffects.containsKey(key)) {
            if (!this.closed) {
                RequestMessage msg = RequestMessage.build("gather").addArg("sideEffect", this.serverSideEffect).addArg("sideEffectKey", key).addArg("host", this.host).processor("traversal").create();
                try {
                    Result result = this.client.submitAsync(msg).get().one();
                    this.sideEffects.put(key, null == result ? null : result.getObject());
                    if (this.keys.equals(Collections.emptySet())) {
                        this.keys = new HashSet<String>();
                    }
                    this.keys.add(key);
                }
                catch (Exception ex) {
                    String exMsg;
                    Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
                    String string = exMsg = null == root ? "" : root.getMessage();
                    if (exMsg.equals("Could not find side-effects for " + this.serverSideEffect + ".")) {
                        this.sideEffects.put(key, null);
                    }
                    throw new RuntimeException("Could not get keys", root);
                }
            } else {
                this.sideEffects.put(key, null);
            }
        }
        return (V)this.sideEffects.get(key);
    }

    public Set<String> keys() {
        block4: {
            if (!this.closed) {
                RequestMessage msg = RequestMessage.build("keys").addArg("sideEffect", this.serverSideEffect).addArg("host", this.host).processor("traversal").create();
                try {
                    if (this.keys.equals(Collections.emptySet())) {
                        this.keys = new HashSet<String>();
                    }
                    this.client.submitAsync(msg).get().all().get().forEach(r -> this.keys.add(r.getString()));
                }
                catch (Exception ex) {
                    String exMsg;
                    Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
                    String string = exMsg = null == root ? "" : root.getMessage();
                    if (exMsg.equals("Could not find side-effects for " + this.serverSideEffect + ".")) break block4;
                    throw new RuntimeException("Could not get keys", root);
                }
            }
        }
        return this.keys;
    }

    public void close() throws Exception {
        if (!this.closed) {
            RequestMessage msg = RequestMessage.build("close").addArg("sideEffect", this.serverSideEffect).addArg("host", this.host).processor("traversal").create();
            try {
                this.client.submitAsync(msg).get();
                this.closed = true;
            }
            catch (Exception ex) {
                Throwable root = ExceptionUtils.getRootCause((Throwable)ex);
                throw new RuntimeException("Error on closing side effects", root);
            }
        }
    }
}

