/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceEdge;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;

public class EdgeSerializer
extends SimpleTypeSerializer<Edge> {
    public EdgeSerializer() {
        super(DataType.EDGE);
    }

    @Override
    protected Edge readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        Object id = context.read(buffer);
        String label = context.readValue(buffer, String.class, false);
        ReferenceVertex inV = new ReferenceVertex(context.read(buffer), context.readValue(buffer, String.class, false));
        ReferenceVertex outV = new ReferenceVertex(context.read(buffer), context.readValue(buffer, String.class, false));
        context.read(buffer);
        context.read(buffer);
        return new ReferenceEdge(id, label, inV, outV);
    }

    @Override
    protected void writeValue(Edge value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.write(value.id(), buffer);
        context.writeValue(value.label(), buffer, false);
        context.write(value.inVertex().id(), buffer);
        context.writeValue(value.inVertex().label(), buffer, false);
        context.write(value.outVertex().id(), buffer);
        context.writeValue(value.outVertex().label(), buffer, false);
        context.write(null, buffer);
        context.write(null, buffer);
    }
}

