/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.LocalDate;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class LocalDateSerializer
extends SimpleTypeSerializer<LocalDate> {
    public LocalDateSerializer() {
        super(DataType.LOCALDATE);
    }

    @Override
    protected LocalDate readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return LocalDate.of(buffer.readInt(), buffer.readByte(), (int)buffer.readByte());
    }

    @Override
    protected void writeValue(LocalDate value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeInt(value.getYear()).writeByte(value.getMonthValue()).writeByte(value.getDayOfMonth());
    }
}

