/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.deploy.FileChangeListener;
import org.apache.catalina.ha.deploy.FileMessage;
import org.apache.catalina.ha.deploy.FileMessageFactory;
import org.apache.catalina.ha.deploy.UndeployMessage;
import org.apache.catalina.ha.deploy.WarWatcher;
import org.apache.catalina.tribes.Member;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

public class FarmWarDeployer
extends ClusterListener
implements ClusterDeployer,
FileChangeListener {
    private static final Log log = LogFactory.getLog(FarmWarDeployer.class);
    private static final String info = "FarmWarDeployer/1.2";
    protected CatalinaCluster cluster = null;
    protected boolean started = false;
    protected HashMap<String, FileMessageFactory> fileFactories = new HashMap();
    protected String deployDir;
    protected String tempDir;
    protected String watchDir;
    protected boolean watchEnabled = false;
    protected WarWatcher watcher = null;
    private int count = 0;
    protected int processDeployFrequency = 2;
    protected File configBase = null;
    protected Host host = null;
    protected File appBase = null;
    protected MBeanServer mBeanServer = null;
    protected ObjectName oname = null;

    public String getInfo() {
        return info;
    }

    @Override
    public void start() throws Exception {
        if (this.started) {
            return;
        }
        Container hcontainer = this.getCluster().getContainer();
        if (!(hcontainer instanceof Host)) {
            log.error((Object)"FarmWarDeployer can only work as host cluster subelement!");
            return;
        }
        this.host = (Host)hcontainer;
        Container econtainer = this.host.getParent();
        if (!(econtainer instanceof Engine)) {
            log.error((Object)("FarmWarDeployer can only work if parent of " + this.host.getName() + " is an engine!"));
            return;
        }
        Engine engine = (Engine)econtainer;
        String hostname = null;
        hostname = this.host.getName();
        try {
            this.oname = new ObjectName(engine.getName() + ":type=Deployer,host=" + hostname);
        }
        catch (Exception e) {
            log.error((Object)("Can't construct MBean object name" + e));
            return;
        }
        if (this.watchEnabled) {
            this.watcher = new WarWatcher(this, new File(this.getWatchDir()));
            if (log.isInfoEnabled()) {
                log.info((Object)("Cluster deployment is watching " + this.getWatchDir() + " for changes."));
            }
        }
        this.configBase = new File(System.getProperty("catalina.base"), "conf");
        if (engine != null) {
            this.configBase = new File(this.configBase, engine.getName());
        }
        if (this.host != null) {
            this.configBase = new File(this.configBase, hostname);
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
        this.started = true;
        this.count = 0;
        this.getCluster().addClusterListener(this);
        if (log.isInfoEnabled()) {
            log.info((Object)"Cluster FarmWarDeployer started.");
        }
    }

    @Override
    public void stop() throws LifecycleException {
        this.started = false;
        this.getCluster().removeClusterListener(this);
        this.count = 0;
        if (this.watcher != null) {
            this.watcher.clear();
            this.watcher = null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Cluster FarmWarDeployer stopped.");
        }
    }

    public void cleanDeployDir() {
        throw new UnsupportedOperationException("Method cleanDeployDir() not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ClusterMessage msg) {
        block23: {
            try {
                if (msg instanceof FileMessage) {
                    FileMessageFactory factory;
                    FileMessage fmsg = (FileMessage)msg;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("receive cluster deployment [ path: " + fmsg.getContextPath() + " war:  " + fmsg.getFileName() + " ]"));
                    }
                    if (!(factory = this.getFactory(fmsg)).writeMessage(fmsg)) break block23;
                    String name = factory.getFile().getName();
                    if (!name.endsWith(".war")) {
                        name = name + ".war";
                    }
                    File deployable = new File(this.getDeployDir(), name);
                    try {
                        String path = fmsg.getContextPath();
                        if (!this.isServiced(path)) {
                            this.addServiced(path);
                            try {
                                this.remove(path);
                                factory.getFile().renameTo(deployable);
                                this.check(path);
                            }
                            finally {
                                this.removeServiced(path);
                            }
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("deployment from " + path + " finished."));
                            }
                            break block23;
                        }
                        log.error((Object)("Application " + path + " in used. touch war file " + name + " again!"));
                        break block23;
                    }
                    catch (Exception ex) {
                        log.error((Object)ex);
                        break block23;
                    }
                    finally {
                        this.removeFactory(fmsg);
                    }
                }
                if (!(msg instanceof UndeployMessage)) break block23;
                try {
                    UndeployMessage umsg = (UndeployMessage)msg;
                    String path = umsg.getContextPath();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("receive cluster undeployment from " + path));
                    }
                    if (!this.isServiced(path)) {
                        this.addServiced(path);
                        try {
                            this.remove(path);
                        }
                        finally {
                            this.removeServiced(path);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("undeployment from " + path + " finished."));
                        }
                        break block23;
                    }
                    log.error((Object)("Application " + path + " in used. Sorry not remove from backup cluster nodes!"));
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
            catch (IOException x) {
                log.error((Object)"Unable to read farm deploy file message.", (Throwable)x);
            }
        }
    }

    public synchronized FileMessageFactory getFactory(FileMessage msg) throws FileNotFoundException, IOException {
        File tmpFile = new File(msg.getFileName());
        File writeToFile = new File(this.getTempDir(), tmpFile.getName());
        FileMessageFactory factory = this.fileFactories.get(msg.getFileName());
        if (factory == null) {
            factory = FileMessageFactory.getInstance(writeToFile, true);
            this.fileFactories.put(msg.getFileName(), factory);
        }
        return factory;
    }

    public void removeFactory(FileMessage msg) {
        this.fileFactories.remove(msg.getFileName());
    }

    @Override
    public boolean accept(ClusterMessage msg) {
        return msg instanceof FileMessage || msg instanceof UndeployMessage;
    }

    @Override
    public void install(String contextPath, URL war) throws IOException {
        Member[] members = this.getCluster().getMembers();
        Member localMember = this.getCluster().getLocalMember();
        FileMessageFactory factory = FileMessageFactory.getInstance(new File(war.getFile()), false);
        FileMessage msg = new FileMessage(localMember, war.getFile(), contextPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send cluster war deployment [ path:" + contextPath + " war: " + war + " ] started."));
        }
        msg = factory.readMessage(msg);
        while (msg != null) {
            for (int i = 0; i < members.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Send cluster war fragment [ path: " + contextPath + " war: " + war + " to: " + members[i] + " ]"));
                }
                this.getCluster().send(msg, members[i]);
            }
            msg = factory.readMessage(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send cluster war deployment [ path: " + contextPath + " war: " + war + " ] finished."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String contextPath, boolean undeploy) throws IOException {
        block9: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Cluster wide remove of web app " + contextPath));
            }
            Member localMember = this.getCluster().getLocalMember();
            UndeployMessage msg = new UndeployMessage(localMember, System.currentTimeMillis(), "Undeploy:" + contextPath + ":" + System.currentTimeMillis(), contextPath, undeploy);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Send cluster wide undeployment from " + contextPath));
            }
            this.cluster.send(msg);
            if (undeploy) {
                try {
                    if (!this.isServiced(contextPath)) {
                        this.addServiced(contextPath);
                        try {
                            this.remove(contextPath);
                            break block9;
                        }
                        finally {
                            this.removeServiced(contextPath);
                        }
                    }
                    log.error((Object)("Local remove from " + contextPath + "failed, other manager has app in service!"));
                }
                catch (Exception ex) {
                    log.error((Object)("local remove from " + contextPath + " failed"), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void fileModified(File newWar) {
        try {
            File deployWar = new File(this.getDeployDir(), newWar.getName());
            this.copy(newWar, deployWar);
            String contextName = this.getContextName(deployWar);
            if (log.isInfoEnabled()) {
                log.info((Object)("Installing webapp[" + contextName + "] from " + deployWar.getAbsolutePath()));
            }
            try {
                this.remove(contextName, false);
            }
            catch (Exception x) {
                log.error((Object)"No removal", (Throwable)x);
            }
            this.install(contextName, deployWar.toURI().toURL());
        }
        catch (Exception x) {
            log.error((Object)"Unable to install WAR file", (Throwable)x);
        }
    }

    @Override
    public void fileRemoved(File removeWar) {
        try {
            String contextName = this.getContextName(removeWar);
            if (log.isInfoEnabled()) {
                log.info((Object)("Removing webapp[" + contextName + "]"));
            }
            this.remove(contextName, true);
        }
        catch (Exception x) {
            log.error((Object)"Unable to remove WAR file", (Throwable)x);
        }
    }

    protected String getContextName(File war) {
        String contextName = "/" + war.getName().substring(0, war.getName().lastIndexOf(".war"));
        if ("/ROOT".equals(contextName)) {
            contextName = "";
        }
        return contextName;
    }

    protected File getAppBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected void remove(String path) throws Exception {
        Context context = (Context)this.host.findChild(path);
        if (context != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Undeploy local context " + path));
            }
            context.stop();
            String baseName = context.getBaseName();
            File war = new File(this.getAppBase(), baseName + ".war");
            File dir = new File(this.getAppBase(), baseName);
            File xml = new File(this.configBase, baseName + ".xml");
            if (war.exists()) {
                war.delete();
            } else if (dir.exists()) {
                this.undeployDir(dir);
            } else {
                xml.delete();
            }
            this.check(path);
        }
    }

    protected void undeployDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.undeployDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    @Override
    public void backgroundProcess() {
        if (this.started) {
            this.count = (this.count + 1) % this.processDeployFrequency;
            if (this.count == 0 && this.watchEnabled) {
                this.watcher.check();
            }
        }
    }

    protected void check(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", params, signature);
    }

    protected boolean isServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", params, signature);
        return result;
    }

    protected void addServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", params, signature);
    }

    protected void removeServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", params, signature);
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean equals(Object listener) {
        return super.equals(listener);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getDeployDir() {
        return this.deployDir;
    }

    public void setDeployDir(String deployDir) {
        this.deployDir = deployDir;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public String getWatchDir() {
        return this.watchDir;
    }

    public void setWatchDir(String watchDir) {
        this.watchDir = watchDir;
    }

    public boolean isWatchEnabled() {
        return this.watchEnabled;
    }

    public boolean getWatchEnabled() {
        return this.watchEnabled;
    }

    public void setWatchEnabled(boolean watchEnabled) {
        this.watchEnabled = watchEnabled;
    }

    public int getProcessDeployFrequency() {
        return this.processDeployFrequency;
    }

    public void setProcessDeployFrequency(int processExpiresFrequency) {
        if (processExpiresFrequency <= 0) {
            return;
        }
        this.processDeployFrequency = processExpiresFrequency;
    }

    protected boolean copy(File from, File to) {
        try {
            int len;
            if (!to.exists()) {
                to.createNewFile();
            }
            FileInputStream is = new FileInputStream(from);
            FileOutputStream os = new FileOutputStream(to, false);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
        }
        catch (IOException e) {
            log.error((Object)("Unable to copy file from:" + from + " to:" + to), (Throwable)e);
            return false;
        }
        return true;
    }
}

