/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.GSSRealm;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.X509SubjectDnRetriever;
import org.apache.catalina.realm.X509UsernameRetriever;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.catalina.util.SessionConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.MD5Encoder;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public abstract class RealmBase
extends LifecycleMBeanBase
implements GSSRealm {
    private static final Log log = LogFactory.getLog(RealmBase.class);
    protected Container container = null;
    protected Log containerLog = null;
    protected String digest = null;
    protected String digestEncoding = null;
    protected static final String info = "org.apache.catalina.realm.RealmBase/1.0";
    protected volatile MessageDigest md = null;
    @Deprecated
    protected static final MD5Encoder md5Encoder = new MD5Encoder();
    protected static volatile MessageDigest md5Helper;
    protected static final StringManager sm;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected boolean validate = true;
    protected String x509UsernameRetrieverClassName;
    protected X509UsernameRetriever x509UsernameRetriever;
    protected AllRolesMode allRolesMode = AllRolesMode.STRICT_MODE;
    protected boolean stripRealmForGss = true;
    private int transportGuaranteeRedirectStatus = 302;
    protected String realmPath = "/realm0";

    public int getTransportGuaranteeRedirectStatus() {
        return this.transportGuaranteeRedirectStatus;
    }

    public void setTransportGuaranteeRedirectStatus(int transportGuaranteeRedirectStatus) {
        this.transportGuaranteeRedirectStatus = transportGuaranteeRedirectStatus;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public String getAllRolesMode() {
        return this.allRolesMode.toString();
    }

    public void setAllRolesMode(String allRolesMode) {
        this.allRolesMode = AllRolesMode.toMode(allRolesMode);
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public String getDigestEncoding() {
        return this.digestEncoding;
    }

    public void setDigestEncoding(String charset) {
        this.digestEncoding = charset;
    }

    protected Charset getDigestCharset() throws UnsupportedEncodingException {
        if (this.digestEncoding == null) {
            return Charset.defaultCharset();
        }
        return B2CConverter.getCharset((String)this.getDigestEncoding());
    }

    @Override
    public String getInfo() {
        return info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getX509UsernameRetrieverClassName() {
        return this.x509UsernameRetrieverClassName;
    }

    public void setX509UsernameRetrieverClassName(String className) {
        this.x509UsernameRetrieverClassName = className;
    }

    public boolean isStripRealmForGss() {
        return this.stripRealmForGss;
    }

    public void setStripRealmForGss(boolean stripRealmForGss) {
        this.stripRealmForGss = stripRealmForGss;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Principal authenticate(String username) {
        if (username == null) {
            return null;
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", new Object[]{username}));
        }
        return this.getPrincipal(username);
    }

    @Override
    public Principal authenticate(String username, String credentials) {
        if (username == null || credentials == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{username}));
            }
            return null;
        }
        String serverCredentials = this.getPassword(username);
        if (serverCredentials == null) {
            this.compareCredentials(credentials, this.getClass().getName());
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{username}));
            }
            return null;
        }
        boolean validated = this.compareCredentials(credentials, serverCredentials);
        if (validated) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("realmBase.authenticateSuccess", new Object[]{username}));
            }
            return this.getPrincipal(username);
        }
        if (this.containerLog.isTraceEnabled()) {
            this.containerLog.trace((Object)sm.getString("realmBase.authenticateFailure", new Object[]{username}));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String username, String clientDigest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        String md5a1 = this.getDigest(username, realm);
        if (md5a1 == null) {
            return null;
        }
        md5a1 = md5a1.toLowerCase(Locale.ENGLISH);
        String serverDigestValue = qop == null ? md5a1 + ":" + nonce + ":" + md5a2 : md5a1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + md5a2;
        byte[] valueBytes = null;
        try {
            valueBytes = serverDigestValue.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
            throw new IllegalArgumentException(uee.getMessage());
        }
        String serverDigest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            serverDigest = MD5Encoder.encode((byte[])md5Helper.digest(valueBytes));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digest : " + clientDigest + " Username:" + username + " ClientDigest:" + clientDigest + " nonce:" + nonce + " nc:" + nc + " cnonce:" + cnonce + " qop:" + qop + " realm:" + realm + "md5a2:" + md5a2 + " Server digest:" + serverDigest));
        }
        if (serverDigest.equals(clientDigest)) {
            return this.getPrincipal(username);
        }
        return null;
    }

    @Override
    public Principal authenticate(X509Certificate[] certs) {
        if (certs == null || certs.length < 1) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Authenticating client certificate chain");
        }
        if (this.validate) {
            for (int i = 0; i < certs.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(" Checking validity for '" + certs[i].getSubjectDN().getName() + "'"));
                }
                try {
                    certs[i].checkValidity();
                    continue;
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Validity exception", (Throwable)e);
                    }
                    return null;
                }
            }
        }
        return this.getPrincipal(certs[0]);
    }

    @Override
    public Principal authenticate(GSSContext gssContext, boolean storeCred) {
        if (gssContext.isEstablished()) {
            GSSName gssName = null;
            try {
                gssName = gssContext.getSrcName();
            }
            catch (GSSException e) {
                log.warn((Object)sm.getString("realmBase.gssNameFail"), (Throwable)e);
            }
            if (gssName != null) {
                GSSCredential gssCredential = null;
                if (storeCred) {
                    if (gssContext.getCredDelegState()) {
                        try {
                            gssCredential = gssContext.getDelegCred();
                        }
                        catch (GSSException e) {
                            log.warn((Object)sm.getString("realmBase.delegatedCredentialFail", new Object[]{gssName}), (Throwable)e);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("realmBase.credentialNotDelegated", new Object[]{gssName}));
                    }
                }
                return this.getPrincipal(gssName, gssCredential);
            }
        } else {
            log.error((Object)sm.getString("realmBase.gssContextNotEstablished"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean compareCredentials(String userCredentials, String serverCredentials) {
        if (serverCredentials == null) {
            return false;
        }
        if (this.hasMessageDigest()) {
            if (serverCredentials.startsWith("{MD5}") || serverCredentials.startsWith("{SHA}")) {
                String userDigest;
                String serverDigest = serverCredentials.substring(5);
                RealmBase realmBase = this;
                synchronized (realmBase) {
                    this.md.reset();
                    this.md.update(userCredentials.getBytes(B2CConverter.ISO_8859_1));
                    userDigest = Base64.encodeBase64String((byte[])this.md.digest());
                }
                return userDigest.equals(serverDigest);
            }
            if (serverCredentials.startsWith("{SSHA}")) {
                byte[] userDigestBytes;
                String serverDigestPlusSalt = serverCredentials.substring(6);
                byte[] serverDigestPlusSaltBytes = Base64.decodeBase64((String)serverDigestPlusSalt);
                int saltPos = 20;
                byte[] serverDigestBytes = new byte[20];
                System.arraycopy(serverDigestPlusSaltBytes, 0, serverDigestBytes, 0, 20);
                RealmBase realmBase = this;
                synchronized (realmBase) {
                    this.md.reset();
                    this.md.update(userCredentials.getBytes(B2CConverter.ISO_8859_1));
                    this.md.update(serverDigestPlusSaltBytes, 20, serverDigestPlusSaltBytes.length - 20);
                    userDigestBytes = this.md.digest();
                }
                return Arrays.equals(userDigestBytes, serverDigestBytes);
            }
            String userDigest = this.digest(userCredentials);
            return serverCredentials.equalsIgnoreCase(userDigest);
        }
        return serverCredentials.equals(userCredentials);
    }

    @Override
    public Principal authenticate(GSSName gssName, GSSCredential gssCredential) {
        if (gssName == null) {
            return null;
        }
        return this.getPrincipal(gssName, gssCredential);
    }

    @Override
    public void backgroundProcess() {
    }

    @Override
    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        String pattern;
        int k;
        boolean matched;
        int i;
        ArrayList<SecurityConstraint> results = null;
        SecurityConstraint[] constraints = context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable constraints defined");
            }
            return null;
        }
        String uri = request.getRequestPathMB().toString();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        String method = request.getMethod();
        boolean found = false;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                for (int k2 = 0; k2 < patterns.length; ++k2) {
                    if (!uri.equals(patterns[k2]) && (patterns[k2].length() != 0 || !uri.equals("/"))) continue;
                    found = true;
                    if (!collection[j].findMethod(method)) continue;
                    if (results == null) {
                        results = new ArrayList<SecurityConstraint>();
                    }
                    results.add(constraints[i]);
                }
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        int longest = -1;
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                matched = false;
                int length = -1;
                for (k = 0; k < patterns.length; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("/") || !pattern.endsWith("/*") || pattern.length() < longest) continue;
                    if (pattern.length() == 2) {
                        matched = true;
                        length = pattern.length();
                        continue;
                    }
                    if (!pattern.regionMatches(0, uri, 0, pattern.length() - 1) && (pattern.length() - 2 != uri.length() || !pattern.regionMatches(0, uri, 0, pattern.length() - 2))) continue;
                    matched = true;
                    length = pattern.length();
                }
                if (!matched) continue;
                if (length > longest) {
                    found = false;
                    if (results != null) {
                        results.clear();
                    }
                    longest = length;
                }
                if (!collection[j].findMethod(method)) continue;
                found = true;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            boolean matched2 = false;
            int pos = -1;
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                for (k = 0; k < patterns.length && !matched2; ++k) {
                    pattern = patterns[k];
                    if (!pattern.startsWith("*.")) continue;
                    int slash = uri.lastIndexOf(47);
                    int dot = uri.lastIndexOf(46);
                    if (slash < 0 || dot <= slash || dot == uri.length() - 1 || uri.length() - dot != pattern.length() - 1 || !pattern.regionMatches(1, uri, dot, uri.length() - dot)) continue;
                    matched2 = true;
                    pos = j;
                }
            }
            if (!matched2) continue;
            found = true;
            if (!collection[pos].findMethod(method)) continue;
            if (results == null) {
                results = new ArrayList();
            }
            results.add(constraints[i]);
        }
        if (found) {
            return this.resultsToArray(results);
        }
        for (i = 0; i < constraints.length; ++i) {
            SecurityCollection[] collection = constraints[i].findCollections();
            if (collection == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking constraint '" + constraints[i] + "' against " + method + " " + uri + " --> " + constraints[i].included(uri, method)));
            }
            for (int j = 0; j < collection.length; ++j) {
                String[] patterns = collection[j].findPatterns();
                if (patterns == null) continue;
                matched = false;
                for (int k3 = 0; k3 < patterns.length && !matched; ++k3) {
                    String pattern2 = patterns[k3];
                    if (!pattern2.equals("/")) continue;
                    matched = true;
                }
                if (!matched) continue;
                if (results == null) {
                    results = new ArrayList();
                }
                results.add(constraints[i]);
            }
        }
        if (results == null && log.isDebugEnabled()) {
            log.debug((Object)"  No applicable constraint located");
        }
        return this.resultsToArray(results);
    }

    private SecurityConstraint[] resultsToArray(ArrayList<SecurityConstraint> results) {
        if (results == null || results.size() == 0) {
            return null;
        }
        SecurityConstraint[] array = new SecurityConstraint[results.size()];
        results.toArray(array);
        return array;
    }

    @Override
    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraints, Context context) throws IOException {
        String[] roles;
        SecurityConstraint constraint;
        int i;
        if (constraints == null || constraints.length == 0) {
            return true;
        }
        Principal principal = request.getPrincipal();
        boolean status = false;
        boolean denyfromall = false;
        for (i = 0; i < constraints.length; ++i) {
            constraint = constraints[i];
            roles = constraint.getAllRoles() ? request.getContext().findSecurityRoles() : constraint.findAuthRoles();
            if (roles == null) {
                roles = new String[]{};
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Checking roles " + principal));
            }
            if (roles.length == 0 && !constraint.getAllRoles()) {
                if (constraint.getAuthConstraint()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"No roles");
                    }
                    status = false;
                    denyfromall = true;
                    break;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Passing all access");
                }
                status = true;
                continue;
            }
            if (principal == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"  No user authenticated, cannot grant access");
                continue;
            }
            for (int j = 0; j < roles.length; ++j) {
                if (this.hasRole(request.getWrapper(), principal, roles[j])) {
                    status = true;
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Role found:  " + roles[j]));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No role found:  " + roles[j]));
            }
        }
        if (!denyfromall && this.allRolesMode != AllRolesMode.STRICT_MODE && !status && principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking for all roles mode: " + this.allRolesMode));
            }
            for (i = 0; i < constraints.length; ++i) {
                constraint = constraints[i];
                if (!constraint.getAllRoles()) continue;
                if (this.allRolesMode == AllRolesMode.AUTH_ONLY_MODE) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Granting access for role-name=*, auth-only");
                    }
                    status = true;
                    break;
                }
                roles = request.getContext().findSecurityRoles();
                if (roles.length != 0 || this.allRolesMode != AllRolesMode.STRICT_AUTH_ONLY_MODE) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Granting access for role-name=*, strict auth-only");
                }
                status = true;
                break;
            }
        }
        if (!status) {
            response.sendError(403, sm.getString("realmBase.forbidden"));
        }
        return status;
    }

    @Override
    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        String realRole;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        if (principal == null || role == null || !(principal instanceof GenericPrincipal)) {
            return false;
        }
        GenericPrincipal gp = (GenericPrincipal)principal;
        boolean result = gp.hasRole(role);
        if (log.isDebugEnabled()) {
            String name = principal.getName();
            if (result) {
                log.debug((Object)sm.getString("realmBase.hasRoleSuccess", new Object[]{name, role}));
            } else {
                log.debug((Object)sm.getString("realmBase.hasRoleFailure", new Object[]{name, role}));
            }
        }
        return result;
    }

    @Override
    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraints) throws IOException {
        String queryString;
        if (constraints == null || constraints.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  No applicable security constraint defined");
            }
            return true;
        }
        for (int i = 0; i < constraints.length; ++i) {
            SecurityConstraint constraint = constraints[i];
            String userConstraint = constraint.getUserConstraint();
            if (userConstraint == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  No applicable user data constraint defined");
                }
                return true;
            }
            if (!userConstraint.equals("NONE")) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint has no restrictions");
            }
            return true;
        }
        if (request.getRequest().isSecure()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  User data constraint already satisfied");
            }
            return true;
        }
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  SSL redirect is disabled");
            }
            response.sendError(403, request.getRequestURI());
            return false;
        }
        StringBuilder file = new StringBuilder();
        String protocol = "https";
        String host = request.getServerName();
        file.append(protocol).append("://").append(host);
        if (redirectPort != 443) {
            file.append(":").append(redirectPort);
        }
        file.append(request.getRequestURI());
        String requestedSessionId = request.getRequestedSessionId();
        if (requestedSessionId != null && request.isRequestedSessionIdFromURL()) {
            file.append(";");
            file.append(SessionConfig.getSessionUriParamName(request.getContext()));
            file.append("=");
            file.append(requestedSessionId);
        }
        if ((queryString = request.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("  Redirecting to " + file.toString()));
        }
        response.sendRedirect(file.toString(), this.transportGuaranteeRedirectStatus);
        return false;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.container != null) {
            this.containerLog = this.container.getLogger();
        }
        this.x509UsernameRetriever = RealmBase.createUsernameRetriever(this.x509UsernameRetrieverClassName);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (this.digest != null) {
            try {
                this.md = MessageDigest.getInstance(this.digest);
            }
            catch (NoSuchAlgorithmException e) {
                throw new LifecycleException(sm.getString("realmBase.algorithm", new Object[]{this.digest}), e);
            }
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.md = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Realm[");
        sb.append(this.getName());
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String digest(String credentials) {
        if (!this.hasMessageDigest()) {
            return credentials;
        }
        RealmBase realmBase = this;
        synchronized (realmBase) {
            try {
                this.md.reset();
                byte[] bytes = null;
                try {
                    bytes = credentials.getBytes(this.getDigestCharset());
                }
                catch (UnsupportedEncodingException uee) {
                    log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
                    throw new IllegalArgumentException(uee.getMessage());
                }
                this.md.update(bytes);
                return HexUtils.toHexString((byte[])this.md.digest());
            }
            catch (Exception e) {
                log.error((Object)sm.getString("realmBase.digest"), (Throwable)e);
                return credentials;
            }
        }
    }

    protected boolean hasMessageDigest() {
        return this.md != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDigest(String username, String realmName) {
        if (md5Helper == null) {
            try {
                md5Helper = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)"Couldn't get MD5 digest: ", (Throwable)e);
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (this.hasMessageDigest()) {
            return this.getPassword(username);
        }
        String digestValue = username + ":" + realmName + ":" + this.getPassword(username);
        byte[] valueBytes = null;
        try {
            valueBytes = digestValue.getBytes(this.getDigestCharset());
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)("Illegal digestEncoding: " + this.getDigestEncoding()), (Throwable)uee);
            throw new IllegalArgumentException(uee.getMessage());
        }
        byte[] digest = null;
        MessageDigest messageDigest = md5Helper;
        synchronized (messageDigest) {
            digest = md5Helper.digest(valueBytes);
        }
        return MD5Encoder.encode((byte[])digest);
    }

    protected abstract String getName();

    protected abstract String getPassword(String var1);

    protected Principal getPrincipal(X509Certificate usercert) {
        String username = this.x509UsernameRetriever.getUsername(usercert);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("realmBase.gotX509Username", new Object[]{username}));
        }
        return this.getPrincipal(username);
    }

    protected abstract Principal getPrincipal(String var1);

    @Deprecated
    protected Principal getPrincipal(String username, GSSCredential gssCredential) {
        Principal p = this.getPrincipal(username);
        if (p instanceof GenericPrincipal) {
            ((GenericPrincipal)p).setGssCredential(gssCredential);
        }
        return p;
    }

    protected Principal getPrincipal(GSSName gssName, GSSCredential gssCredential) {
        Principal p;
        int i;
        String name = ((Object)gssName).toString();
        if (this.isStripRealmForGss() && (i = name.indexOf(64)) > 0) {
            name = name.substring(0, i);
        }
        if ((p = this.getPrincipal(name)) instanceof GenericPrincipal) {
            ((GenericPrincipal)p).setGssCredential(gssCredential);
        }
        return p;
    }

    protected Server getServer() {
        Service s;
        Container c = this.container;
        if (c instanceof Context) {
            c = c.getParent();
        }
        if (c instanceof Host) {
            c = c.getParent();
        }
        if (c instanceof Engine && (s = ((Engine)c).getService()) != null) {
            return s.getServer();
        }
        return null;
    }

    public static final String Digest(String credentials, String algorithm, String encoding) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            if (encoding == null) {
                md.update(credentials.getBytes());
            } else {
                md.update(credentials.getBytes(encoding));
            }
            return HexUtils.toHexString((byte[])md.digest());
        }
        catch (Exception ex) {
            log.error((Object)ex);
            return credentials;
        }
    }

    public static void main(String[] args) {
        String encoding = null;
        int firstCredentialArg = 2;
        if (args.length > 4 && args[2].equalsIgnoreCase("-e")) {
            encoding = args[3];
            firstCredentialArg = 4;
        }
        if (args.length > firstCredentialArg && args[0].equalsIgnoreCase("-a")) {
            for (int i = firstCredentialArg; i < args.length; ++i) {
                System.out.print(args[i] + ":");
                System.out.println(RealmBase.Digest(args[i], args[1], encoding));
            }
        } else {
            System.out.println("Usage: RealmBase -a <algorithm> [-e <encoding>] <credentials>");
        }
    }

    @Override
    public String getObjectNameKeyProperties() {
        StringBuilder keyProperties = new StringBuilder("type=Realm");
        keyProperties.append(this.getRealmSuffix());
        keyProperties.append(MBeanUtils.getContainerKeyProperties(this.container));
        return keyProperties.toString();
    }

    @Override
    public String getDomainInternal() {
        return MBeanUtils.getDomain(this.container);
    }

    public String getRealmPath() {
        return this.realmPath;
    }

    public void setRealmPath(String theRealmPath) {
        this.realmPath = theRealmPath;
    }

    protected String getRealmSuffix() {
        return ",realmPath=" + this.getRealmPath();
    }

    private static X509UsernameRetriever createUsernameRetriever(String className) throws LifecycleException {
        if (null == className || "".equals(className.trim())) {
            return new X509SubjectDnRetriever();
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (X509UsernameRetriever)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.ClassNotFoundException", new Object[]{className}), e);
        }
        catch (InstantiationException e) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.InstantiationException", new Object[]{className}), e);
        }
        catch (IllegalAccessException e) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.IllegalAccessException", new Object[]{className}), e);
        }
        catch (ClassCastException e) {
            throw new LifecycleException(sm.getString("realmBase.createUsernameRetriever.ClassCastException", new Object[]{className}), e);
        }
    }

    static {
        sm = StringManager.getManager(RealmBase.class);
    }

    protected static class AllRolesMode {
        private final String name;
        public static final AllRolesMode STRICT_MODE = new AllRolesMode("strict");
        public static final AllRolesMode AUTH_ONLY_MODE = new AllRolesMode("authOnly");
        public static final AllRolesMode STRICT_AUTH_ONLY_MODE = new AllRolesMode("strictAuthOnly");

        static AllRolesMode toMode(String name) {
            AllRolesMode mode;
            if (name.equalsIgnoreCase(AllRolesMode.STRICT_MODE.name)) {
                mode = STRICT_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.AUTH_ONLY_MODE.name)) {
                mode = AUTH_ONLY_MODE;
            } else if (name.equalsIgnoreCase(AllRolesMode.STRICT_AUTH_ONLY_MODE.name)) {
                mode = STRICT_AUTH_ONLY_MODE;
            } else {
                throw new IllegalStateException("Unknown mode, must be one of: strict, authOnly, strictAuthOnly");
            }
            return mode;
        }

        private AllRolesMode(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            boolean equals = false;
            if (o instanceof AllRolesMode) {
                AllRolesMode mode = (AllRolesMode)o;
                equals = this.name.equals(mode.name);
            }
            return equals;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name;
        }
    }
}

