/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.apache.catalina.connector.CometEventImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.res.StringManager;

public class CometConnectionManagerValve
extends ValveBase
implements HttpSessionListener,
LifecycleListener {
    protected static final String info = "org.apache.catalina.valves.CometConnectionManagerValve/1.0";
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    protected List<Request> cometRequests = Collections.synchronizedList(new ArrayList());
    protected String cometRequestsAttribute = "org.apache.tomcat.comet.connectionList";

    public CometConnectionManagerValve() {
        super(false);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.container instanceof Context) {
            this.container.addLifecycleListener(this);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this.container instanceof Context) {
            this.container.removeLifecycleListener(this);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_stop".equals(event.getType())) {
            for (Request request : this.cometRequests) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.removeAttribute(this.cometRequestsAttribute);
                }
                try {
                    CometEventImpl cometEvent = request.getEvent();
                    cometEvent.setEventType(CometEvent.EventType.END);
                    cometEvent.setEventSubType(CometEvent.EventSubType.WEBAPP_RELOAD);
                    this.getNext().event(request, request.getResponse(), cometEvent);
                    cometEvent.close();
                }
                catch (Exception e) {
                    this.container.getLogger().warn((Object)sm.getString("cometConnectionManagerValve.event"), (Throwable)e);
                }
            }
            this.cometRequests.clear();
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (request.isComet() && !response.isClosed()) {
            HttpSession session = request.getSession(true);
            this.cometRequests.add(request);
            HttpSession httpSession = session;
            synchronized (httpSession) {
                Request[] requests = (Request[])session.getAttribute(this.cometRequestsAttribute);
                if (requests == null) {
                    requests = new Request[]{request};
                    session.setAttribute(this.cometRequestsAttribute, (Object)requests);
                } else {
                    Request[] newRequests = new Request[requests.length + 1];
                    for (int i = 0; i < requests.length; ++i) {
                        newRequests[i] = requests[i];
                    }
                    newRequests[requests.length] = request;
                    session.setAttribute(this.cometRequestsAttribute, (Object)newRequests);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        block35: {
            boolean ok = false;
            try {
                this.getNext().event(request, response, event);
                ok = true;
                if (ok && !response.isClosed() && event.getEventType() != CometEvent.EventType.END && (event.getEventType() != CometEvent.EventType.ERROR || event.getEventSubType() == CometEvent.EventSubType.TIMEOUT)) break block35;
                this.cometRequests.remove(request);
            }
            catch (Throwable throwable) {
                if (!ok || response.isClosed() || event.getEventType() == CometEvent.EventType.END || event.getEventType() == CometEvent.EventType.ERROR && event.getEventSubType() != CometEvent.EventSubType.TIMEOUT) {
                    this.cometRequests.remove(request);
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        HttpSession httpSession = session;
                        synchronized (httpSession) {
                            Request[] reqs = null;
                            try {
                                reqs = (Request[])session.getAttribute(this.cometRequestsAttribute);
                            }
                            catch (IllegalStateException ise) {
                                // empty catch block
                            }
                            if (reqs != null) {
                                boolean found = false;
                                for (int i = 0; !found && i < reqs.length; ++i) {
                                    found = reqs[i] == request;
                                }
                                if (found) {
                                    if (reqs.length > 1) {
                                        Request[] newConnectionInfos = new Request[reqs.length - 1];
                                        int pos = 0;
                                        for (int i = 0; i < reqs.length; ++i) {
                                            if (reqs[i] == request) continue;
                                            newConnectionInfos[pos++] = reqs[i];
                                        }
                                        try {
                                            session.setAttribute(this.cometRequestsAttribute, (Object)newConnectionInfos);
                                        }
                                        catch (IllegalStateException ise) {}
                                    } else {
                                        try {
                                            session.removeAttribute(this.cometRequestsAttribute);
                                        }
                                        catch (IllegalStateException ise) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                throw throwable;
            }
            HttpSession session = request.getSession(false);
            if (session != null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    Request[] reqs = null;
                    try {
                        reqs = (Request[])session.getAttribute(this.cometRequestsAttribute);
                    }
                    catch (IllegalStateException ise) {
                        // empty catch block
                    }
                    if (reqs != null) {
                        boolean found = false;
                        for (int i = 0; !found && i < reqs.length; ++i) {
                            found = reqs[i] == request;
                        }
                        if (found) {
                            if (reqs.length > 1) {
                                Request[] newConnectionInfos = new Request[reqs.length - 1];
                                int pos = 0;
                                for (int i = 0; i < reqs.length; ++i) {
                                    if (reqs[i] == request) continue;
                                    newConnectionInfos[pos++] = reqs[i];
                                }
                                try {
                                    session.setAttribute(this.cometRequestsAttribute, (Object)newConnectionInfos);
                                }
                                catch (IllegalStateException ise) {}
                            } else {
                                try {
                                    session.removeAttribute(this.cometRequestsAttribute);
                                }
                                catch (IllegalStateException ise) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        Request[] reqs = (Request[])se.getSession().getAttribute(this.cometRequestsAttribute);
        if (reqs != null) {
            for (int i = 0; i < reqs.length; ++i) {
                Request req = reqs[i];
                try {
                    CometEventImpl event = req.getEvent();
                    event.setEventType(CometEvent.EventType.END);
                    event.setEventSubType(CometEvent.EventSubType.SESSION_END);
                    ((CometProcessor)req.getWrapper().getServlet()).event(event);
                    event.close();
                    continue;
                }
                catch (Exception e) {
                    req.getWrapper().getParent().getLogger().warn((Object)sm.getString("cometConnectionManagerValve.listenerEvent"), (Throwable)e);
                }
            }
        }
    }
}

