/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.Session;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class ManagerServlet
extends HttpServlet
implements ContainerServlet {
    protected File configBase = null;
    protected Context context = null;
    protected int debug = 1;
    protected File deployed = null;
    protected File versioned = null;
    protected File contextDescriptors = null;
    protected Host host = null;
    protected File appBase = null;
    protected MBeanServer mBeanServer = null;
    protected ObjectName oname = null;
    protected javax.naming.Context global = null;
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.manager");
    protected Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.host = null;
            this.oname = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.host = (Host)this.context.getParent();
            Engine engine = (Engine)this.host.getParent();
            try {
                this.oname = new ObjectName(engine.getName() + ":type=Deployer,host=" + this.host.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public void destroy() {
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String config = request.getParameter("config");
        String path = request.getParameter("path");
        String type = request.getParameter("type");
        String war = request.getParameter("war");
        String tag = request.getParameter("tag");
        boolean update = false;
        if (request.getParameter("update") != null && request.getParameter("update").equals("true")) {
            update = true;
        }
        response.setContentType("text/plain; charset=utf-8");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(sm.getString("managerServlet.noCommand"));
        } else if (command.equals("/deploy")) {
            if (war != null || config != null) {
                this.deploy(writer, config, path, war, update);
            } else {
                this.deploy(writer, path, tag);
            }
        } else if (command.equals("/list")) {
            this.list(writer);
        } else if (command.equals("/reload")) {
            this.reload(writer, path);
        } else if (command.equals("/resources")) {
            this.resources(writer, type);
        } else if (command.equals("/roles")) {
            this.roles(writer);
        } else if (command.equals("/save")) {
            this.save(writer, path);
        } else if (command.equals("/serverinfo")) {
            this.serverinfo(writer);
        } else if (command.equals("/sessions")) {
            this.expireSessions(writer, path, request);
        } else if (command.equals("/expire")) {
            this.expireSessions(writer, path, request);
        } else if (command.equals("/start")) {
            this.start(writer, path);
        } else if (command.equals("/stop")) {
            this.stop(writer, path);
        } else if (command.equals("/undeploy")) {
            this.undeploy(writer, path);
        } else if (command.equals("/findleaks")) {
            this.findleaks(writer);
        } else {
            writer.println(sm.getString("managerServlet.unknownCommand", new Object[]{command}));
        }
        writer.flush();
        writer.close();
    }

    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String path = request.getParameter("path");
        String tag = request.getParameter("tag");
        boolean update = false;
        if (request.getParameter("update") != null && request.getParameter("update").equals("true")) {
            update = true;
        }
        response.setContentType("text/plain;charset=utf-8");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(sm.getString("managerServlet.noCommand"));
        } else if (command.equals("/deploy")) {
            this.deploy(writer, path, tag, update, request);
        } else {
            writer.println(sm.getString("managerServlet.unknownCommand", new Object[]{command}));
        }
        writer.flush();
        writer.close();
    }

    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("managerServlet.noWrapper"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
        }
        Server server = ((Engine)this.host.getParent()).getService().getServer();
        if (server != null && server instanceof StandardServer) {
            this.global = ((StandardServer)server).getGlobalNamingContext();
        }
        this.versioned = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        String appBase = ((Host)this.context.getParent()).getAppBase();
        this.deployed = new File(appBase);
        if (!this.deployed.isAbsolute()) {
            this.deployed = new File(System.getProperty("catalina.base"), appBase);
        }
        this.configBase = new File(System.getProperty("catalina.base"), "conf");
        Context host = null;
        Context engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            this.configBase = new File(this.configBase, engine.getName());
        }
        if (host != null) {
            this.configBase = new File(this.configBase, host.getName());
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.oname + "'");
            if (this.global != null) {
                this.log("init: Global resources are available");
            }
        }
    }

    protected void findleaks(PrintWriter writer) {
        String[] results;
        if (!(this.host instanceof StandardHost)) {
            writer.println(sm.getString("managerServlet.findleaksFail"));
            return;
        }
        for (String result : results = ((StandardHost)this.host).findReloadedContextMemoryLeaks()) {
            if ("".equals(result)) {
                result = "/";
            }
            writer.println(result);
        }
    }

    protected synchronized void save(PrintWriter writer, String path) {
        Context context;
        Server server = ((Engine)this.host.getParent()).getService().getServer();
        if (!(server instanceof StandardServer)) {
            writer.println(sm.getString("managerServlet.saveFail", new Object[]{server}));
            return;
        }
        if (path == null || path.length() == 0 || !path.startsWith("/")) {
            try {
                ((StandardServer)server).storeConfig();
                writer.println(sm.getString("managerServlet.saved"));
            }
            catch (Exception e) {
                this.log("managerServlet.storeConfig", e);
                writer.println(sm.getString("managerServlet.exception", new Object[]{e.toString()}));
                return;
            }
        }
        String contextPath = path;
        if (path.equals("/")) {
            contextPath = "";
        }
        if ((context = (Context)this.host.findChild(contextPath)) == null) {
            writer.println(sm.getString("managerServlet.noContext", new Object[]{path}));
            return;
        }
        try {
            ((StandardServer)server).storeContext(context);
            writer.println(sm.getString("managerServlet.savedContext", new Object[]{path}));
        }
        catch (Exception e) {
            this.log("managerServlet.save[" + path + "]", e);
            writer.println(sm.getString("managerServlet.exception", new Object[]{e.toString()}));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deploy(PrintWriter writer, String path, String tag, boolean update, HttpServletRequest request) {
        Context context;
        String displayPath;
        block16: {
            if (this.debug >= 1) {
                this.log("deploy: Deploying web application at '" + path + "'");
            }
            if (path == null || path.length() == 0 || !path.startsWith("/")) {
                writer.println(sm.getString("managerServlet.invalidPath", new Object[]{path}));
                return;
            }
            displayPath = path;
            if (path.equals("/")) {
                path = "";
            }
            String basename = this.getDocBase(path);
            context = (Context)this.host.findChild(path);
            if (update) {
                if (context != null) {
                    this.undeploy(writer, displayPath);
                }
                context = (Context)this.host.findChild(path);
            }
            if (context != null) {
                writer.println(sm.getString("managerServlet.alreadyContext", new Object[]{displayPath}));
                return;
            }
            File deployedPath = this.deployed;
            if (tag != null) {
                deployedPath = new File(this.versioned, tag);
                deployedPath.mkdirs();
            }
            File localWar = new File(deployedPath, basename + ".war");
            if (this.debug >= 2) {
                this.log("Uploading WAR file to " + localWar);
            }
            try {
                if (this.isServiced(path)) break block16;
                this.addServiced(path);
                try {
                    this.uploadWar(request, localWar);
                    if (tag != null) {
                        deployedPath = this.deployed;
                        File localWarCopy = new File(deployedPath, basename + ".war");
                        ManagerServlet.copy(localWar, localWarCopy);
                        localWar = localWarCopy;
                        ManagerServlet.copy(localWar, new File(this.getAppBase(), basename + ".war"));
                    }
                    this.check(path);
                }
                finally {
                    this.removeServiced(path);
                }
            }
            catch (Exception e) {
                this.log("managerServlet.check[" + displayPath + "]", e);
                writer.println(sm.getString("managerServlet.exception", new Object[]{e.toString()}));
                return;
            }
        }
        context = (Context)this.host.findChild(path);
        if (context != null && context.getConfigured()) {
            writer.println(sm.getString("managerServlet.deployed", new Object[]{displayPath}));
        } else {
            writer.println(sm.getString("managerServlet.deployFailed", new Object[]{displayPath}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter writer, String path, String tag) {
        Context context;
        String displayPath;
        block11: {
            if (path == null || path.length() == 0 || !path.startsWith("/")) {
                writer.println(sm.getString("managerServlet.invalidPath", new Object[]{path}));
                return;
            }
            displayPath = path;
            if (path.equals("/")) {
                path = "";
            }
            File deployedPath = this.versioned;
            if (tag != null) {
                deployedPath = new File(deployedPath, tag);
            }
            File localWar = new File(deployedPath, this.getDocBase(path) + ".war");
            context = (Context)this.host.findChild(path);
            if (context != null) {
                this.undeploy(writer, displayPath);
            }
            try {
                if (this.isServiced(path)) break block11;
                this.addServiced(path);
                try {
                    ManagerServlet.copy(localWar, new File(this.getAppBase(), this.getDocBase(path) + ".war"));
                    this.check(path);
                }
                finally {
                    this.removeServiced(path);
                }
            }
            catch (Exception e) {
                this.log("managerServlet.check[" + displayPath + "]", e);
                writer.println(sm.getString("managerServlet.exception", new Object[]{e.toString()}));
                return;
            }
        }
        context = (Context)this.host.findChild(path);
        if (context != null && context.getConfigured()) {
            writer.println(sm.getString("managerServlet.deployed", new Object[]{displayPath}));
        } else {
            writer.println(sm.getString("managerServlet.deployFailed", new Object[]{displayPath}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter writer, String config, String path, String war, boolean update) {
        if (config != null && config.length() == 0) {
            config = null;
        }
        if (war != null && war.length() == 0) {
            war = null;
        }
        if (this.debug >= 1) {
            if (config != null && config.length() > 0) {
                if (war != null) {
                    this.log("install: Installing context configuration at '" + config + "' from '" + war + "'");
                } else {
                    this.log("install: Installing context configuration at '" + config + "'");
                }
            } else if (path != null && path.length() > 0) {
                this.log("install: Installing web application at '" + path + "' from '" + war + "'");
            } else {
                this.log("install: Installing web application from '" + war + "'");
            }
        }
        if (path == null || path.length() == 0 || !path.startsWith("/")) {
            writer.println(sm.getString("managerServlet.invalidPath", new Object[]{RequestUtil.filter(path)}));
            return;
        }
        String displayPath = path;
        if ("/".equals(path)) {
            path = "";
        }
        Context context = (Context)this.host.findChild(path);
        if (update) {
            if (context != null) {
                this.undeploy(writer, displayPath);
            }
            context = (Context)this.host.findChild(path);
        }
        if (context != null) {
            writer.println(sm.getString("managerServlet.alreadyContext", new Object[]{displayPath}));
            return;
        }
        if (config != null && config.startsWith("file:")) {
            config = config.substring("file:".length());
        }
        if (war != null && war.startsWith("file:")) {
            war = war.substring("file:".length());
        }
        try {
            if (!this.isServiced(path)) {
                this.addServiced(path);
                try {
                    if (config != null) {
                        this.configBase.mkdirs();
                        ManagerServlet.copy(new File(config), new File(this.configBase, this.getConfigFile(path) + ".xml"));
                    }
                    if (war != null) {
                        if (war.endsWith(".war")) {
                            ManagerServlet.copy(new File(war), new File(this.getAppBase(), this.getDocBase(path) + ".war"));
                        } else {
                            ManagerServlet.copy(new File(war), new File(this.getAppBase(), this.getDocBase(path)));
                        }
                    }
                    this.check(path);
                }
                finally {
                    this.removeServiced(path);
                }
            }
            if ((context = (Context)this.host.findChild(path)) != null && context.getConfigured() && context.getAvailable()) {
                writer.println(sm.getString("managerServlet.deployed", new Object[]{displayPath}));
            } else if (context != null && !context.getAvailable()) {
                writer.println(sm.getString("managerServlet.deployedButNotStarted", new Object[]{displayPath}));
            } else {
                writer.println(sm.getString("managerServlet.deployFailed", new Object[]{displayPath}));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log("ManagerServlet.install[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    protected void list(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        writer.println(sm.getString("managerServlet.listed", new Object[]{this.host.getName()}));
        Container[] contexts = this.host.findChildren();
        for (int i = 0; i < contexts.length; ++i) {
            Context context = (Context)contexts[i];
            if (context == null) continue;
            String displayPath = context.getPath();
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context.getAvailable()) {
                writer.println(sm.getString("managerServlet.listitem", new Object[]{displayPath, "running", "" + context.getManager().findSessions().length, context.getDocBase()}));
                continue;
            }
            writer.println(sm.getString("managerServlet.listitem", new Object[]{displayPath, "stopped", "0", context.getDocBase()}));
        }
    }

    protected void reload(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", new Object[]{RequestUtil.filter(path)}));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = (Context)this.host.findChild(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(displayPath)}));
                return;
            }
            if (context.getPath().equals(this.context.getPath())) {
                writer.println(sm.getString("managerServlet.noSelf"));
                return;
            }
            context.reload();
            writer.println(sm.getString("managerServlet.reloaded", new Object[]{displayPath}));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log("ManagerServlet.reload[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    protected void resources(PrintWriter writer, String type) {
        if (this.debug >= 1) {
            if (type != null) {
                this.log("resources:  Listing resources of type " + type);
            } else {
                this.log("resources:  Listing resources of all types");
            }
        }
        if (this.global == null) {
            writer.println(sm.getString("managerServlet.noGlobal"));
            return;
        }
        if (type != null) {
            writer.println(sm.getString("managerServlet.resourcesType", new Object[]{type}));
        } else {
            writer.println(sm.getString("managerServlet.resourcesAll"));
        }
        Class<?> clazz = null;
        try {
            if (type != null) {
                clazz = Class.forName(type);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log("ManagerServlet.resources[" + type + "]", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
            return;
        }
        this.printResources(writer, "", this.global, type, clazz);
    }

    protected void printResources(PrintWriter writer, String prefix, javax.naming.Context namingContext, String type, Class<?> clazz) {
        try {
            NamingEnumeration<Binding> items = namingContext.listBindings("");
            while (items.hasMore()) {
                Binding item = items.next();
                if (item.getObject() instanceof javax.naming.Context) {
                    this.printResources(writer, prefix + item.getName() + "/", (javax.naming.Context)item.getObject(), type, clazz);
                    continue;
                }
                if (clazz != null && !clazz.isInstance(item.getObject())) continue;
                writer.print(prefix + item.getName());
                writer.print(':');
                writer.print(item.getClassName());
                writer.println();
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log("ManagerServlet.resources[" + type + "]", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    protected void roles(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("roles:  List security roles from user database");
        }
        UserDatabase database = null;
        try {
            InitialContext ic = new InitialContext();
            database = (UserDatabase)ic.lookup("java:comp/env/users");
        }
        catch (NamingException e) {
            writer.println(sm.getString("managerServlet.userDatabaseError"));
            this.log("java:comp/env/users", e);
            return;
        }
        if (database == null) {
            writer.println(sm.getString("managerServlet.userDatabaseMissing"));
            return;
        }
        writer.println(sm.getString("managerServlet.rolesList"));
        Iterator<Role> roles = database.getRoles();
        if (roles != null) {
            while (roles.hasNext()) {
                Role role = roles.next();
                writer.print(role.getRolename());
                writer.print(':');
                if (role.getDescription() != null) {
                    writer.print(role.getDescription());
                }
                writer.println();
            }
        }
    }

    protected void serverinfo(PrintWriter writer) {
        if (this.debug >= 1) {
            this.log("serverinfo");
        }
        try {
            StringBuilder props = new StringBuilder();
            props.append("OK - Server info");
            props.append("\nTomcat Version: ");
            props.append(ServerInfo.getServerInfo());
            props.append("\nOS Name: ");
            props.append(System.getProperty("os.name"));
            props.append("\nOS Version: ");
            props.append(System.getProperty("os.version"));
            props.append("\nOS Architecture: ");
            props.append(System.getProperty("os.arch"));
            props.append("\nJVM Version: ");
            props.append(System.getProperty("java.runtime.version"));
            props.append("\nJVM Vendor: ");
            props.append(System.getProperty("java.vm.vendor"));
            writer.println(props.toString());
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.getServletContext().log("ManagerServlet.serverinfo", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    protected void sessions(PrintWriter writer, String path, int idle) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application at '" + path + "'");
            if (idle >= 0) {
                this.log("sessions: Session expiration for " + idle + " minutes '" + path + "'");
            }
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", new Object[]{RequestUtil.filter(path)}));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            int i;
            Context context = (Context)this.host.findChild(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(displayPath)}));
                return;
            }
            Manager manager = context.getManager();
            if (manager == null) {
                writer.println(sm.getString("managerServlet.noManager", new Object[]{RequestUtil.filter(displayPath)}));
                return;
            }
            int maxCount = 60;
            int maxInactiveInterval = manager.getMaxInactiveInterval() / 60;
            int histoInterval = maxInactiveInterval / maxCount;
            if (histoInterval * maxCount < maxInactiveInterval) {
                ++histoInterval;
            }
            if (0 == histoInterval) {
                histoInterval = 1;
            }
            if (histoInterval * (maxCount = maxInactiveInterval / histoInterval) < maxInactiveInterval) {
                ++maxCount;
            }
            writer.println(sm.getString("managerServlet.sessions", new Object[]{displayPath}));
            writer.println(sm.getString("managerServlet.sessiondefaultmax", new Object[]{"" + maxInactiveInterval}));
            Session[] sessions = manager.findSessions();
            int[] timeout = new int[maxCount];
            int notimeout = 0;
            int expired = 0;
            long now = System.currentTimeMillis();
            for (i = 0; i < sessions.length; ++i) {
                int time = (int)((now - sessions[i].getThisAccessedTimeInternal()) / 1000L);
                if (idle >= 0 && time >= idle * 60) {
                    sessions[i].expire();
                    ++expired;
                }
                if ((time = time / 60 / histoInterval) < 0) {
                    ++notimeout;
                    continue;
                }
                if (time >= maxCount) {
                    int n = maxCount - 1;
                    timeout[n] = timeout[n] + 1;
                    continue;
                }
                int n = time;
                timeout[n] = timeout[n] + 1;
            }
            if (timeout[0] > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", new Object[]{"<" + histoInterval, "" + timeout[0]}));
            }
            for (i = 1; i < maxCount - 1; ++i) {
                if (timeout[i] <= 0) continue;
                writer.println(sm.getString("managerServlet.sessiontimeout", new Object[]{"" + i * histoInterval + " - <" + (i + 1) * histoInterval, "" + timeout[i]}));
            }
            if (timeout[maxCount - 1] > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout", new Object[]{">=" + maxCount * histoInterval, "" + timeout[maxCount - 1]}));
            }
            if (notimeout > 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout.unlimited", new Object[]{"" + notimeout}));
            }
            if (idle >= 0) {
                writer.println(sm.getString("managerServlet.sessiontimeout.expired", new Object[]{"" + idle, "" + expired}));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log("ManagerServlet.sessions[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    protected void sessions(PrintWriter writer, String path) {
        this.sessions(writer, path, -1);
    }

    protected void expireSessions(PrintWriter writer, String path, HttpServletRequest req) {
        int idle = -1;
        String idleParam = req.getParameter("idle");
        if (idleParam != null) {
            try {
                idle = Integer.parseInt(idleParam);
            }
            catch (NumberFormatException e) {
                this.log("Could not parse idle parameter to an int: " + idleParam);
            }
        }
        this.sessions(writer, path, idle);
    }

    protected void start(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("start: Starting web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", new Object[]{RequestUtil.filter(path)}));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = (Context)this.host.findChild(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(displayPath)}));
                return;
            }
            context.start();
            if (context.getAvailable()) {
                writer.println(sm.getString("managerServlet.started", new Object[]{displayPath}));
            } else {
                writer.println(sm.getString("managerServlet.startFailed", new Object[]{displayPath}));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.getServletContext().log(sm.getString("managerServlet.startFailed", new Object[]{displayPath}), t);
            writer.println(sm.getString("managerServlet.startFailed", new Object[]{displayPath}));
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    protected void stop(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", new Object[]{RequestUtil.filter(path)}));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = (Context)this.host.findChild(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(displayPath)}));
                return;
            }
            if (context.getPath().equals(this.context.getPath())) {
                writer.println(sm.getString("managerServlet.noSelf"));
                return;
            }
            context.stop();
            writer.println(sm.getString("managerServlet.stopped", new Object[]{displayPath}));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log("ManagerServlet.stop[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy(PrintWriter writer, String path) {
        if (this.debug >= 1) {
            this.log("undeploy: Undeploying web application at '" + path + "'");
        }
        if (path == null || !path.startsWith("/") && path.equals("")) {
            writer.println(sm.getString("managerServlet.invalidPath", new Object[]{RequestUtil.filter(path)}));
            return;
        }
        String displayPath = path;
        if (path.equals("/")) {
            path = "";
        }
        try {
            Context context = (Context)this.host.findChild(path);
            if (context == null) {
                writer.println(sm.getString("managerServlet.noContext", new Object[]{RequestUtil.filter(displayPath)}));
                return;
            }
            if (!this.isDeployed(path)) {
                writer.println(sm.getString("managerServlet.notDeployed", new Object[]{RequestUtil.filter(displayPath)}));
                return;
            }
            if (!this.isServiced(path)) {
                this.addServiced(path);
                try {
                    context.stop();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                }
                try {
                    if (path.lastIndexOf(47) > 0) {
                        path = "/" + path.substring(1).replace('/', '#');
                    }
                    File war = new File(this.getAppBase(), this.getDocBase(path) + ".war");
                    File dir = new File(this.getAppBase(), this.getDocBase(path));
                    File xml = new File(this.configBase, this.getConfigFile(path) + ".xml");
                    if (war.exists()) {
                        war.delete();
                    } else if (dir.exists()) {
                        this.undeployDir(dir);
                    } else {
                        xml.delete();
                    }
                    this.check(path.replace('#', '/'));
                }
                finally {
                    this.removeServiced(path.replace('#', '/'));
                }
            }
            writer.println(sm.getString("managerServlet.undeployed", new Object[]{displayPath}));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.log("ManagerServlet.undeploy[" + displayPath + "]", t);
            writer.println(sm.getString("managerServlet.exception", new Object[]{t.toString()}));
        }
    }

    protected String getConfigFile(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected String getDocBase(String path) {
        String basename = null;
        basename = path.equals("") ? "ROOT" : path.substring(1).replace('/', '#');
        return basename;
    }

    protected File getAppBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected boolean isDeployed(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isDeployed", params, signature);
        return result;
    }

    protected void check(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", params, signature);
    }

    protected boolean isServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", params, signature);
        return result;
    }

    protected void addServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", params, signature);
    }

    protected void removeServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", params, signature);
    }

    protected void undeployDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.undeployDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    protected void uploadWar(HttpServletRequest request, File war) throws IOException {
        war.delete();
        ServletInputStream istream = null;
        FilterOutputStream ostream = null;
        try {
            int n;
            istream = request.getInputStream();
            ostream = new BufferedOutputStream(new FileOutputStream(war), 1024);
            byte[] buffer = new byte[1024];
            while ((n = istream.read(buffer)) >= 0) {
                ((BufferedOutputStream)ostream).write(buffer, 0, n);
            }
            ((BufferedOutputStream)ostream).flush();
            ostream.close();
            ostream = null;
            istream.close();
            istream = null;
        }
        catch (IOException e) {
            war.delete();
            throw e;
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                }
                ostream = null;
            }
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                }
                istream = null;
            }
        }
    }

    public static boolean copy(File src, File dest) {
        boolean result = false;
        try {
            if (src != null && !src.getCanonicalPath().equals(dest.getCanonicalPath())) {
                result = ManagerServlet.copyInternal(src, dest, new byte[4096]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyInternal(File src, File dest, byte[] buf) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        block17: for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ManagerServlet.copyInternal(fileSrc, fileDest, buf);
                continue;
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                is = new FileInputStream(fileSrc);
                os = new FileOutputStream(fileDest);
                int len = 0;
                while (true) {
                    if ((len = is.read(buf)) == -1) {
                        continue block17;
                    }
                    os.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = false;
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return result;
    }
}

