/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractArchiveResourceSet;
import org.apache.catalina.webresources.JarResource;

public class JarResourceSet
extends AbstractArchiveResourceSet {
    public JarResourceSet() {
    }

    public JarResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) throws IllegalArgumentException {
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        this.setInternalPath(internalPath);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    protected WebResource createArchiveResource(JarEntry jarEntry, String webAppPath) {
        return new JarResource(this.getRoot(), webAppPath, this.getBase(), this.getBaseUrl(), jarEntry, this.getInternalPath());
    }

    @Override
    protected void initInternal() throws LifecycleException {
        try (JarFile jarFile = new JarFile(this.getBase());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                this.getJarFileEntries().put(entry.getName(), entry);
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe);
        }
        try {
            this.setBaseUrl(new File(this.getBase()).toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

