/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.util.Introspection;
import org.apache.tomcat.util.descriptor.web.ApplicationListener;
import org.apache.tomcat.util.descriptor.web.ContextEnvironment;
import org.apache.tomcat.util.descriptor.web.ContextResource;
import org.apache.tomcat.util.descriptor.web.ContextResourceEnvRef;
import org.apache.tomcat.util.descriptor.web.ContextService;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.MessageDestinationRef;
import org.apache.tomcat.util.res.StringManager;

public class WebAnnotationSet {
    private static final String SEPARATOR = "/";
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");

    public static void loadApplicationAnnotations(Context context) {
        WebAnnotationSet.loadApplicationListenerAnnotations(context);
        WebAnnotationSet.loadApplicationFilterAnnotations(context);
        WebAnnotationSet.loadApplicationServletAnnotations(context);
    }

    protected static void loadApplicationListenerAnnotations(Context context) {
        Class<?> classClass = null;
        ApplicationListener[] applicationListeners = context.findApplicationListeners();
        for (int i = 0; i < applicationListeners.length; ++i) {
            classClass = Introspection.loadClass(context, applicationListeners[i].getClassName());
            if (classClass == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, classClass);
            WebAnnotationSet.loadFieldsAnnotation(context, classClass);
            WebAnnotationSet.loadMethodsAnnotation(context, classClass);
        }
    }

    protected static void loadApplicationFilterAnnotations(Context context) {
        Class<?> classClass = null;
        FilterDef[] filterDefs = context.findFilterDefs();
        for (int i = 0; i < filterDefs.length; ++i) {
            classClass = Introspection.loadClass(context, filterDefs[i].getFilterClass());
            if (classClass == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, classClass);
            WebAnnotationSet.loadFieldsAnnotation(context, classClass);
            WebAnnotationSet.loadMethodsAnnotation(context, classClass);
        }
    }

    protected static void loadApplicationServletAnnotations(Context context) {
        Wrapper wrapper = null;
        Class<?> classClass = null;
        Container[] children = context.findChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Wrapper) || (wrapper = (Wrapper)children[i]).getServletClass() == null || (classClass = Introspection.loadClass(context, wrapper.getServletClass())) == null) continue;
            WebAnnotationSet.loadClassAnnotation(context, classClass);
            WebAnnotationSet.loadFieldsAnnotation(context, classClass);
            WebAnnotationSet.loadMethodsAnnotation(context, classClass);
            if (!classClass.isAnnotationPresent(RunAs.class)) continue;
            RunAs annotation = classClass.getAnnotation(RunAs.class);
            wrapper.setRunAs(annotation.value());
        }
    }

    protected static void loadClassAnnotation(Context context, Class<?> classClass) {
        int i;
        Resource annotation;
        if (classClass.isAnnotationPresent(Resource.class)) {
            annotation = classClass.getAnnotation(Resource.class);
            WebAnnotationSet.addResource(context, annotation);
        }
        if (classClass.isAnnotationPresent(Resources.class)) {
            annotation = classClass.getAnnotation(Resources.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                WebAnnotationSet.addResource(context, annotation.value()[i]);
            }
        }
        if (classClass.isAnnotationPresent(DeclareRoles.class)) {
            annotation = classClass.getAnnotation(DeclareRoles.class);
            for (i = 0; annotation.value() != null && i < annotation.value().length; ++i) {
                context.addSecurityRole(annotation.value()[i]);
            }
        }
    }

    protected static void loadFieldsAnnotation(Context context, Class<?> classClass) {
        Field[] fields = Introspection.getDeclaredFields(classClass);
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Resource.class)) continue;
                Resource annotation = field.getAnnotation(Resource.class);
                String defaultName = classClass.getName() + SEPARATOR + field.getName();
                Class<?> defaultType = field.getType();
                WebAnnotationSet.addResource(context, annotation, defaultName, defaultType);
            }
        }
    }

    protected static void loadMethodsAnnotation(Context context, Class<?> classClass) {
        Method[] methods = Introspection.getDeclaredMethods(classClass);
        if (methods != null && methods.length > 0) {
            for (Method method : methods) {
                if (!method.isAnnotationPresent(Resource.class)) continue;
                Resource annotation = method.getAnnotation(Resource.class);
                if (!Introspection.isValidSetter(method)) {
                    throw new IllegalArgumentException(sm.getString("webAnnotationSet.invalidInjection"));
                }
                String defaultName = classClass.getName() + SEPARATOR + Introspection.getPropertyName(method);
                Class<?> defaultType = method.getParameterTypes()[0];
                WebAnnotationSet.addResource(context, annotation, defaultName, defaultType);
            }
        }
    }

    protected static void addResource(Context context, Resource annotation) {
        WebAnnotationSet.addResource(context, annotation, null, null);
    }

    protected static void addResource(Context context, Resource annotation, String defaultName, Class<?> defaultType) {
        String name = WebAnnotationSet.getName(annotation, defaultName);
        String type = WebAnnotationSet.getType(annotation, defaultType);
        if (type.equals("java.lang.String") || type.equals("java.lang.Character") || type.equals("java.lang.Integer") || type.equals("java.lang.Boolean") || type.equals("java.lang.Double") || type.equals("java.lang.Byte") || type.equals("java.lang.Short") || type.equals("java.lang.Long") || type.equals("java.lang.Float")) {
            ContextEnvironment resource = new ContextEnvironment();
            resource.setName(name);
            resource.setType(type);
            resource.setDescription(annotation.description());
            resource.setValue(annotation.mappedName());
            context.getNamingResources().addEnvironment(resource);
        } else if (type.equals("javax.xml.rpc.Service")) {
            ContextService service = new ContextService();
            service.setName(name);
            service.setWsdlfile(annotation.mappedName());
            service.setType(type);
            service.setDescription(annotation.description());
            context.getNamingResources().addService(service);
        } else if (type.equals("javax.sql.DataSource") || type.equals("javax.jms.ConnectionFactory") || type.equals("javax.jms.QueueConnectionFactory") || type.equals("javax.jms.TopicConnectionFactory") || type.equals("javax.mail.Session") || type.equals("java.net.URL") || type.equals("javax.resource.cci.ConnectionFactory") || type.equals("org.omg.CORBA_2_3.ORB") || type.endsWith("ConnectionFactory")) {
            ContextResource resource = new ContextResource();
            resource.setName(name);
            resource.setType(type);
            if (annotation.authenticationType() == Resource.AuthenticationType.CONTAINER) {
                resource.setAuth("Container");
            } else if (annotation.authenticationType() == Resource.AuthenticationType.APPLICATION) {
                resource.setAuth("Application");
            }
            resource.setScope(annotation.shareable() ? "Shareable" : "Unshareable");
            resource.setProperty("mappedName", (Object)annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResource(resource);
        } else if (type.equals("javax.jms.Queue") || type.equals("javax.jms.Topic")) {
            MessageDestinationRef resource = new MessageDestinationRef();
            resource.setName(name);
            resource.setType(type);
            resource.setUsage(annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addMessageDestinationRef(resource);
        } else {
            if (type.equals("javax.resource.cci.InteractionSpec") || !type.equals("javax.transaction.UserTransaction")) {
                // empty if block
            }
            ContextResourceEnvRef resource = new ContextResourceEnvRef();
            resource.setName(name);
            resource.setType(type);
            resource.setProperty("mappedName", (Object)annotation.mappedName());
            resource.setDescription(annotation.description());
            context.getNamingResources().addResourceEnvRef(resource);
        }
    }

    private static String getType(Resource annotation, Class<?> defaultType) {
        Class<?> type = annotation.type();
        if ((type == null || type.equals(Object.class)) && defaultType != null) {
            type = defaultType;
        }
        return Introspection.convertPrimitiveType(type).getCanonicalName();
    }

    private static String getName(Resource annotation, String defaultName) {
        String name = annotation.name();
        if ((name == null || name.equals("")) && defaultName != null) {
            name = defaultName;
        }
        return name;
    }
}

