/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractResource;

public abstract class AbstractArchiveResource
extends AbstractResource {
    private final String base;
    private final String baseUrl;
    private final JarEntry resource;
    private final Manifest manifest;
    private final String name;
    private boolean readCerts = false;
    private Certificate[] certificates;

    protected AbstractArchiveResource(WebResourceRoot root, String webAppPath, String base, String baseUrl, JarEntry jarEntry, String internalPath, Manifest manifest) {
        super(root, webAppPath);
        int index;
        this.base = base;
        this.baseUrl = baseUrl;
        this.resource = jarEntry;
        this.manifest = manifest;
        String resourceName = this.resource.getName();
        if (resourceName.charAt(resourceName.length() - 1) == '/') {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        this.name = internalPath.length() > 0 && resourceName.equals(internalPath.subSequence(1, internalPath.length())) ? "" : ((index = resourceName.lastIndexOf(47)) == -1 ? resourceName : resourceName.substring(index + 1));
    }

    protected final String getBase() {
        return this.base;
    }

    protected final String getBaseUrl() {
        return this.baseUrl;
    }

    protected final JarEntry getResource() {
        return this.resource;
    }

    @Override
    public long getLastModified() {
        return this.resource.getTime();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public boolean isFile() {
        return !this.resource.isDirectory();
    }

    @Override
    public boolean delete() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getContentLength() {
        return this.resource.getSize();
    }

    @Override
    public String getCanonicalPath() {
        return null;
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public long getCreation() {
        return this.resource.getTime();
    }

    @Override
    public URL getURL() {
        try {
            return new URL(this.baseUrl + "!/" + this.resource.getName());
        }
        catch (MalformedURLException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{this.resource.getName(), this.baseUrl}), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public final byte[] getContent() {
        byte[] result;
        block16: {
            long len = this.getContentLength();
            if (len > Integer.MAX_VALUE) {
                throw new ArrayIndexOutOfBoundsException(sm.getString("abstractResource.getContentTooLarge", new Object[]{this.getWebappPath(), len}));
            }
            int size = (int)len;
            result = new byte[size];
            try (JarInputStreamWrapper jisw = this.getJarInputStreamWrapper();){
                int n;
                for (int pos = 0; pos < size && (n = jisw.read(result, pos, size - pos)) >= 0; pos += n) {
                }
                this.certificates = jisw.getCertificates();
                this.readCerts = true;
            }
            catch (IOException ioe) {
                if (!this.getLog().isDebugEnabled()) break block16;
                this.getLog().debug((Object)sm.getString("abstractResource.getContentFail", new Object[]{this.getWebappPath()}), (Throwable)ioe);
            }
        }
        return result;
    }

    @Override
    public Certificate[] getCertificates() {
        if (!this.readCerts) {
            throw new IllegalStateException();
        }
        return this.certificates;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    protected final InputStream doGetInputStream() {
        return this.getJarInputStreamWrapper();
    }

    protected abstract JarInputStreamWrapper getJarInputStreamWrapper();

    protected class JarInputStreamWrapper
    extends InputStream {
        private final JarFile jarFile;
        private final JarEntry jarEntry;
        private final InputStream is;

        public JarInputStreamWrapper(JarFile jarFile, JarEntry jarEntry, InputStream is) {
            this.jarFile = jarFile;
            this.jarEntry = jarEntry;
            this.is = is;
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.is.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.jarFile.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.is.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        public Certificate[] getCertificates() {
            return this.jarEntry.getCertificates();
        }
    }
}

