/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Executor;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProtocol
implements ProtocolHandler,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.ajp");
    protected ObjectName tpOname = null;
    protected ObjectName rgOname = null;
    protected AbstractEndpoint endpoint = null;
    protected Adapter adapter;
    protected HashMap<String, Object> attributes = new HashMap();
    protected int processorCache = -1;
    protected boolean tomcatAuthentication = true;
    protected String requiredSecret = null;
    protected int packetSize = 8192;
    protected int keepAliveTimeout = -1;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    protected abstract Log getLog();

    @Override
    public void setAttribute(String name, Object value) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("ajpprotocol.setattribute", new Object[]{name, value}));
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("ajpprotocol.getattribute", new Object[]{key}));
        }
        return this.attributes.get(key);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public boolean setProperty(String name, String value) {
        this.setAttribute(name, value);
        if (name != null && (name.startsWith("socket.") || name.startsWith("selectorPool."))) {
            return this.endpoint.setProperty(name, value);
        }
        return this.endpoint.setProperty(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("ajpprotocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("ajpprotocol.pause", new Object[]{this.getName()}));
        }
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("ajpprotocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("ajpprotocol.resume", new Object[]{this.getName()}));
        }
    }

    @Override
    public void stop() throws Exception {
        try {
            this.endpoint.stop();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("ajpprotocol.endpoint.stoperror"), (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("ajpprotocol.stop", new Object[]{this.getName()}));
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("ajpprotocol.destroy", new Object[]{this.getName()}));
        }
        this.endpoint.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "ajp-" + encodedAddr + this.endpoint.getPort();
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int soTimeout) {
        this.endpoint.setSoTimeout(soTimeout);
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int packetSize) {
        this.packetSize = packetSize < 8192 ? 8192 : packetSize;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

