/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Executor;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.coyote.Adapter;
import org.apache.coyote.ProtocolHandler;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Protocol
implements ProtocolHandler,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    protected ObjectName tpOname = null;
    protected ObjectName rgOname = null;
    protected AbstractEndpoint endpoint = null;
    protected SSLImplementation sslImplementation = null;
    protected Adapter adapter;
    protected HashMap<String, Object> attributes = new HashMap();
    private boolean secure;
    private int processorCache;
    private int socketBuffer = 9000;
    private int maxSavePostSize = 4096;
    private int maxHttpHeaderSize = 8192;
    private boolean disableUploadTimeout = true;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private String restrictedUserAgents = null;
    private String server;
    private int maxTrailerSize = 8192;
    protected String domain;
    protected ObjectName oname;
    protected MBeanServer mserver;

    protected abstract Log getLog();

    @Override
    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("http11protocol.setattribute", new Object[]{name, value}));
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String key) {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)sm.getString("http11protocol.getattribute", new Object[]{key}));
        }
        return this.attributes.get(key);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        return this.attributes.keySet().iterator();
    }

    public boolean setProperty(String name, String value) {
        this.setAttribute(name, value);
        if (name != null && (name.startsWith("socket.") || name.startsWith("selectorPool."))) {
            return this.endpoint.setProperty(name, value);
        }
        return this.endpoint.setProperty(name, value);
    }

    public String getProperty(String name) {
        return (String)this.getAttribute(name);
    }

    public InetAddress getAddress() {
        return this.endpoint.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.endpoint.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.endpoint.getPort();
    }

    @Override
    public void pause() throws Exception {
        try {
            this.endpoint.pause();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("http11protocol.endpoint.pauseerror"), (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("http11protocol.pause", new Object[]{this.getName()}));
        }
    }

    @Override
    public void resume() throws Exception {
        try {
            this.endpoint.resume();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("http11protocol.endpoint.resumeerror"), (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("http11protocol.resume", new Object[]{this.getName()}));
        }
    }

    @Override
    public void stop() throws Exception {
        try {
            this.endpoint.stop();
        }
        catch (Exception ex) {
            this.getLog().error((Object)sm.getString("http11protocol.endpoint.stoperror"), (Throwable)ex);
            throw ex;
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("http11protocol.stop", new Object[]{this.getName()}));
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((Object)sm.getString("http11protocol.destroy", new Object[]{this.getName()}));
        }
        this.endpoint.destroy();
        if (this.tpOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.tpOname);
        }
        if (this.rgOname != null) {
            Registry.getRegistry(null, null).unregisterComponent(this.rgOname);
        }
    }

    public boolean isSSLEnabled() {
        return this.endpoint.isSSLEnabled();
    }

    public void setSSLEnabled(boolean SSLEnabled) {
        this.endpoint.setSSLEnabled(SSLEnabled);
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean b) {
        this.secure = b;
        this.setAttribute("secure", "" + b);
    }

    public int getProcessorCache() {
        return this.processorCache;
    }

    public void setProcessorCache(int processorCache) {
        this.processorCache = processorCache;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getMaxKeepAliveRequests() {
        return this.endpoint.getMaxKeepAliveRequests();
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.endpoint.setMaxKeepAliveRequests(mkar);
        this.setAttribute("maxKeepAliveRequests", "" + mkar);
    }

    public boolean getKeepAlive() {
        return this.endpoint.getMaxKeepAliveRequests() != 0 && this.endpoint.getMaxKeepAliveRequests() != 1;
    }

    public void setKeepAlive(boolean keepAlive) {
        if (!keepAlive) {
            this.setMaxKeepAliveRequests(1);
        }
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.endpoint.setKeepAliveTimeout(keepAliveTimeout);
    }

    public int getKeepAliveTimeout() {
        return this.endpoint.getKeepAliveTimeout();
    }

    public int getTimeout() {
        return this.getSoTimeout();
    }

    public void setTimeout(int timeout) {
        this.setSoTimeout(timeout);
    }

    public int getConnectionTimeout() {
        return this.getSoTimeout();
    }

    public void setConnectionTimeout(int timeout) {
        this.setSoTimeout(timeout);
    }

    public int getSoTimeout() {
        return this.endpoint.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.endpoint.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
        this.setAttribute("timeout", "" + i);
        this.setAttribute("connectionTimeout", "" + i);
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setMaxSavePostSize(int valueI) {
        this.maxSavePostSize = valueI;
    }

    public int getMaxHttpHeaderSize() {
        return this.maxHttpHeaderSize;
    }

    public void setMaxHttpHeaderSize(int valueI) {
        this.maxHttpHeaderSize = valueI;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
    }

    public String getCompressableMimeTypes() {
        return this.getCompressableMimeType();
    }

    public void setCompressableMimeTypes(String valueS) {
        this.setCompressableMimeType(valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServer() {
        return this.server;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    public void setMaxTrailerSize(int maxTrailerSize) {
        this.maxTrailerSize = maxTrailerSize;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.endpoint.setExecutor(executor);
    }

    public int getMaxThreads() {
        return this.endpoint.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.endpoint.setMaxThreads(maxThreads);
    }

    public int getThreadPriority() {
        return this.endpoint.getThreadPriority();
    }

    public void setThreadPriority(int threadPriority) {
        this.endpoint.setThreadPriority(threadPriority);
    }

    public int getPort() {
        return this.endpoint.getPort();
    }

    public void setPort(int port) {
        this.endpoint.setPort(port);
    }

    public int getBacklog() {
        return this.endpoint.getBacklog();
    }

    public void setBacklog(int backlog) {
        this.endpoint.setBacklog(backlog);
    }

    public boolean getTcpNoDelay() {
        return this.endpoint.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.endpoint.setTcpNoDelay(tcpNoDelay);
    }

    public int getSoLinger() {
        return this.endpoint.getSoLinger();
    }

    public void setSoLinger(int soLinger) {
        this.endpoint.setSoLinger(soLinger);
    }

    @Override
    public abstract void init() throws Exception;

    public ObjectName getObjectName() {
        return this.oname;
    }

    public String getDomain() {
        return this.domain;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.oname = name;
        this.mserver = server;
        this.domain = name.getDomain();
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }
}

