/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalAprInputBuffer;
import org.apache.coyote.http11.InternalAprOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.jni.Address;
import org.apache.tomcat.jni.SSLSocket;
import org.apache.tomcat.jni.Sockaddr;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProcessor
extends AbstractHttp11Processor {
    private static final Log log = LogFactory.getLog(Http11AprProcessor.class);
    protected InternalAprInputBuffer inputBuffer = null;
    protected InternalAprOutputBuffer outputBuffer = null;
    protected AprEndpoint.SendfileData sendfileData = null;
    protected boolean comet = false;
    protected boolean ssl = false;
    protected SocketWrapper<Long> socket = null;
    protected AprEndpoint endpoint;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11AprProcessor(int headerBufferSize, AprEndpoint endpoint, int maxTrailerSize) {
        this.endpoint = endpoint;
        this.request = new Request();
        this.inputBuffer = new InternalAprInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.response = new Response();
        this.response.setHook(this);
        this.outputBuffer = new InternalAprOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.request.setResponse(this.response);
        this.ssl = endpoint.isSSLEnabled();
        this.initializeFilters(maxTrailerSize);
        HexUtils.load();
    }

    @Override
    protected AbstractEndpoint getEndpoint() {
        return this.endpoint;
    }

    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.error = !this.adapter.event(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error) {
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (!this.comet) {
            this.inputBuffer.nextRequest();
            this.outputBuffer.nextRequest();
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.LONG;
    }

    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.remoteAddr = null;
        this.remoteHost = null;
        this.localAddr = null;
        this.localName = null;
        this.remotePort = -1;
        this.localPort = -1;
        this.socket = socket;
        long socketRef = socket.getSocket();
        this.inputBuffer.setSocket(socketRef);
        this.outputBuffer.setSocket(socketRef);
        this.error = false;
        this.comet = false;
        this.keepAlive = true;
        int keepAliveLeft = this.maxKeepAliveRequests;
        long soTimeout = this.endpoint.getSoTimeout();
        boolean keptAlive = false;
        boolean openSocket = false;
        while (!(this.error || !this.keepAlive || this.comet || this.isAsync() || this.endpoint.isPaused())) {
            try {
                if (!this.disableUploadTimeout && keptAlive && soTimeout > 0L) {
                    Socket.timeoutSet(socketRef, soTimeout * 1000L);
                }
                if (!this.inputBuffer.parseRequestLine(keptAlive)) {
                    openSocket = true;
                    this.endpoint.getPoller().add(socketRef);
                    break;
                }
                this.request.setStartTime(System.currentTimeMillis());
                keptAlive = true;
                if (!this.disableUploadTimeout) {
                    Socket.timeoutSet(socketRef, this.timeout * 1000);
                }
                this.inputBuffer.parseHeaders();
            }
            catch (IOException e) {
                this.error = true;
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.header.parse"), t);
                }
                this.response.setStatus(400);
                this.adapter.log(this.request, this.response, 0L);
                this.error = true;
            }
            if (!this.error) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.request.prepare"), t);
                    }
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (this.maxKeepAliveRequests > 0 && --keepAliveLeft == 0) {
                this.keepAlive = false;
            }
            if (!this.error) {
                try {
                    rp.setStage(3);
                    this.adapter.service(this.request, this.response);
                    if (this.keepAlive && !this.error) {
                        this.error = this.response.getErrorException() != null || this.statusDropsConnection(this.response.getStatus());
                    }
                }
                catch (InterruptedIOException e) {
                    this.error = true;
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                    log.error((Object)sm.getString("http11processor.request.process"), t);
                    this.response.setStatus(500);
                    this.adapter.log(this.request, this.response, 0L);
                    this.error = true;
                }
            }
            if (!this.comet && !this.isAsync()) {
                if (this.error) {
                    this.inputBuffer.setSwallowInput(false);
                }
                this.endRequest();
            }
            if (this.error) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            if (!this.comet && !this.isAsync()) {
                this.inputBuffer.nextRequest();
                this.outputBuffer.nextRequest();
            }
            if (this.sendfileData != null && !this.error) {
                this.sendfileData.socket = socketRef;
                this.sendfileData.keepAlive = this.keepAlive;
                if (!this.endpoint.getSendfile().add(this.sendfileData)) {
                    openSocket = true;
                    break;
                }
            }
            rp.setStage(6);
        }
        rp.setStage(7);
        if (this.error || this.endpoint.isPaused()) {
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.comet || this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.recycle();
        return openSocket ? AbstractEndpoint.Handler.SocketState.OPEN : AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketWrapper<Long> socket, SocketStatus status) {
        this.socket = socket;
        long socketRef = socket.getSocket();
        this.inputBuffer.setSocket(socketRef);
        this.outputBuffer.setSocket(socketRef);
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            this.error = !this.adapter.asyncDispatch(this.request, this.response, status);
        }
        catch (InterruptedIOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error((Object)sm.getString("http11processor.request.process"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        rp.setStage(7);
        if (this.error) {
            this.recycle();
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.recycle();
        if (!this.keepAlive) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    public void recycleInternal() {
        this.socket = null;
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        long socketRef = this.socket.getSocket();
        if (actionCode == ActionCode.CLOSE) {
            this.comet = false;
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            if (this.remoteAddr == null && socketRef != 0L) {
                try {
                    long sa = Address.get(1, socketRef);
                    this.remoteAddr = Address.getip(sa);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.remoteAddr().setString(this.remoteAddr);
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            if (this.localName == null && socketRef != 0L) {
                try {
                    long sa = Address.get(0, socketRef);
                    this.localName = Address.getnameinfo(sa, 0);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.localName().setString(this.localName);
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.remoteHost == null && socketRef != 0L) {
                try {
                    long sa = Address.get(1, socketRef);
                    this.remoteHost = Address.getnameinfo(sa, 0);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.remoteHost().setString(this.remoteHost);
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.localAddr == null && socketRef != 0L) {
                try {
                    long sa = Address.get(0, socketRef);
                    this.localAddr = Address.getip(sa);
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.localAddr().setString(this.localAddr);
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.remotePort == -1 && socketRef != 0L) {
                try {
                    long sa = Address.get(1, socketRef);
                    Sockaddr addr = Address.getInfo(sa);
                    this.remotePort = addr.port;
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.setRemotePort(this.remotePort);
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.localPort == -1 && socketRef != 0L) {
                try {
                    long sa = Address.get(0, socketRef);
                    Sockaddr addr = Address.getInfo(sa);
                    this.localPort = addr.port;
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.info"), (Throwable)e);
                }
            }
            this.request.setLocalPort(this.localPort);
        } else if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            if (this.ssl && socketRef != 0L) {
                try {
                    Object sslO = SSLSocket.getInfoS(socketRef, 2);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    int certLength = SSLSocket.getInfoI(socketRef, 1024);
                    byte[] clientCert = SSLSocket.getInfoB(socketRef, 263);
                    X509Certificate[] certs = null;
                    if (clientCert != null && certLength > -1) {
                        certs = new X509Certificate[certLength + 1];
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                        for (int i = 0; i < certLength; ++i) {
                            byte[] data = SSLSocket.getInfoB(socketRef, 1024 + i);
                            certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                        }
                    }
                    if (certs != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                    }
                    sslO = SSLSocket.getInfoI(socketRef, 3);
                    this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    sslO = SSLSocket.getInfoS(socketRef, 1);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.ssl && socketRef != 0L) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                try {
                    SSLSocket.setVerify(socketRef, 2, this.endpoint.getSSLVerifyDepth());
                    if (SSLSocket.renegotiate(socketRef) == 0) {
                        int certLength = SSLSocket.getInfoI(socketRef, 1024);
                        byte[] clientCert = SSLSocket.getInfoB(socketRef, 263);
                        X509Certificate[] certs = null;
                        if (clientCert != null && certLength > -1) {
                            certs = new X509Certificate[certLength + 1];
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            certs[0] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(clientCert));
                            for (int i = 0; i < certLength; ++i) {
                                byte[] data = SSLSocket.getInfoB(socketRef, 1024 + i);
                                certs[i + 1] = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(data));
                            }
                        }
                        if (certs != null) {
                            this.request.setAttribute("javax.servlet.request.X509Certificate", certs);
                        }
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.AVAILABLE) {
            this.request.setAvailable(this.inputBuffer.available());
        } else if (actionCode == ActionCode.COMET_BEGIN) {
            this.comet = true;
        } else if (actionCode == ActionCode.COMET_END) {
            this.comet = false;
        } else if (actionCode == ActionCode.COMET_CLOSE) {
            this.endpoint.processSocketAsync(this.socket, SocketStatus.OPEN);
        } else if (actionCode != ActionCode.COMET_SETTIMEOUT) {
            if (actionCode == ActionCode.ASYNC_COMPLETE) {
                if (this.asyncStateMachine.asyncComplete()) {
                    this.endpoint.processSocketAsync(this.socket, SocketStatus.OPEN);
                }
            } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
                if (param == null) {
                    return;
                }
                long timeout = (Long)param;
                this.socket.setTimeout(timeout);
            } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
                this.endpoint.processSocketAsync(this.socket, SocketStatus.OPEN);
            }
        }
    }

    protected void prepareRequest() {
        long contentLength;
        ByteChunk uriBC;
        MessageBytes userAgentValueMB;
        MessageBytes protocolMB;
        this.http11 = true;
        this.http09 = false;
        this.contentDelimitation = false;
        this.expectation = false;
        this.sendfileData = null;
        if (this.ssl) {
            this.request.scheme().setString("https");
        }
        if ((protocolMB = this.request.protocol()).equals("HTTP/1.1")) {
            this.http11 = true;
            protocolMB.setString("HTTP/1.1");
        } else if (protocolMB.equals("HTTP/1.0")) {
            this.http11 = false;
            this.keepAlive = false;
            protocolMB.setString("HTTP/1.0");
        } else if (protocolMB.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http11 = false;
            this.error = true;
            this.response.setStatus(505);
            this.adapter.log(this.request, this.response, 0L);
        }
        MessageBytes methodMB = this.request.method();
        if (methodMB.equals("GET")) {
            methodMB.setString("GET");
        } else if (methodMB.equals("POST")) {
            methodMB.setString("POST");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                this.keepAlive = false;
            } else if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                this.keepAlive = true;
            }
        }
        MessageBytes expectMB = null;
        if (this.http11) {
            expectMB = headers.getValue("expect");
        }
        if (expectMB != null && expectMB.indexOfIgnoreCase("100-continue", 0) != -1) {
            this.inputBuffer.setSwallowInput(false);
            this.expectation = true;
        }
        if (this.restrictedUserAgents != null && (this.http11 || this.keepAlive) && (userAgentValueMB = headers.getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            for (int i = 0; i < this.restrictedUserAgents.length; ++i) {
                if (!this.restrictedUserAgents[i].matcher(userAgentValue).matches()) continue;
                this.http11 = false;
                this.keepAlive = false;
                break;
            }
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        InputFilter[] inputFilters = this.inputBuffer.getFilters();
        MessageBytes transferEncodingValueMB = null;
        if (this.http11) {
            transferEncodingValueMB = headers.getValue("transfer-encoding");
        }
        if (transferEncodingValueMB != null) {
            String transferEncodingValue = transferEncodingValueMB.toString();
            int startPos = 0;
            int commaPos = transferEncodingValue.indexOf(44);
            String encodingName = null;
            while (commaPos != -1) {
                encodingName = transferEncodingValue.substring(startPos, commaPos).toLowerCase(Locale.ENGLISH).trim();
                if (!this.addInputFilter(inputFilters, encodingName)) {
                    this.error = true;
                    this.response.setStatus(501);
                    this.adapter.log(this.request, this.response, 0L);
                }
                startPos = commaPos + 1;
                commaPos = transferEncodingValue.indexOf(44, startPos);
            }
            encodingName = transferEncodingValue.substring(startPos).toLowerCase(Locale.ENGLISH).trim();
            if (!this.addInputFilter(inputFilters, encodingName)) {
                this.error = true;
                this.response.setStatus(501);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        if ((contentLength = this.request.getContentLengthLong()) >= 0L && !this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[0]);
            this.contentDelimitation = true;
        }
        MessageBytes valueMB = headers.getValue("host");
        if (this.http11 && valueMB == null) {
            this.error = true;
            this.response.setStatus(400);
            this.adapter.log(this.request, this.response, 0L);
        }
        this.parseHost(valueMB);
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilters[2]);
            this.contentDelimitation = true;
        }
        if (this.endpoint.getUseSendfile()) {
            this.request.setAttribute("org.apache.tomcat.sendfile.support", Boolean.TRUE);
        }
        this.request.setAttribute("org.apache.tomcat.comet.support", Boolean.TRUE);
    }

    public void parseHost(MessageBytes valueMB) {
        if (valueMB == null || valueMB.isNull()) {
            this.request.setServerPort(this.endpoint.getPort());
            return;
        }
        ByteChunk valueBC = valueMB.getByteChunk();
        byte[] valueB = valueBC.getBytes();
        int valueL = valueBC.getLength();
        int valueS = valueBC.getStart();
        int colonPos = -1;
        if (this.hostNameC.length < valueL) {
            this.hostNameC = new char[valueL];
        }
        boolean ipv6 = valueB[valueS] == 91;
        boolean bracketClosed = false;
        for (int i = 0; i < valueL; ++i) {
            char b;
            this.hostNameC[i] = b = (char)valueB[i + valueS];
            if (b == ']') {
                bracketClosed = true;
                continue;
            }
            if (b != ':' || ipv6 && !bracketClosed) continue;
            colonPos = i;
            break;
        }
        if (colonPos < 0) {
            if (!this.ssl) {
                this.request.setServerPort(80);
            } else {
                this.request.setServerPort(443);
            }
            this.request.serverName().setChars(this.hostNameC, 0, valueL);
        } else {
            this.request.serverName().setChars(this.hostNameC, 0, colonPos);
            int port = 0;
            int mult = 1;
            for (int i = valueL - 1; i > colonPos; --i) {
                int charValue = HexUtils.getDec(valueB[i + valueS]);
                if (charValue == -1) {
                    this.error = true;
                    this.response.setStatus(400);
                    this.adapter.log(this.request, this.response, 0L);
                    break;
                }
                port += charValue * mult;
                mult = 10 * mult;
            }
            this.request.setServerPort(port);
        }
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        String fileName = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (fileName != null) {
            this.outputBuffer.addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
            this.sendfileData = new AprEndpoint.SendfileData();
            this.sendfileData.fileName = fileName;
            this.sendfileData.start = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            this.sendfileData.end = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            return true;
        }
        return false;
    }

    @Override
    protected AbstractInputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public Executor getExecutor() {
        return this.endpoint.getExecutor();
    }
}

