/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.Selector;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;

public class InternalNioInputBuffer
extends AbstractInputBuffer {
    protected boolean parsingHeader;
    protected boolean parsingRequestLine;
    protected int parsingRequestLinePhase = 0;
    protected boolean parsingRequestLineEol = false;
    protected int parsingRequestLineStart = 0;
    protected int parsingRequestLineQPos = -1;
    protected HeaderParsePosition headerParsePos;
    protected NioChannel socket;
    protected NioSelectorPool pool;
    protected HeaderParseData headerData = new HeaderParseData();

    public InternalNioInputBuffer(Request request, int headerBufferSize) {
        this.request = request;
        this.headers = request.getMimeHeaders();
        this.buf = new byte[headerBufferSize];
        this.inputStreamInputBuffer = new SocketInputBuffer();
        this.filterLibrary = new InputFilter[0];
        this.activeFilters = new InputFilter[0];
        this.lastActiveFilter = -1;
        this.parsingHeader = true;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.headerData.recycle();
        this.swallowInput = true;
    }

    public void setSocket(NioChannel socket) {
        this.socket = socket;
    }

    public NioChannel getSocket() {
        return this.socket;
    }

    public void setSelectorPool(NioSelectorPool pool) {
        this.pool = pool;
    }

    public NioSelectorPool getSelectorPool() {
        return this.pool;
    }

    public boolean isReadable() throws IOException {
        return this.pos < this.lastValid || this.nbRead() > 0;
    }

    public int nbRead() throws IOException {
        return this.readSocket(true, false);
    }

    @Override
    public void recycle() {
        super.recycle();
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.socket = null;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    @Override
    public void nextRequest() {
        super.nextRequest();
        this.parsingHeader = true;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.parsingRequestLine = true;
        this.parsingRequestLinePhase = 0;
        this.parsingRequestLineEol = false;
        this.parsingRequestLineStart = 0;
        this.parsingRequestLineQPos = -1;
        this.headerData.recycle();
    }

    @Override
    public boolean parseRequestLine(boolean useAvailableDataOnly) throws IOException {
        boolean space;
        if (!this.parsingRequestLine) {
            return true;
        }
        if (this.parsingRequestLinePhase == 0) {
            byte chr = 0;
            do {
                if (this.pos < this.lastValid) continue;
                if (useAvailableDataOnly) {
                    return false;
                }
                if (this.readSocket(true, false) != 0) continue;
                return false;
            } while ((chr = this.buf[this.pos++]) == 13 || chr == 10);
            --this.pos;
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 1;
        }
        if (this.parsingRequestLinePhase == 1) {
            if (this.pos >= this.lastValid) {
                if (useAvailableDataOnly) {
                    return false;
                }
                if (this.readSocket(true, false) == 0) {
                    return false;
                }
            }
            this.parsingRequestLinePhase = 2;
        }
        if (this.parsingRequestLinePhase == 2) {
            space = false;
            while (!space) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                    throw new IllegalArgumentException(sm.getString("iib.invalidmethod"));
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space = true;
                    this.request.method().setBytes(this.buf, this.parsingRequestLineStart, this.pos - this.parsingRequestLineStart);
                }
                ++this.pos;
            }
            this.parsingRequestLinePhase = 3;
        }
        if (this.parsingRequestLinePhase == 3) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 4;
        }
        if (this.parsingRequestLinePhase == 4) {
            int end = 0;
            boolean space2 = false;
            while (!space2) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    space2 = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 13 || this.buf[this.pos] == 10) {
                    this.parsingRequestLineEol = true;
                    space2 = true;
                    end = this.pos;
                } else if (this.buf[this.pos] == 63 && this.parsingRequestLineQPos == -1) {
                    this.parsingRequestLineQPos = this.pos;
                }
                ++this.pos;
            }
            this.request.unparsedURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            if (this.parsingRequestLineQPos >= 0) {
                this.request.queryString().setBytes(this.buf, this.parsingRequestLineQPos + 1, end - this.parsingRequestLineQPos - 1);
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, this.parsingRequestLineQPos - this.parsingRequestLineStart);
            } else {
                this.request.requestURI().setBytes(this.buf, this.parsingRequestLineStart, end - this.parsingRequestLineStart);
            }
            this.parsingRequestLinePhase = 5;
        }
        if (this.parsingRequestLinePhase == 5) {
            space = true;
            while (space) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                    ++this.pos;
                    continue;
                }
                space = false;
            }
            this.parsingRequestLineStart = this.pos;
            this.parsingRequestLinePhase = 6;
        }
        if (this.parsingRequestLinePhase == 6) {
            this.end = 0;
            while (!this.parsingRequestLineEol) {
                if (this.pos >= this.lastValid && !this.fill(true, false)) {
                    return false;
                }
                if (this.buf[this.pos] == 13) {
                    this.end = this.pos;
                } else if (this.buf[this.pos] == 10) {
                    if (this.end == 0) {
                        this.end = this.pos;
                    }
                    this.parsingRequestLineEol = true;
                }
                ++this.pos;
            }
            if (this.end - this.parsingRequestLineStart > 0) {
                this.request.protocol().setBytes(this.buf, this.parsingRequestLineStart, this.end - this.parsingRequestLineStart);
            } else {
                this.request.protocol().setString("");
            }
            this.parsingRequestLine = false;
            this.parsingRequestLinePhase = 0;
            this.parsingRequestLineEol = false;
            this.parsingRequestLineStart = 0;
            return true;
        }
        throw new IllegalStateException("Invalid request line parse phase:" + this.parsingRequestLinePhase);
    }

    private void expand(int newsize) {
        if (newsize > this.buf.length) {
            byte[] tmp = new byte[newsize];
            System.arraycopy(this.buf, 0, tmp, 0, this.buf.length);
            this.buf = tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSocket(boolean timeout, boolean block) throws IOException {
        int nRead = 0;
        this.socket.getBufHandler().getReadBuffer().clear();
        if (block) {
            Selector selector = null;
            try {
                selector = this.getSelectorPool().get();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
                if (att == null) {
                    throw new IOException("Key must be cancelled.");
                }
                nRead = this.getSelectorPool().read(this.socket.getBufHandler().getReadBuffer(), this.socket, selector, att.getTimeout());
            }
            catch (EOFException eof) {
                nRead = -1;
            }
            finally {
                if (selector != null) {
                    this.getSelectorPool().put(selector);
                }
            }
        } else {
            nRead = this.socket.read(this.socket.getBufHandler().getReadBuffer());
        }
        if (nRead > 0) {
            this.socket.getBufHandler().getReadBuffer().flip();
            this.socket.getBufHandler().getReadBuffer().limit(nRead);
            this.expand(nRead + this.pos);
            this.socket.getBufHandler().getReadBuffer().get(this.buf, this.pos, nRead);
            this.lastValid = this.pos + nRead;
            return nRead;
        }
        if (nRead == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return 0;
    }

    @Override
    public boolean parseHeaders() throws IOException {
        HeaderParseStatus status = HeaderParseStatus.HAVE_MORE_HEADERS;
        while ((status = this.parseHeader()) == HeaderParseStatus.HAVE_MORE_HEADERS) {
        }
        if (status == HeaderParseStatus.DONE) {
            this.parsingHeader = false;
            this.end = this.pos;
            return true;
        }
        return false;
    }

    public HeaderParseStatus parseHeader() throws IOException {
        byte chr = 0;
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (chr != 13 && chr != 10) break;
            if (chr == 10) {
                ++this.pos;
                return HeaderParseStatus.DONE;
            }
            ++this.pos;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.start = this.pos;
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            if (this.buf[this.pos] == 58) {
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
                this.headerData.headerValue = this.headers.addValue(this.buf, this.headerData.start, this.pos - this.headerData.start);
            }
            if ((chr = this.buf[this.pos]) >= 65 && chr <= 90) {
                this.buf[this.pos] = (byte)(chr - -32);
            }
            ++this.pos;
            if (this.headerParsePos != HeaderParsePosition.HEADER_VALUE) continue;
            this.headerData.start = this.pos;
            this.headerData.realPos = this.pos;
        }
        boolean eol = false;
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                boolean space = true;
                while (space) {
                    if (this.pos >= this.lastValid && !this.fill(true, false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    if (this.buf[this.pos] == 32 || this.buf[this.pos] == 9) {
                        ++this.pos;
                        continue;
                    }
                    space = false;
                }
                this.headerData.lastSignificantChar = this.headerData.realPos;
                while (!eol) {
                    if (this.pos >= this.lastValid && !this.fill(true, false)) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    if (this.buf[this.pos] != 13) {
                        if (this.buf[this.pos] == 10) {
                            eol = true;
                        } else if (this.buf[this.pos] == 32) {
                            this.buf[this.headerData.realPos] = this.buf[this.pos];
                            ++this.headerData.realPos;
                        } else {
                            this.buf[this.headerData.realPos] = this.buf[this.pos];
                            this.headerData.lastSignificantChar = ++this.headerData.realPos;
                        }
                    }
                    ++this.pos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.pos >= this.lastValid && !this.fill(true, false)) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            chr = this.buf[this.pos];
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (chr != 32 && chr != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                continue;
            }
            eol = false;
            this.buf[this.headerData.realPos] = chr;
            ++this.headerData.realPos;
            this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
        }
        this.headerData.headerValue.setBytes(this.buf, this.headerData.start, this.headerData.realPos - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    public int available() {
        int result = this.lastValid - this.pos;
        if (result == 0 && this.lastActiveFilter >= 0) {
            for (int i = 0; result == 0 && i <= this.lastActiveFilter; ++i) {
                result = this.activeFilters[i].available();
            }
        }
        return result;
    }

    @Override
    protected boolean fill(boolean block) throws IOException, EOFException {
        return this.fill(true, block);
    }

    protected boolean fill(boolean timeout, boolean block) throws IOException, EOFException {
        boolean read = false;
        if (this.parsingHeader) {
            if (this.lastValid == this.buf.length) {
                throw new IllegalArgumentException(sm.getString("iib.requestheadertoolarge.error"));
            }
            read = this.readSocket(timeout, block) > 0;
        } else {
            if (this.buf.length - this.end < 4500) {
                this.buf = new byte[this.buf.length];
                this.end = 0;
            }
            this.lastValid = this.pos = this.end;
            read = this.readSocket(timeout, block) > 0;
        }
        return read;
    }

    public int getParsingRequestLinePhase() {
        return this.parsingRequestLinePhase;
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (InternalNioInputBuffer.this.pos >= InternalNioInputBuffer.this.lastValid && !InternalNioInputBuffer.this.fill(true, true)) {
                return -1;
            }
            int length = InternalNioInputBuffer.this.lastValid - InternalNioInputBuffer.this.pos;
            chunk.setBytes(InternalNioInputBuffer.this.buf, InternalNioInputBuffer.this.pos, length);
            InternalNioInputBuffer.this.pos = InternalNioInputBuffer.this.lastValid;
            return length;
        }
    }

    public static class HeaderParseData {
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        public void recycle() {
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE,
        HEADER_MULTI_LINE;

    }

    static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

