/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.FlushableGZIPOutputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;

public class GzipOutputFilter
implements OutputFilter {
    protected static final String ENCODING_NAME = "gzip";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected static Log log = LogFactory.getLog(GzipOutputFilter.class);
    protected OutputBuffer buffer;
    protected GZIPOutputStream compressionStream = null;
    protected OutputStream fakeOutputStream = new FakeOutputStream();

    @Override
    public int doWrite(ByteChunk chunk, Response res) throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new FlushableGZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.write(chunk.getBytes(), chunk.getStart(), chunk.getLength());
        return chunk.getLength();
    }

    public void flush() {
        block4: {
            if (this.compressionStream != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Flushing the compression stream!");
                    }
                    this.compressionStream.flush();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Ignored exception while flushing gzip filter", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(OutputBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public long end() throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = new FlushableGZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.finish();
        this.compressionStream.close();
        return ((OutputFilter)this.buffer).end();
    }

    @Override
    public void recycle() {
        this.compressionStream = null;
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(), 0, ENCODING_NAME.length());
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected ByteChunk outputChunk = new ByteChunk();
        protected byte[] singleByteBuffer = new byte[1];

        protected FakeOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.singleByteBuffer[0] = (byte)(b & 0xFF);
            this.outputChunk.setBytes(this.singleByteBuffer, 0, 1);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputChunk.setBytes(b, off, len);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

