/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.AsyncStateMachine;
import org.apache.coyote.Processor;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractHttp11Processor
implements ActionHook,
Processor {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.http11");
    private int pluggableFilterIndex = Integer.MAX_VALUE;
    protected Adapter adapter = null;
    protected Request request = null;
    protected Response response = null;
    protected boolean error = false;
    protected boolean keepAlive = true;
    protected boolean http11 = true;
    protected boolean http09 = false;
    protected boolean contentDelimitation = true;
    protected boolean expectation = false;
    protected Pattern restrictedUserAgents = null;
    protected int maxKeepAliveRequests = -1;
    protected int keepAliveTimeout = -1;
    protected String remoteAddr = null;
    protected String remoteHost = null;
    protected String localName = null;
    protected int localPort = -1;
    protected int remotePort = -1;
    protected String localAddr = null;
    protected int connectionUploadTimeout = 300000;
    protected boolean disableUploadTimeout = false;
    protected int compressionLevel = 0;
    protected int compressionMinSize = 2048;
    protected int socketBuffer = -1;
    protected int maxSavePostSize = 4096;
    protected Pattern noCompressionUserAgents = null;
    protected String[] compressableMimeTypes = new String[]{"text/html", "text/xml", "text/plain"};
    protected char[] hostNameC = new char[0];
    protected String server = null;
    protected AsyncStateMachine asyncStateMachine = new AsyncStateMachine(this);

    protected abstract Log getLog();

    public void setCompression(String compression) {
        if (compression.equals("on")) {
            this.compressionLevel = 1;
        } else if (compression.equals("force")) {
            this.compressionLevel = 2;
        } else if (compression.equals("off")) {
            this.compressionLevel = 0;
        } else {
            try {
                this.compressionMinSize = Integer.parseInt(compression);
                this.compressionLevel = 1;
            }
            catch (Exception e) {
                this.compressionLevel = 0;
            }
        }
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    public void setNoCompressionUserAgents(String noCompressionUserAgents) {
        this.noCompressionUserAgents = noCompressionUserAgents == null || noCompressionUserAgents.length() == 0 ? null : Pattern.compile(noCompressionUserAgents);
    }

    public void addCompressableMimeType(String mimeType) {
        this.compressableMimeTypes = this.addStringArray(this.compressableMimeTypes, mimeType);
    }

    public void setCompressableMimeTypes(String[] compressableMimeTypes) {
        this.compressableMimeTypes = compressableMimeTypes;
    }

    public void setCompressableMimeTypes(String compressableMimeTypes) {
        if (compressableMimeTypes != null) {
            this.compressableMimeTypes = null;
            StringTokenizer st = new StringTokenizer(compressableMimeTypes, ",");
            while (st.hasMoreTokens()) {
                this.addCompressableMimeType(st.nextToken().trim());
            }
        }
    }

    public String getCompression() {
        switch (this.compressionLevel) {
            case 0: {
                return "off";
            }
            case 1: {
                return "on";
            }
            case 2: {
                return "force";
            }
        }
        return "off";
    }

    private String[] addStringArray(String[] sArray, String value) {
        String[] result = null;
        if (sArray == null) {
            result = new String[]{value};
        } else {
            result = new String[sArray.length + 1];
            for (int i = 0; i < sArray.length; ++i) {
                result[i] = sArray[i];
            }
            result[sArray.length] = value;
        }
        return result;
    }

    private boolean startsWithStringArray(String[] sArray, String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (!value.startsWith(sArray[i])) continue;
            return true;
        }
        return false;
    }

    public void setRestrictedUserAgents(String restrictedUserAgents) {
        this.restrictedUserAgents = restrictedUserAgents == null || restrictedUserAgents.length() == 0 ? null : Pattern.compile(restrictedUserAgents);
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.maxKeepAliveRequests = mkar;
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setMaxSavePostSize(int msps) {
        this.maxSavePostSize = msps;
    }

    public int getMaxSavePostSize() {
        return this.maxSavePostSize;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setSocketBuffer(int socketBuffer) {
        this.socketBuffer = socketBuffer;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setConnectionUploadTimeout(int timeout) {
        this.connectionUploadTimeout = timeout;
    }

    public int getConnectionUploadTimeout() {
        return this.connectionUploadTimeout;
    }

    public void setServer(String server) {
        this.server = server == null || server.equals("") ? null : server;
    }

    public String getServer() {
        return this.server;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    private boolean isCompressable() {
        MessageBytes contentEncodingMB = this.response.getMimeHeaders().getValue("Content-Encoding");
        if (contentEncodingMB != null && contentEncodingMB.indexOf("gzip") != -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        long contentLength = this.response.getContentLengthLong();
        if ((contentLength == -1L || contentLength > (long)this.compressionMinSize) && this.compressableMimeTypes != null) {
            return this.startsWithStringArray(this.compressableMimeTypes, this.response.getContentType());
        }
        return false;
    }

    private boolean useCompression() {
        MessageBytes userAgentValueMB;
        MessageBytes acceptEncodingMB = this.request.getMimeHeaders().getValue("accept-encoding");
        if (acceptEncodingMB == null || acceptEncodingMB.indexOf("gzip") == -1) {
            return false;
        }
        if (this.compressionLevel == 2) {
            return true;
        }
        if (this.noCompressionUserAgents != null && (userAgentValueMB = this.request.getMimeHeaders().getValue("user-agent")) != null) {
            String userAgentValue = userAgentValueMB.toString();
            if (this.noCompressionUserAgents != null && this.noCompressionUserAgents.matcher(userAgentValue).matches()) {
                return false;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower(buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower(buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }

    protected boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 500 || status == 503 || status == 501;
    }

    protected abstract AbstractInputBuffer getInputBuffer();

    protected abstract AbstractOutputBuffer getOutputBuffer();

    protected void initializeFilters(int maxTrailerSize) {
        this.getInputBuffer().addFilter(new IdentityInputFilter());
        this.getOutputBuffer().addFilter(new IdentityOutputFilter());
        this.getInputBuffer().addFilter(new ChunkedInputFilter(maxTrailerSize));
        this.getOutputBuffer().addFilter(new ChunkedOutputFilter());
        this.getInputBuffer().addFilter(new VoidInputFilter());
        this.getOutputBuffer().addFilter(new VoidOutputFilter());
        this.getInputBuffer().addFilter(new BufferedInputFilter());
        this.getOutputBuffer().addFilter(new GzipOutputFilter());
        this.pluggableFilterIndex = this.getInputBuffer().getFilters().length;
    }

    protected boolean addInputFilter(InputFilter[] inputFilters, String encodingName) {
        if (!encodingName.equals("identity")) {
            if (encodingName.equals("chunked")) {
                this.getInputBuffer().addActiveFilter(inputFilters[1]);
                this.contentDelimitation = true;
            } else {
                for (int i = this.pluggableFilterIndex; i < inputFilters.length; ++i) {
                    if (!inputFilters[i].getEncodingName().toString().equals(encodingName)) continue;
                    this.getInputBuffer().addActiveFilter(inputFilters[i]);
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public final void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.COMMIT) {
            if (this.response.isCommitted()) {
                return;
            }
            try {
                this.prepareResponse();
                this.getOutputBuffer().commit();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.ACK) {
            if (this.response.isCommitted() || !this.expectation) {
                return;
            }
            this.getInputBuffer().setSwallowInput(true);
            try {
                this.getOutputBuffer().sendAck();
            }
            catch (IOException e) {
                this.error = true;
            }
        } else if (actionCode == ActionCode.CLIENT_FLUSH) {
            try {
                this.getOutputBuffer().flush();
            }
            catch (IOException e) {
                this.error = true;
                this.response.setErrorException(e);
            }
        } else if (actionCode == ActionCode.RESET) {
            this.getOutputBuffer().reset();
        } else if (actionCode != ActionCode.CUSTOM) {
            if (actionCode == ActionCode.REQ_SET_BODY_REPLAY) {
                ByteChunk body = (ByteChunk)param;
                SavedRequestInputFilter savedBody = new SavedRequestInputFilter(body);
                savedBody.setRequest(this.request);
                AbstractInputBuffer internalBuffer = (AbstractInputBuffer)this.request.getInputBuffer();
                internalBuffer.addActiveFilter(savedBody);
            } else if (actionCode == ActionCode.ASYNC_START) {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)param);
            } else if (actionCode == ActionCode.ASYNC_DISPATCHED) {
                this.asyncStateMachine.asyncDispatched();
            } else if (actionCode == ActionCode.ASYNC_TIMEOUT) {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.asyncStateMachine.asyncTimeout());
            } else if (actionCode == ActionCode.ASYNC_RUN) {
                this.asyncStateMachine.asyncRun((Runnable)param);
            } else if (actionCode == ActionCode.ASYNC_ERROR) {
                this.asyncStateMachine.asyncError();
            } else if (actionCode == ActionCode.ASYNC_IS_STARTED) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
            } else if (actionCode == ActionCode.ASYNC_IS_DISPATCHING) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
            } else if (actionCode == ActionCode.ASYNC_IS_ASYNC) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
            } else if (actionCode == ActionCode.ASYNC_IS_TIMINGOUT) {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
            } else {
                this.actionInternal(actionCode, param);
            }
        }
    }

    abstract void actionInternal(ActionCode var1, Object var2);

    private void prepareResponse() {
        MessageBytes methodMB;
        boolean entityBody = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilters = this.getOutputBuffer().getFilters();
        if (this.http09) {
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
            return;
        }
        int statusCode = this.response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.getOutputBuffer().addActiveFilter(outputFilters[2]);
            entityBody = false;
            this.contentDelimitation = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.getOutputBuffer().addActiveFilter(outputFilters[2]);
            this.contentDelimitation = true;
        }
        boolean sendingWithSendfile = false;
        if (this.getEndpoint().getUseSendfile()) {
            sendingWithSendfile = this.prepareSendfile(outputFilters);
        }
        boolean isCompressable = false;
        boolean useCompression = false;
        if (entityBody && this.compressionLevel > 0 && !sendingWithSendfile) {
            isCompressable = this.isCompressable();
            if (isCompressable) {
                useCompression = this.useCompression();
            }
            if (useCompression) {
                this.response.setContentLength(-1);
            }
        }
        MimeHeaders headers = this.response.getMimeHeaders();
        if (!entityBody) {
            this.response.setContentLength(-1);
        } else {
            String contentLanguage;
            String contentType = this.response.getContentType();
            if (contentType != null) {
                headers.setValue("Content-Type").setString(contentType);
            }
            if ((contentLanguage = this.response.getContentLanguage()) != null) {
                headers.setValue("Content-Language").setString(contentLanguage);
            }
        }
        long contentLength = this.response.getContentLengthLong();
        if (contentLength != -1L) {
            headers.setValue("Content-Length").setLong(contentLength);
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
            this.contentDelimitation = true;
        } else if (entityBody && this.http11) {
            this.getOutputBuffer().addActiveFilter(outputFilters[1]);
            this.contentDelimitation = true;
            headers.addValue("Transfer-Encoding").setString("chunked");
        } else {
            this.getOutputBuffer().addActiveFilter(outputFilters[0]);
        }
        if (useCompression) {
            this.getOutputBuffer().addActiveFilter(outputFilters[3]);
            headers.setValue("Content-Encoding").setString("gzip");
        }
        if (isCompressable) {
            MessageBytes vary = headers.getValue("Vary");
            if (vary == null) {
                headers.setValue("Vary").setString("Accept-Encoding");
            } else if (!vary.equals("*")) {
                headers.setValue("Vary").setString(vary.getString() + ",Accept-Encoding");
            }
        }
        headers.setValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        if (entityBody && !this.contentDelimitation) {
            this.keepAlive = false;
        }
        boolean bl = this.keepAlive = this.keepAlive && !this.statusDropsConnection(statusCode);
        if (!this.keepAlive) {
            headers.addValue("Connection").setString("close");
        } else if (!this.http11 && !this.error) {
            headers.addValue("Connection").setString("keep-alive");
        }
        this.getOutputBuffer().sendStatus();
        if (this.server != null) {
            headers.setValue("Server").setString(this.server);
        } else if (headers.getValue("Server") == null) {
            this.getOutputBuffer().write(Constants.SERVER_BYTES);
        }
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            this.getOutputBuffer().sendHeader(headers.getName(i), headers.getValue(i));
        }
        this.getOutputBuffer().endHeaders();
    }

    abstract AbstractEndpoint getEndpoint();

    abstract boolean prepareSendfile(OutputFilter[] var1);

    public void endRequest() {
        try {
            this.getInputBuffer().endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.getLog().error((Object)sm.getString("http11processor.request.finish"), t);
            this.response.setStatus(500);
            this.adapter.log(this.request, this.response, 0L);
            this.error = true;
        }
        try {
            this.getOutputBuffer().endRequest();
        }
        catch (IOException e) {
            this.error = true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.getLog().error((Object)sm.getString("http11processor.response.finish"), t);
            this.error = true;
        }
    }

    public final void recycle() {
        this.getInputBuffer().recycle();
        this.getOutputBuffer().recycle();
        this.asyncStateMachine.recycle();
        this.recycleInternal();
    }

    protected abstract void recycleInternal();

    @Override
    public abstract Executor getExecutor();

    protected boolean isAsync() {
        return this.asyncStateMachine.isAsync();
    }

    protected AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        return this.asyncStateMachine.asyncPostProcess();
    }
}

