/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.coyote.ActionCode;
import org.apache.coyote.http11.AbstractHttp11Processor;
import org.apache.coyote.http11.AbstractInputBuffer;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.InternalInputBuffer;
import org.apache.coyote.http11.InternalOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Processor
extends AbstractHttp11Processor<Socket> {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    protected SSLSupport sslSupport;
    protected SocketWrapper<Socket> socket;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    public Http11Processor(int headerBufferSize, JIoEndpoint endpoint, int maxTrailerSize) {
        super(endpoint);
        this.inputBuffer = new InternalInputBuffer(this.request, headerBufferSize);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new InternalOutputBuffer(this.response, headerBufferSize);
        this.response.setOutputBuffer(this.outputBuffer);
        this.initializeFilters(maxTrailerSize);
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int disableKeepAlivePercentage) {
        this.disableKeepAlivePercentage = disableKeepAlivePercentage;
    }

    @Override
    protected boolean disableKeepAlive() {
        int threadsBusy;
        int threadRatio = -1;
        int maxThreads = this.endpoint.getMaxThreads();
        if (maxThreads > 0 && (threadsBusy = this.endpoint.getCurrentThreadsBusy()) > 0) {
            threadRatio = threadsBusy * 100 / maxThreads;
        }
        return threadRatio > this.getDisableKeepAlivePercentage();
    }

    @Override
    protected void setRequestLineReadTimeout() throws IOException {
        if (this.inputBuffer.lastValid == 0 && this.socket.getLastAccess() > -1L) {
            long queueTime;
            int firstReadTimeout = this.keepAliveTimeout == -1 ? 0 : ((queueTime = System.currentTimeMillis() - this.socket.getLastAccess()) >= (long)this.keepAliveTimeout ? 1 : this.keepAliveTimeout - (int)queueTime);
            this.socket.getSocket().setSoTimeout(firstReadTimeout);
            if (!this.inputBuffer.fill(true)) {
                throw new EOFException(sm.getString("iib.eof.error"));
            }
            if (this.endpoint.getSoTimeout() > 0) {
                this.setSocketTimeout(this.endpoint.getSoTimeout());
            } else {
                this.setSocketTimeout(0);
            }
        }
    }

    @Override
    protected boolean handleIncompleteRequestLineRead() {
        return false;
    }

    @Override
    protected void setSocketTimeout(int timeout) throws IOException {
        this.socket.getSocket().setSoTimeout(timeout);
    }

    @Override
    protected void setCometTimeouts(SocketWrapper<Socket> socketWrapper) {
    }

    @Override
    protected boolean breakKeepAliveLoop(SocketWrapper<Socket> socketWrapper) {
        this.openSocket = this.keepAlive;
        return this.inputBuffer.lastValid == 0;
    }

    @Override
    protected void registerForEvent(boolean read, boolean write) {
    }

    @Override
    protected void resetTimeouts() {
    }

    @Override
    protected void recycleInternal() {
        this.socket = null;
        this.sslSupport = null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("http11processor.comet.notsupported"));
    }

    @Override
    public void actionInternal(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.REQ_SSL_ATTRIBUTE) {
            try {
                if (this.sslSupport != null) {
                    Object sslO = this.sslSupport.getCipherSuite();
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.cipher_suite", sslO);
                    }
                    if ((sslO = this.sslSupport.getPeerCertificateChain(false)) != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                    if ((sslO = this.sslSupport.getKeySize()) != null) {
                        this.request.setAttribute("javax.servlet.request.key_size", sslO);
                    }
                    if ((sslO = this.sslSupport.getSessionId()) != null) {
                        this.request.setAttribute("javax.servlet.request.ssl_session_id", sslO);
                    }
                    this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
                }
            }
            catch (Exception e) {
                log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
            }
        } else if (actionCode == ActionCode.REQ_HOST_ADDR_ATTRIBUTE) {
            if (this.socket == null) {
                this.request.remoteAddr().recycle();
            } else {
                InetAddress inetAddr;
                if (this.socket.getRemoteAddr() == null && (inetAddr = this.socket.getSocket().getInetAddress()) != null) {
                    this.socket.setRemoteAddr(inetAddr.getHostAddress());
                }
                this.request.remoteAddr().setString(this.socket.getRemoteAddr());
            }
        } else if (actionCode == ActionCode.REQ_LOCAL_NAME_ATTRIBUTE) {
            if (this.socket == null) {
                this.request.localName().recycle();
            } else {
                InetAddress inetAddr;
                if (this.socket.getLocalName() == null && (inetAddr = this.socket.getSocket().getLocalAddress()) != null) {
                    this.socket.setLocalName(inetAddr.getHostName());
                }
                this.request.localName().setString(this.socket.getLocalName());
            }
        } else if (actionCode == ActionCode.REQ_HOST_ATTRIBUTE) {
            if (this.socket == null) {
                this.request.remoteHost().recycle();
            } else {
                if (this.socket.getRemoteHost() == null) {
                    InetAddress inetAddr = this.socket.getSocket().getInetAddress();
                    if (inetAddr != null) {
                        this.socket.setRemoteHost(inetAddr.getHostName());
                    }
                    if (this.socket.getRemoteHost() == null) {
                        if (this.socket.getRemoteAddr() == null && inetAddr != null) {
                            this.socket.setRemoteAddr(inetAddr.getHostAddress());
                        }
                        if (this.socket.getRemoteAddr() != null) {
                            this.socket.setRemoteHost(this.socket.getRemoteAddr());
                        }
                    }
                }
                this.request.remoteHost().setString(this.socket.getRemoteHost());
            }
        } else if (actionCode == ActionCode.REQ_LOCAL_ADDR_ATTRIBUTE) {
            if (this.socket == null) {
                this.request.localAddr().recycle();
            } else {
                if (this.socket.getLocalAddr() == null) {
                    this.socket.setLocalAddr(this.socket.getSocket().getLocalAddress().getHostAddress());
                }
                this.request.localAddr().setString(this.socket.getLocalAddr());
            }
        } else if (actionCode == ActionCode.REQ_REMOTEPORT_ATTRIBUTE) {
            if (this.socket == null) {
                this.request.setRemotePort(0);
            } else {
                if (this.socket.getRemotePort() == -1) {
                    this.socket.setRemotePort(this.socket.getSocket().getPort());
                }
                this.request.setRemotePort(this.socket.getRemotePort());
            }
        } else if (actionCode == ActionCode.REQ_LOCALPORT_ATTRIBUTE) {
            if (this.socket == null) {
                this.request.setLocalPort(0);
            } else {
                if (this.socket.getLocalPort() == -1) {
                    this.socket.setLocalPort(this.socket.getSocket().getLocalPort());
                }
                this.request.setLocalPort(this.socket.getLocalPort());
            }
        } else if (actionCode == ActionCode.REQ_SSL_CERTIFICATE) {
            if (this.sslSupport != null) {
                InputFilter[] inputFilters = this.inputBuffer.getFilters();
                ((BufferedInputFilter)inputFilters[3]).setLimit(this.maxSavePostSize);
                this.inputBuffer.addActiveFilter(inputFilters[3]);
                try {
                    Object[] sslO = this.sslSupport.getPeerCertificateChain(true);
                    if (sslO != null) {
                        this.request.setAttribute("javax.servlet.request.X509Certificate", sslO);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)e);
                }
            }
        } else if (actionCode == ActionCode.ASYNC_COMPLETE) {
            if (this.asyncStateMachine.asyncComplete()) {
                ((JIoEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN_READ);
            }
        } else if (actionCode == ActionCode.ASYNC_SETTIMEOUT) {
            if (param == null) {
                return;
            }
            long timeout = (Long)param;
            this.socket.setTimeout(timeout);
        } else if (actionCode == ActionCode.ASYNC_DISPATCH && this.asyncStateMachine.asyncDispatch()) {
            ((JIoEndpoint)this.endpoint).processSocketAsync(this.socket, SocketStatus.OPEN_READ);
        }
    }

    @Override
    protected void prepareRequestInternal() {
    }

    @Override
    protected boolean prepareSendfile(OutputFilter[] outputFilters) {
        Exception e = new Exception();
        log.error((Object)sm.getString("http11processor.neverused"), (Throwable)e);
        return false;
    }

    @Override
    protected void setSocketWrapper(SocketWrapper<Socket> socketWrapper) {
        this.socket = socketWrapper;
    }

    @Override
    protected AbstractInputBuffer<Socket> getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    protected AbstractOutputBuffer<Socket> getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setSocketBuffer(int socketBuffer) {
        super.setSocketBuffer(socketBuffer);
        this.outputBuffer.setSocketBuffer(socketBuffer);
    }
}

