/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.StackMapType;

public final class StackMapTableEntry
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private int frame_type;
    private int number_of_locals;
    private StackMapType[] types_of_locals;
    private int number_of_stack_items;
    private StackMapType[] types_of_stack_items;

    StackMapTableEntry(DataInputStream file) throws IOException {
        this(file.read(), -1, null, -1, null);
        if (this.frame_type < 0 || this.frame_type > 63) {
            if (this.frame_type >= 64 && this.frame_type <= 127) {
                this.number_of_stack_items = 1;
                this.types_of_stack_items = new StackMapType[1];
                this.types_of_stack_items[0] = new StackMapType(file);
            } else if (this.frame_type == 247) {
                file.readShort();
                this.number_of_stack_items = 1;
                this.types_of_stack_items = new StackMapType[1];
                this.types_of_stack_items[0] = new StackMapType(file);
            } else if (this.frame_type >= 248 && this.frame_type <= 250) {
                file.readShort();
            } else if (this.frame_type == 251) {
                file.readShort();
            } else if (this.frame_type >= 252 && this.frame_type <= 254) {
                file.readShort();
                this.number_of_locals = this.frame_type - 251;
                this.types_of_locals = new StackMapType[this.number_of_locals];
                for (int i = 0; i < this.number_of_locals; ++i) {
                    this.types_of_locals[i] = new StackMapType(file);
                }
            } else if (this.frame_type == 255) {
                int i;
                file.readShort();
                this.number_of_locals = file.readShort();
                this.types_of_locals = new StackMapType[this.number_of_locals];
                for (i = 0; i < this.number_of_locals; ++i) {
                    this.types_of_locals[i] = new StackMapType(file);
                }
                this.number_of_stack_items = file.readShort();
                this.types_of_stack_items = new StackMapType[this.number_of_stack_items];
                for (i = 0; i < this.number_of_stack_items; ++i) {
                    this.types_of_stack_items[i] = new StackMapType(file);
                }
            } else {
                throw new ClassFormatException("Invalid frame type found while parsing stack map table: " + this.frame_type);
            }
        }
    }

    public StackMapTableEntry(int tag, int number_of_locals, StackMapType[] types_of_locals, int number_of_stack_items, StackMapType[] types_of_stack_items) {
        this.frame_type = tag;
        this.number_of_locals = number_of_locals;
        this.types_of_locals = types_of_locals;
        this.number_of_stack_items = number_of_stack_items;
        this.types_of_stack_items = types_of_stack_items;
    }
}

