/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SocketWrapper<E> {
    protected volatile E socket;
    protected volatile long lastAccess = -1L;
    private long timeout = -1L;
    protected boolean error = false;
    protected volatile int keepAliveLeft = 100;
    private boolean comet = false;
    protected boolean async = false;
    protected boolean keptAlive = false;
    private boolean upgraded = false;
    private int localPort = -1;
    private String localName = null;
    private String localAddr = null;
    private int remotePort = -1;
    private String remoteHost = null;
    private String remoteAddr = null;
    private volatile boolean blockingStatus = true;
    private final Lock blockingStatusReadLock;
    private final ReentrantReadWriteLock.WriteLock blockingStatusWriteLock;
    private final Object writeThreadLock = new Object();

    public Object getWriteThreadLock() {
        return this.writeThreadLock;
    }

    public SocketWrapper(E socket) {
        this.socket = socket;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.blockingStatusReadLock = lock.readLock();
        this.blockingStatusWriteLock = lock.writeLock();
    }

    public E getSocket() {
        return this.socket;
    }

    public boolean isComet() {
        return this.comet;
    }

    public void setComet(boolean comet) {
        this.comet = comet;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public boolean isUpgraded() {
        return this.upgraded;
    }

    public void setUpgraded(boolean upgraded) {
        this.upgraded = upgraded;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    public void access() {
        this.access(System.currentTimeMillis());
    }

    public void access(long access) {
        this.lastAccess = access;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean getError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public void setKeepAliveLeft(int keepAliveLeft) {
        this.keepAliveLeft = keepAliveLeft;
    }

    public int decrementKeepAlive() {
        return --this.keepAliveLeft;
    }

    public boolean isKeptAlive() {
        return this.keptAlive;
    }

    public void setKeptAlive(boolean keptAlive) {
        this.keptAlive = keptAlive;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public boolean getBlockingStatus() {
        return this.blockingStatus;
    }

    public void setBlockingStatus(boolean blockingStatus) {
        this.blockingStatus = blockingStatus;
    }

    public Lock getBlockingStatusReadLock() {
        return this.blockingStatusReadLock;
    }

    public ReentrantReadWriteLock.WriteLock getBlockingStatusWriteLock() {
        return this.blockingStatusWriteLock;
    }
}

