/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

public class PStmtKey {
    private final String _sql;
    private final Integer _resultSetType;
    private final Integer _resultSetConcurrency;
    private final String _catalog;
    private final byte _stmtType;

    public PStmtKey(String sql) {
        this(sql, null, 0);
    }

    public PStmtKey(String sql, String catalog) {
        this(sql, catalog, 0);
    }

    public PStmtKey(String sql, String catalog, byte stmtType) {
        this._sql = sql;
        this._catalog = catalog;
        this._stmtType = stmtType;
        this._resultSetType = null;
        this._resultSetConcurrency = null;
    }

    public PStmtKey(String sql, int resultSetType, int resultSetConcurrency) {
        this(sql, null, resultSetType, resultSetConcurrency, 0);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency) {
        this(sql, catalog, resultSetType, resultSetConcurrency, 0);
    }

    public PStmtKey(String sql, String catalog, int resultSetType, int resultSetConcurrency, byte stmtType) {
        this._sql = sql;
        this._catalog = catalog;
        this._resultSetType = new Integer(resultSetType);
        this._resultSetConcurrency = new Integer(resultSetConcurrency);
        this._stmtType = stmtType;
    }

    public String getSql() {
        return this._sql;
    }

    public Integer getResultSetType() {
        return this._resultSetType;
    }

    public Integer getResultSetConcurrency() {
        return this._resultSetConcurrency;
    }

    public String getCatalog() {
        return this._catalog;
    }

    public byte getStmtType() {
        return this._stmtType;
    }

    public boolean equals(Object that) {
        try {
            PStmtKey key = (PStmtKey)that;
            return (null == this._sql && null == key._sql || this._sql.equals(key._sql)) && (null == this._catalog && null == key._catalog || this._catalog.equals(key._catalog)) && (null == this._resultSetType && null == key._resultSetType || this._resultSetType.equals(key._resultSetType)) && (null == this._resultSetConcurrency && null == key._resultSetConcurrency || this._resultSetConcurrency.equals(key._resultSetConcurrency)) && this._stmtType == key._stmtType;
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public int hashCode() {
        if (this._catalog == null) {
            return null == this._sql ? 0 : this._sql.hashCode();
        }
        return null == this._sql ? this._catalog.hashCode() : (this._catalog + this._sql).hashCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("PStmtKey: sql=");
        buf.append(this._sql);
        buf.append(", catalog=");
        buf.append(this._catalog);
        buf.append(", resultSetType=");
        buf.append(this._resultSetType);
        buf.append(", resultSetConcurrency=");
        buf.append(this._resultSetConcurrency);
        buf.append(", statmentType=");
        buf.append(this._stmtType);
        return buf.toString();
    }
}

