/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp2.PStmtKey;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolingConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class PoolableConnectionFactory
implements PooledObjectFactory<PoolableConnection> {
    private static final Log log = LogFactory.getLog(PoolableConnectionFactory.class);
    protected volatile ConnectionFactory _connFactory = null;
    protected volatile String _validationQuery = null;
    protected volatile int _validationQueryTimeout = -1;
    protected Collection<String> _connectionInitSqls = null;
    protected volatile ObjectPool<PoolableConnection> _pool = null;
    protected Boolean _defaultReadOnly = null;
    protected boolean _defaultAutoCommit = true;
    protected int _defaultTransactionIsolation = -1;
    protected String _defaultCatalog;
    protected boolean _cacheState;
    protected boolean poolStatements = false;
    protected int maxOpenPreparedStatements = 8;
    private long maxConnLifetimeMillis = -1L;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public void setConnectionFactory(ConnectionFactory connFactory) {
        this._connFactory = connFactory;
    }

    public void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public void setValidationQueryTimeout(int timeout) {
        this._validationQueryTimeout = timeout;
    }

    public synchronized void setConnectionInitSql(Collection<String> connectionInitSqls) {
        this._connectionInitSqls = connectionInitSqls;
    }

    public synchronized void setPool(ObjectPool<PoolableConnection> pool) {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = pool;
    }

    public synchronized ObjectPool<PoolableConnection> getPool() {
        return this._pool;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this._defaultReadOnly = defaultReadOnly ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this._defaultAutoCommit = defaultAutoCommit;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this._defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this._defaultCatalog = defaultCatalog;
    }

    public void setCacheState(boolean cacheState) {
        this._cacheState = cacheState;
    }

    public void setPoolStatements(boolean poolStatements) {
        this.poolStatements = poolStatements;
    }

    public void setMaxOpenPrepatedStatements(int maxOpenPreparedStatements) {
        this.maxOpenPreparedStatements = maxOpenPreparedStatements;
    }

    public void setMaxConnLifetimeMillis(long maxConnLifetimeMillis) {
        this.maxConnLifetimeMillis = maxConnLifetimeMillis;
    }

    @Override
    public PooledObject<PoolableConnection> makeObject() throws Exception {
        Connection conn = this._connFactory.createConnection();
        if (conn == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        try {
            this.initializeConnection(conn);
        }
        catch (SQLException sqle) {
            try {
                conn.close();
            }
            catch (SQLException ignore) {
                // empty catch block
            }
            throw sqle;
        }
        if (this.poolStatements) {
            conn = new PoolingConnection(conn);
            GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
            config.setMaxTotalPerKey(-1);
            config.setBlockWhenExhausted(false);
            config.setMaxWaitMillis(0L);
            config.setMaxIdlePerKey(1);
            config.setMaxTotal(this.maxOpenPreparedStatements);
            GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement> stmtPool = new GenericKeyedObjectPool<PStmtKey, DelegatingPreparedStatement>((PoolingConnection)conn, config);
            ((PoolingConnection)conn).setStatementPool(stmtPool);
            ((PoolingConnection)conn).setCacheState(this._cacheState);
        }
        return new DefaultPooledObject<PoolableConnection>(new PoolableConnection(conn, this._pool));
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        Collection<String> sqls = this._connectionInitSqls;
        if (conn.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (null != sqls) {
            try (Statement stmt = conn.createStatement();){
                for (String sql : sqls) {
                    if (sql == null) {
                        throw new NullPointerException("null connectionInitSqls element");
                    }
                    stmt.execute(sql);
                }
            }
        }
    }

    @Override
    public void destroyObject(PooledObject<PoolableConnection> p) throws Exception {
        p.getObject().reallyClose();
    }

    @Override
    public boolean validateObject(PooledObject<PoolableConnection> p) {
        try {
            this.validateLifetime(p);
            this.validateConnection(p.getObject());
            return true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)Utils.getMessage("poolableConnectionFactory.validateObject.fail"), (Throwable)e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection(Connection conn) throws SQLException {
        String query = this._validationQuery;
        if (conn.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (null != query) {
            Statement stmt = null;
            ResultSet rset = null;
            try {
                stmt = conn.createStatement();
                if (this._validationQueryTimeout > 0) {
                    stmt.setQueryTimeout(this._validationQueryTimeout);
                }
                if (!(rset = stmt.executeQuery(query)).next()) {
                    throw new SQLException("validationQuery didn't return a row");
                }
            }
            finally {
                if (rset != null) {
                    try {
                        rset.close();
                    }
                    catch (Exception t) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception t) {}
                }
            }
        }
    }

    @Override
    public void passivateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        if (!conn.getAutoCommit() && !conn.isReadOnly()) {
            conn.rollback();
        }
        conn.clearWarnings();
        if (!conn.getAutoCommit()) {
            conn.setAutoCommit(true);
        }
        conn.passivate();
    }

    @Override
    public void activateObject(PooledObject<PoolableConnection> p) throws Exception {
        this.validateLifetime(p);
        PoolableConnection conn = p.getObject();
        conn.activate();
        if (conn.getAutoCommit() != this._defaultAutoCommit) {
            conn.setAutoCommit(this._defaultAutoCommit);
        }
        if (this._defaultTransactionIsolation != -1 && conn.getTransactionIsolation() != this._defaultTransactionIsolation) {
            conn.setTransactionIsolation(this._defaultTransactionIsolation);
        }
        if (this._defaultReadOnly != null && conn.isReadOnly() != this._defaultReadOnly.booleanValue()) {
            conn.setReadOnly(this._defaultReadOnly);
        }
        if (this._defaultCatalog != null && !this._defaultCatalog.equals(conn.getCatalog())) {
            conn.setCatalog(this._defaultCatalog);
        }
    }

    private void validateLifetime(PooledObject<PoolableConnection> p) throws Exception {
        long lifetime;
        if (this.maxConnLifetimeMillis > 0L && (lifetime = System.currentTimeMillis() - p.getCreateTime()) > this.maxConnLifetimeMillis) {
            throw new Exception(Utils.getMessage("connectionFactory.lifetimeExceeded", lifetime, this.maxConnLifetimeMillis));
        }
    }
}

