/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.SwallowedExceptionLogger;
import org.apache.tomcat.dbcp.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PerUserPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PoolKey;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -3104731034410444060L;
    private static final Log log = LogFactory.getLog(PerUserPoolDataSource.class);
    private int defaultMaxTotal = 8;
    private int defaultMaxIdle = 8;
    private int defaultMaxWaitMillis = (int)Math.min(Integer.MAX_VALUE, -1L);
    Map<String, Boolean> perUserDefaultAutoCommit = null;
    Map<String, Integer> perUserDefaultTransactionIsolation = null;
    Map<String, Integer> perUserMaxTotal = null;
    Map<String, Integer> perUserMaxIdle = null;
    Map<String, Integer> perUserMaxWaitMillis = null;
    Map<String, Boolean> perUserDefaultReadOnly = null;
    private transient Map<PoolKey, PooledConnectionManager> managers = new HashMap<PoolKey, PooledConnectionManager>();

    @Override
    public void close() {
        for (PooledConnectionManager manager : this.managers.values()) {
            try {
                ((CPDSConnectionFactory)manager).getPool().close();
            }
            catch (Exception exception) {}
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getDefaultMaxTotal() {
        return this.defaultMaxTotal;
    }

    public void setDefaultMaxTotal(int maxActive) {
        this.assertInitializationAllowed();
        this.defaultMaxTotal = maxActive;
    }

    public int getDefaultMaxIdle() {
        return this.defaultMaxIdle;
    }

    public void setDefaultMaxIdle(int defaultMaxIdle) {
        this.assertInitializationAllowed();
        this.defaultMaxIdle = defaultMaxIdle;
    }

    public int getDefaultMaxWaitMillis() {
        return this.defaultMaxWaitMillis;
    }

    public void setDefaultMaxWaitMillis(int defaultMaxWaitMillis) {
        this.assertInitializationAllowed();
        this.defaultMaxWaitMillis = defaultMaxWaitMillis;
    }

    public Boolean getPerUserDefaultAutoCommit(String key) {
        Boolean value = null;
        if (this.perUserDefaultAutoCommit != null) {
            value = this.perUserDefaultAutoCommit.get(key);
        }
        return value;
    }

    public void setPerUserDefaultAutoCommit(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = new HashMap<String, Boolean>();
        }
        this.perUserDefaultAutoCommit.put(username, value);
    }

    public Integer getPerUserDefaultTransactionIsolation(String username) {
        Integer value = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            value = this.perUserDefaultTransactionIsolation.get(username);
        }
        return value;
    }

    public void setPerUserDefaultTransactionIsolation(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        }
        this.perUserDefaultTransactionIsolation.put(username, value);
    }

    public Integer getPerUserMaxTotal(String username) {
        Integer value = null;
        if (this.perUserMaxTotal != null) {
            value = this.perUserMaxTotal.get(username);
        }
        return value;
    }

    public void setPerUserMaxTotal(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxTotal == null) {
            this.perUserMaxTotal = new HashMap<String, Integer>();
        }
        this.perUserMaxTotal.put(username, value);
    }

    public Integer getPerUserMaxIdle(String username) {
        Integer value = null;
        if (this.perUserMaxIdle != null) {
            value = this.perUserMaxIdle.get(username);
        }
        return value;
    }

    public void setPerUserMaxIdle(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        }
        this.perUserMaxIdle.put(username, value);
    }

    public Integer getPerUserMaxWaitMillis(String username) {
        Integer value = null;
        if (this.perUserMaxWaitMillis != null) {
            value = this.perUserMaxWaitMillis.get(username);
        }
        return value;
    }

    public void setPerUserMaxWaitMillis(String username, Integer value) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWaitMillis == null) {
            this.perUserMaxWaitMillis = new HashMap<String, Integer>();
        }
        this.perUserMaxWaitMillis.put(username, value);
    }

    public Boolean getPerUserDefaultReadOnly(String username) {
        Boolean value = null;
        if (this.perUserDefaultReadOnly != null) {
            value = this.perUserDefaultReadOnly.get(username);
        }
        return value;
    }

    public void setPerUserDefaultReadOnly(String username, Boolean value) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = new HashMap<String, Boolean>();
        }
        this.perUserDefaultReadOnly.put(username, value);
    }

    public int getNumActive() {
        return this.getNumActive(null, null);
    }

    public int getNumActive(String username, String password) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(username, password));
        return pool == null ? 0 : pool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null, null);
    }

    public int getNumIdle(String username, String password) {
        ObjectPool<PooledConnectionAndInfo> pool = this.getPool(this.getPoolKey(username, password));
        return pool == null ? 0 : pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        ObjectPool<PooledConnectionAndInfo> pool;
        PooledConnectionManager manager;
        PoolKey key = this.getPoolKey(username, password);
        PerUserPoolDataSource perUserPoolDataSource = this;
        synchronized (perUserPoolDataSource) {
            manager = this.managers.get(key);
            if (manager == null) {
                try {
                    this.registerPool(username, password);
                    manager = this.managers.get(key);
                }
                catch (NamingException e) {
                    throw new SQLException("RegisterPool failed", e);
                }
            }
            pool = ((CPDSConnectionFactory)manager).getPool();
        }
        PooledConnectionAndInfo info = null;
        try {
            info = pool.borrowObject();
        }
        catch (NoSuchElementException ex) {
            throw new SQLException("Could not retrieve connection info from pool", ex);
        }
        catch (Exception e) {
            try {
                this.testCPDS(username, password);
            }
            catch (Exception ex) {
                throw (SQLException)new SQLException("Could not retrieve connection info from pool").initCause(ex);
            }
            manager.closePool(username);
            PerUserPoolDataSource ex = this;
            synchronized (ex) {
                this.managers.remove(key);
            }
            try {
                this.registerPool(username, password);
                pool = this.getPool(key);
            }
            catch (NamingException ne) {
                throw new SQLException("RegisterPool failed", ne);
            }
            try {
                info = pool.borrowObject();
            }
            catch (Exception ex2) {
                throw (SQLException)new SQLException("Could not retrieve connection info from pool").initCause(ex2);
            }
        }
        return info;
    }

    @Override
    protected void setupDefaults(Connection con, String username) throws SQLException {
        Integer userMax;
        Boolean userMax2;
        Boolean userMax3;
        boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (username != null && (userMax3 = this.getPerUserDefaultAutoCommit(username)) != null) {
            defaultAutoCommit = userMax3;
        }
        boolean defaultReadOnly = this.isDefaultReadOnly();
        if (username != null && (userMax2 = this.getPerUserDefaultReadOnly(username)) != null) {
            defaultReadOnly = userMax2;
        }
        int defaultTransactionIsolation = this.getDefaultTransactionIsolation();
        if (username != null && (userMax = this.getPerUserDefaultTransactionIsolation(username)) != null) {
            defaultTransactionIsolation = userMax;
        }
        if (con.getAutoCommit() != defaultAutoCommit) {
            con.setAutoCommit(defaultAutoCommit);
        }
        if (defaultTransactionIsolation != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
        if (con.isReadOnly() != defaultReadOnly) {
            con.setReadOnly(defaultReadOnly);
        }
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey upkey) {
        return this.managers.get(this.getPoolKey(upkey.getUsername(), upkey.getPassword()));
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), PerUserPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        return ref;
    }

    private PoolKey getPoolKey(String username, String password) {
        return new PoolKey(this.getDataSourceName(), username);
    }

    private synchronized void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        Integer userMax = this.getPerUserMaxTotal(username);
        int maxTotal = userMax == null ? this.getDefaultMaxTotal() : userMax.intValue();
        userMax = this.getPerUserMaxIdle(username);
        int maxIdle = userMax == null ? this.getDefaultMaxIdle() : userMax.intValue();
        userMax = this.getPerUserMaxWaitMillis(username);
        int maxWaitMillis = userMax == null ? this.getDefaultMaxWaitMillis() : userMax.intValue();
        CPDSConnectionFactory factory = new CPDSConnectionFactory(cpds, this.getValidationQuery(), this.isRollbackAfterValidation(), username, password);
        factory.setMaxConnLifetimeMillis(this.getMaxConnLifetimeMillis());
        GenericObjectPool<PooledConnectionAndInfo> pool = new GenericObjectPool<PooledConnectionAndInfo>(factory);
        factory.setPool(pool);
        pool.setMaxTotal(maxTotal);
        pool.setMaxIdle(maxIdle);
        pool.setMaxWaitMillis(maxWaitMillis);
        if (maxTotal <= 0) {
            pool.setBlockWhenExhausted(false);
            pool.setMaxTotal(Integer.MAX_VALUE);
        }
        if (maxWaitMillis == 0) {
            pool.setBlockWhenExhausted(false);
        }
        pool.setTestOnBorrow(this.getTestOnBorrow());
        pool.setTestOnReturn(this.getTestOnReturn());
        pool.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        pool.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        pool.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        pool.setTestWhileIdle(this.getTestWhileIdle());
        pool.setSwallowedExceptionListener(new SwallowedExceptionLogger(log));
        PooledConnectionManager old = this.managers.put(this.getPoolKey(username, password), factory);
        if (old != null) {
            throw new IllegalStateException("Pool already contains an entry for this user/password: " + username);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            PerUserPoolDataSource oldDS = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.managers = oldDS.managers;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }

    private ObjectPool<PooledConnectionAndInfo> getPool(PoolKey key) {
        CPDSConnectionFactory mgr = (CPDSConnectionFactory)this.managers.get(key);
        return mgr == null ? null : mgr.getPool();
    }
}

