/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyObjectFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.KeyedCPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.SharedPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -8132305535403690372L;
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int maxWaitMillis = (int)Math.min(Integer.MAX_VALUE, -1L);
    private transient KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool = null;
    private transient KeyedCPDSConnectionFactory factory = null;

    @Override
    public void close() throws Exception {
        if (this.pool != null) {
            this.pool.close();
        }
        InstanceKeyObjectFactory.removeInstance(this.instanceKey);
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.assertInitializationAllowed();
        this.maxTotal = maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.assertInitializationAllowed();
        this.maxIdle = maxIdle;
    }

    public int getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(int maxWaitMillis) {
        this.assertInitializationAllowed();
        this.maxWaitMillis = maxWaitMillis;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String username, String password) throws SQLException {
        SharedPoolDataSource sharedPoolDataSource = this;
        synchronized (sharedPoolDataSource) {
            if (this.pool == null) {
                try {
                    this.registerPool(username, password);
                }
                catch (NamingException e) {
                    throw new SQLException("RegisterPool failed", e);
                }
            }
        }
        PooledConnectionAndInfo info = null;
        UserPassKey key = new UserPassKey(username, password);
        try {
            info = this.pool.borrowObject(key);
        }
        catch (Exception e) {
            throw new SQLException("Could not retrieve connection info from pool", e);
        }
        return info;
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey upkey) {
        return this.factory;
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), SharedPoolDataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr("instanceKey", this.instanceKey));
        return ref;
    }

    private void registerPool(String username, String password) throws NamingException, SQLException {
        ConnectionPoolDataSource cpds = this.testCPDS(username, password);
        this.factory = new KeyedCPDSConnectionFactory(cpds, this.getValidationQuery(), this.isRollbackAfterValidation());
        this.factory.setMaxConnLifetimeMillis(this.getMaxConnLifetimeMillis());
        GenericKeyedObjectPoolConfig config = new GenericKeyedObjectPoolConfig();
        config.setMaxTotalPerKey(this.getMaxTotal());
        config.setMaxIdlePerKey(this.getMaxIdle());
        config.setMaxWaitMillis(this.getMaxWaitMillis());
        config.setBlockWhenExhausted(true);
        if (this.maxTotal <= 0) {
            config.setBlockWhenExhausted(false);
            config.setMaxTotalPerKey(Integer.MAX_VALUE);
        }
        if (this.maxWaitMillis == 0) {
            config.setBlockWhenExhausted(false);
        }
        config.setTestOnBorrow(this.getTestOnBorrow());
        config.setTestOnReturn(this.getTestOnReturn());
        config.setTimeBetweenEvictionRunsMillis(this.getTimeBetweenEvictionRunsMillis());
        config.setNumTestsPerEvictionRun(this.getNumTestsPerEvictionRun());
        config.setMinEvictableIdleTimeMillis(this.getMinEvictableIdleTimeMillis());
        config.setTestWhileIdle(this.getTestWhileIdle());
        GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo> tmpPool = new GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo>(this.factory, config);
        this.factory.setPool(tmpPool);
        this.pool = tmpPool;
    }

    @Override
    protected void setupDefaults(Connection con, String username) throws SQLException {
        int defaultTransactionIsolation;
        boolean defaultAutoCommit = this.isDefaultAutoCommit();
        if (con.getAutoCommit() != defaultAutoCommit) {
            con.setAutoCommit(defaultAutoCommit);
        }
        if ((defaultTransactionIsolation = this.getDefaultTransactionIsolation()) != -1) {
            con.setTransactionIsolation(defaultTransactionIsolation);
        }
        boolean defaultReadOnly = this.isDefaultReadOnly();
        if (con.isReadOnly() != defaultReadOnly) {
            con.setReadOnly(defaultReadOnly);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            SharedPoolDataSource oldDS = (SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.pool = oldDS.pool;
        }
        catch (NamingException e) {
            throw new IOException("NamingException: " + e);
        }
    }
}

