/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.SwallowedExceptionListener;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.EvictionPolicy;
import org.apache.tomcat.dbcp.pool2.impl.EvictionTimer;

public abstract class BaseGenericObjectPool<T>
implements NotificationEmitter {
    public static final int MEAN_TIMING_STATS_CACHE_SIZE = 100;
    private volatile int maxTotal = -1;
    private volatile boolean blockWhenExhausted = true;
    private volatile long maxWaitMillis = -1L;
    private volatile boolean lifo = true;
    private volatile boolean testOnBorrow = false;
    private volatile boolean testOnReturn = false;
    private volatile boolean testWhileIdle = false;
    private volatile long timeBetweenEvictionRunsMillis = -1L;
    private volatile int numTestsPerEvictionRun = 3;
    private volatile long minEvictableIdleTimeMillis = 1800000L;
    private volatile long softMinEvictableIdleTimeMillis = -1L;
    private volatile EvictionPolicy<T> evictionPolicy;
    final Object closeLock = new Object();
    volatile boolean closed = false;
    final Object evictionLock = new Object();
    private Evictor evictor = null;
    Iterator<PooledObject<T>> evictionIterator = null;
    private final ClassLoader factoryClassLoader;
    private final ObjectName oname;
    private final NotificationBroadcasterSupport jmxNotificationSupport;
    private final String creationStackTrace;
    private final AtomicLong borrowedCount = new AtomicLong(0L);
    private final AtomicLong returnedCount = new AtomicLong(0L);
    final AtomicLong createdCount = new AtomicLong(0L);
    final AtomicLong destroyedCount = new AtomicLong(0L);
    final AtomicLong destroyedByEvictorCount = new AtomicLong(0L);
    final AtomicLong destroyedByBorrowValidationCount = new AtomicLong(0L);
    private final LinkedList<Long> activeTimes = new LinkedList();
    private final LinkedList<Long> idleTimes = new LinkedList();
    private final LinkedList<Long> waitTimes = new LinkedList();
    private final Object maxBorrowWaitTimeMillisLock = new Object();
    private volatile long maxBorrowWaitTimeMillis = 0L;
    private SwallowedExceptionListener swallowedExceptionListener = null;

    public BaseGenericObjectPool(BaseObjectPoolConfig config, String jmxNameBase, String jmxNamePrefix) {
        if (config.getJmxEnabled()) {
            this.jmxNotificationSupport = new NotificationBroadcasterSupport();
            this.oname = this.jmxRegister(jmxNameBase, jmxNamePrefix);
        } else {
            this.jmxNotificationSupport = null;
            this.oname = null;
        }
        this.creationStackTrace = this.getStackTrace(new Exception());
        this.factoryClassLoader = Thread.currentThread().getContextClassLoader();
        this.initStats();
    }

    public final int getMaxTotal() {
        return this.maxTotal;
    }

    public final void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public final boolean getBlockWhenExhausted() {
        return this.blockWhenExhausted;
    }

    public final void setBlockWhenExhausted(boolean blockWhenExhausted) {
        this.blockWhenExhausted = blockWhenExhausted;
    }

    public final long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public final void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public final boolean getLifo() {
        return this.lifo;
    }

    public final void setLifo(boolean lifo) {
        this.lifo = lifo;
    }

    public final boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public final void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public final boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public final void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public final boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public final void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public final long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public final void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        this.startEvictor(timeBetweenEvictionRunsMillis);
    }

    public final int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public final void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public final long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public final void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public final long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public final void setSoftMinEvictableIdleTimeMillis(long softMinEvictableIdleTimeMillis) {
        this.softMinEvictableIdleTimeMillis = softMinEvictableIdleTimeMillis;
    }

    public final String getEvictionPolicyClassName() {
        return this.evictionPolicy.getClass().getName();
    }

    public final void setEvictionPolicyClassName(String evictionPolicyClassName) {
        try {
            Class<?> clazz = Class.forName(evictionPolicyClassName);
            Object policy = clazz.newInstance();
            if (policy instanceof EvictionPolicy) {
                this.evictionPolicy = (EvictionPolicy)policy;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to create EvictionPolicy instance of type " + evictionPolicyClassName, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Unable to create EvictionPolicy instance of type " + evictionPolicyClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to create EvictionPolicy instance of type " + evictionPolicyClassName, e);
        }
    }

    public abstract void close();

    public final boolean isClosed() {
        return this.closed;
    }

    public abstract void evict() throws Exception;

    final EvictionPolicy<T> getEvictionPolicy() {
        return this.evictionPolicy;
    }

    final void assertOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Pool not open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void startEvictor(long delay) {
        Object object = this.evictionLock;
        synchronized (object) {
            if (null != this.evictor) {
                EvictionTimer.cancel(this.evictor);
                this.evictor = null;
                this.evictionIterator = null;
            }
            if (delay > 0L) {
                this.evictor = new Evictor();
                EvictionTimer.schedule(this.evictor, delay, delay);
            }
        }
    }

    abstract void ensureMinIdle() throws Exception;

    public final ObjectName getJmxName() {
        return this.oname;
    }

    public final String getCreationStackTrace() {
        return this.creationStackTrace;
    }

    public final long getBorrowedCount() {
        return this.borrowedCount.get();
    }

    public final long getReturnedCount() {
        return this.returnedCount.get();
    }

    public final long getCreatedCount() {
        return this.createdCount.get();
    }

    public final long getDestroyedCount() {
        return this.destroyedCount.get();
    }

    public final long getDestroyedByEvictorCount() {
        return this.destroyedByEvictorCount.get();
    }

    public final long getDestroyedByBorrowValidationCount() {
        return this.destroyedByBorrowValidationCount.get();
    }

    public final long getMeanActiveTimeMillis() {
        return this.getMeanFromStatsCache(this.activeTimes);
    }

    public final long getMeanIdleTimeMillis() {
        return this.getMeanFromStatsCache(this.idleTimes);
    }

    public final long getMeanBorrowWaitTimeMillis() {
        return this.getMeanFromStatsCache(this.waitTimes);
    }

    public final long getMaxBorrowWaitTimeMillis() {
        return this.maxBorrowWaitTimeMillis;
    }

    public abstract int getNumIdle();

    public SwallowedExceptionListener getSwallowedExceptionListener() {
        return this.swallowedExceptionListener;
    }

    public void setSwallowedExceptionListener(SwallowedExceptionListener swallowedExceptionListener) {
        this.swallowedExceptionListener = swallowedExceptionListener;
    }

    final NotificationBroadcasterSupport getJmxNotificationSupport() {
        return this.jmxNotificationSupport;
    }

    final void swallowException(Exception e) {
        SwallowedExceptionListener listener = this.getSwallowedExceptionListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onSwallowException(e);
        }
        catch (OutOfMemoryError oome) {
            throw oome;
        }
        catch (VirtualMachineError vme) {
            throw vme;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateStatsBorrow(PooledObject<T> p, long waitTime) {
        this.borrowedCount.incrementAndGet();
        Object object = this.idleTimes;
        synchronized (object) {
            this.idleTimes.add(p.getIdleTimeMillis());
            this.idleTimes.poll();
        }
        object = this.waitTimes;
        synchronized (object) {
            this.waitTimes.add(waitTime);
            this.waitTimes.poll();
        }
        object = this.maxBorrowWaitTimeMillisLock;
        synchronized (object) {
            if (waitTime > this.maxBorrowWaitTimeMillis) {
                this.maxBorrowWaitTimeMillis = waitTime;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateStatsReturn(long activeTime) {
        this.returnedCount.incrementAndGet();
        LinkedList<Long> linkedList = this.activeTimes;
        synchronized (linkedList) {
            this.activeTimes.add(activeTime);
            this.activeTimes.poll();
        }
    }

    final void jmxUnregister() {
        if (this.oname != null) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.oname);
            }
            catch (MBeanRegistrationException e) {
                this.swallowException(e);
            }
            catch (InstanceNotFoundException e) {
                this.swallowException(e);
            }
        }
    }

    private ObjectName jmxRegister(String jmxNameBase, String jmxNamePrefix) {
        ObjectName objectName = null;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        int i = 1;
        boolean registered = false;
        while (!registered) {
            try {
                ObjectName oname = new ObjectName(jmxNameBase + jmxNamePrefix + i);
                mbs.registerMBean(this, oname);
                objectName = oname;
                registered = true;
            }
            catch (MalformedObjectNameException e) {
                if ("pool".equals(jmxNamePrefix)) {
                    registered = true;
                    continue;
                }
                jmxNamePrefix = "pool";
            }
            catch (InstanceAlreadyExistsException e) {
                ++i;
            }
            catch (MBeanRegistrationException e) {
                registered = true;
            }
            catch (NotCompliantMBeanException e) {
                registered = true;
            }
        }
        return objectName;
    }

    private String getStackTrace(Exception e) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        e.printStackTrace(pw);
        return ((Object)w).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getMeanFromStatsCache(LinkedList<Long> cache) {
        ArrayList<Long> times = new ArrayList<Long>(100);
        LinkedList<Long> linkedList = cache;
        synchronized (linkedList) {
            times.addAll(cache);
        }
        double result = 0.0;
        int counter = 0;
        for (Long time : times) {
            if (time == null) continue;
            result = result * ((double)(++counter - 1) / (double)counter) + (double)time.longValue() / (double)counter;
        }
        return (long)result;
    }

    private void initStats() {
        for (int i = 0; i < 100; ++i) {
            this.activeTimes.add(null);
            this.idleTimes.add(null);
            this.waitTimes.add(null);
        }
    }

    @Override
    public final void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (this.jmxNotificationSupport == null) {
            throw new UnsupportedOperationException("JMX is not enabled");
        }
        this.jmxNotificationSupport.addNotificationListener(listener, filter, handback);
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this.jmxNotificationSupport == null) {
            throw new UnsupportedOperationException("JMX is not enabled");
        }
        this.jmxNotificationSupport.removeNotificationListener(listener);
    }

    @Override
    public final MBeanNotificationInfo[] getNotificationInfo() {
        if (this.jmxNotificationSupport == null) {
            throw new UnsupportedOperationException("JMX is not enabled");
        }
        return this.jmxNotificationSupport.getNotificationInfo();
    }

    @Override
    public final void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (this.jmxNotificationSupport == null) {
            throw new UnsupportedOperationException("JMX is not enabled");
        }
        this.jmxNotificationSupport.removeNotificationListener(listener, filter, handback);
    }

    class Evictor
    extends TimerTask {
        Evictor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(BaseGenericObjectPool.this.factoryClassLoader);
                try {
                    BaseGenericObjectPool.this.evict();
                }
                catch (Exception e) {
                    BaseGenericObjectPool.this.swallowException(e);
                }
                catch (OutOfMemoryError oome) {
                    oome.printStackTrace(System.err);
                }
                try {
                    BaseGenericObjectPool.this.ensureMinIdle();
                }
                catch (Exception e) {
                    BaseGenericObjectPool.this.swallowException(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(savedClassLoader);
            }
        }
    }
}

