/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.pool2.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import org.apache.tomcat.dbcp.pool2.KeyedPoolableObjectFactory;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PoolableObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

public class PoolImplUtils {
    public static <T> PooledObjectFactory<T> poolableToPooledObjectFactory(PoolableObjectFactory<T> innerFactory) {
        return new PoolableObjectFactoryWrapper<T>(innerFactory);
    }

    public static <K, V> KeyedPooledObjectFactory<K, V> poolableToKeyedPooledObjectFactory(KeyedPoolableObjectFactory<K, V> innerFactory) {
        return new KeyedPoolableObjectFactoryWrapper<K, V>(innerFactory);
    }

    static Class<?> getFactoryType(Class<? extends PooledObjectFactory> factory) {
        return (Class)PoolImplUtils.getGenericType(PooledObjectFactory.class, factory);
    }

    private static <T> Object getGenericType(Class<T> type, Class<? extends T> clazz) {
        Type[] interfaces;
        for (Type iface : interfaces = clazz.getGenericInterfaces()) {
            ParameterizedType pi;
            if (!(iface instanceof ParameterizedType) || !((pi = (ParameterizedType)iface).getRawType() instanceof Class) || !type.isAssignableFrom((Class)pi.getRawType())) continue;
            return PoolImplUtils.getTypeParameter(clazz, pi.getActualTypeArguments()[0]);
        }
        Class<? extends T> superClazz = clazz.getSuperclass();
        Object result = PoolImplUtils.getGenericType(type, superClazz);
        if (result instanceof Class) {
            return result;
        }
        if (result instanceof Integer) {
            ParameterizedType superClassType = (ParameterizedType)clazz.getGenericSuperclass();
            return PoolImplUtils.getTypeParameter(clazz, superClassType.getActualTypeArguments()[(Integer)result]);
        }
        return null;
    }

    private static Object getTypeParameter(Class<?> clazz, Type argType) {
        if (argType instanceof Class) {
            return argType;
        }
        TypeVariable<Class<?>>[] tvs = clazz.getTypeParameters();
        for (int i = 0; i < tvs.length; ++i) {
            if (!tvs[i].equals(argType)) continue;
            return i;
        }
        return null;
    }

    private static class KeyedPoolableObjectFactoryWrapper<K, V>
    implements KeyedPooledObjectFactory<K, V> {
        private final KeyedPoolableObjectFactory<K, V> innerFactory;

        public KeyedPoolableObjectFactoryWrapper(KeyedPoolableObjectFactory<K, V> innerFactory) {
            this.innerFactory = innerFactory;
        }

        @Override
        public PooledObject<V> makeObject(K key) throws Exception {
            V obj = this.innerFactory.makeObject(key);
            return new DefaultPooledObject<V>(obj);
        }

        @Override
        public void destroyObject(K key, PooledObject<V> p) throws Exception {
            this.innerFactory.destroyObject(key, p.getObject());
        }

        @Override
        public boolean validateObject(K key, PooledObject<V> p) {
            return this.innerFactory.validateObject(key, p.getObject());
        }

        @Override
        public void activateObject(K key, PooledObject<V> p) throws Exception {
            this.innerFactory.activateObject(key, p.getObject());
        }

        @Override
        public void passivateObject(K key, PooledObject<V> p) throws Exception {
            this.innerFactory.passivateObject(key, p.getObject());
        }
    }

    private static class PoolableObjectFactoryWrapper<T>
    implements PooledObjectFactory<T> {
        private final PoolableObjectFactory<T> innerFactory;

        public PoolableObjectFactoryWrapper(PoolableObjectFactory<T> innerFactory) {
            this.innerFactory = innerFactory;
        }

        @Override
        public PooledObject<T> makeObject() throws Exception {
            return new DefaultPooledObject<T>(this.innerFactory.makeObject());
        }

        @Override
        public void destroyObject(PooledObject<T> p) throws Exception {
            this.innerFactory.destroyObject(p.getObject());
        }

        @Override
        public boolean validateObject(PooledObject<T> p) {
            return this.innerFactory.validateObject(p.getObject());
        }

        @Override
        public void activateObject(PooledObject<T> p) throws Exception {
            this.innerFactory.activateObject(p.getObject());
        }

        @Override
        public void passivateObject(PooledObject<T> p) throws Exception {
            this.innerFactory.passivateObject(p.getObject());
        }
    }
}

