/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.servlet.TldScanner;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.xml.sax.SAXException;

public class JasperInitializer
implements ServletContainerInitializer {
    public static final String VALIDATE = "org.apache.jasper.validateDescriptors";
    private static final String MSG = "org.apache.jasper.servlet.JasperInitializer";
    private static final Log LOG = LogFactory.getLog(JasperInitializer.class);

    public void onStartup(Set<Class<?>> types, ServletContext context) throws ServletException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Localizer.getMessage("org.apache.jasper.servlet.JasperInitializer.onStartup", context.getServletContextName()));
        }
        boolean validate = Boolean.valueOf(context.getInitParameter(VALIDATE));
        TldScanner scanner = new TldScanner(context, true, validate);
        try {
            scanner.scan();
        }
        catch (IOException | SAXException e) {
            throw new ServletException((Throwable)e);
        }
        for (String listener : scanner.getListeners()) {
            context.addListener(listener);
        }
        Map<String, TldResourcePath> taglibMap = scanner.getTaglibMap();
        context.setAttribute(TldLocationsCache.KEY, (Object)new TldLocationsCache(taglibMap));
    }
}

