/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.ResourceBundleELResolver;
import javax.el.StaticFieldELResolver;
import javax.servlet.jsp.el.ImplicitObjectELResolver;
import javax.servlet.jsp.el.ScopedAttributeELResolver;

public class JasperELResolver
extends CompositeELResolver {
    private static final int STANDARD_RESOLVERS_COUNT = 9;
    private AtomicInteger resolversSize = new AtomicInteger(0);
    private volatile ELResolver[] resolvers;
    private final int appResolversSize;

    public JasperELResolver(List<ELResolver> appResolvers, ELResolver streamResolver) {
        this.appResolversSize = appResolvers.size();
        this.resolvers = new ELResolver[this.appResolversSize + 9];
        this.add((ELResolver)new ImplicitObjectELResolver());
        for (ELResolver appResolver : appResolvers) {
            this.add(appResolver);
        }
        this.add(streamResolver);
        this.add((ELResolver)new StaticFieldELResolver());
        this.add((ELResolver)new MapELResolver());
        this.add((ELResolver)new ResourceBundleELResolver());
        this.add((ELResolver)new ListELResolver());
        this.add((ELResolver)new ArrayELResolver());
        this.add((ELResolver)new BeanELResolver());
        this.add((ELResolver)new ScopedAttributeELResolver());
    }

    public synchronized void add(ELResolver elResolver) {
        super.add(elResolver);
        int size = this.resolversSize.get();
        if (this.resolvers.length > size) {
            this.resolvers[size] = elResolver;
        } else {
            ELResolver[] nr = new ELResolver[size + 1];
            System.arraycopy(this.resolvers, 0, nr, 0, size);
            nr[size] = elResolver;
            this.resolvers = nr;
        }
        this.resolversSize.incrementAndGet();
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        int start;
        int i;
        context.setPropertyResolved(false);
        Object result = null;
        if (base == null) {
            int index = 1 + this.appResolversSize;
            for (i = 0; i < index; ++i) {
                result = this.resolvers[i].getValue(context, base, property);
                if (!context.isPropertyResolved()) continue;
                return result;
            }
            start = index + 7;
        } else {
            start = 1;
        }
        int size = this.resolversSize.get();
        for (i = start; i < size; ++i) {
            result = this.resolvers[i].getValue(context, base, property);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        String targetMethod = JasperELResolver.coerceToString(method);
        if (targetMethod.length() == 0) {
            throw new ELException((Throwable)new NoSuchMethodException());
        }
        context.setPropertyResolved(false);
        Object result = null;
        int index = 1 + this.appResolversSize + 2;
        for (int i = 1; i < index; ++i) {
            result = this.resolvers[i].invoke(context, base, (Object)targetMethod, (Class[])paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        int size = this.resolversSize.get();
        for (int i = index += 4; i < size; ++i) {
            result = this.resolvers[i].invoke(context, base, (Object)targetMethod, (Class[])paramTypes, params);
            if (!context.isPropertyResolved()) continue;
            return result;
        }
        return null;
    }

    private static final String coerceToString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Enum) {
            return ((Enum)obj).name();
        }
        return obj.toString();
    }
}

