/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli.logging;

import java.util.logging.LogManager;
import org.apache.juli.logging.DirectJDKLog;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogConfigurationException;

public class LogFactory {
    private static final LogFactory singleton = new LogFactory();

    private LogFactory() {
    }

    public Log getInstance(String name) throws LogConfigurationException {
        return DirectJDKLog.getInstance(name);
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
        if (!LogManager.getLogManager().getClass().getName().equals("java.util.logging.LogManager")) {
            LogManager.getLogManager().reset();
        }
    }
}

