/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tld;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;

public class TldResourcePath {
    private final URL url;
    private final String entryName;

    public TldResourcePath(URL url) {
        this(url, null);
    }

    public TldResourcePath(URL url, String entryName) {
        this.url = url;
        this.entryName = entryName;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public String toExternalForm() {
        if (this.entryName == null) {
            return this.url.toExternalForm();
        }
        return "jar:" + this.url.toExternalForm() + "!/" + this.entryName;
    }

    public InputStream openStream() throws IOException {
        if (this.entryName == null) {
            return this.url.openStream();
        }
        URL entryUrl = new URL("jar:" + this.url.toExternalForm() + "!/" + this.entryName);
        return entryUrl.openStream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TldResourcePath other = (TldResourcePath)o;
        return this.url.equals(other.url) && Objects.equals(this.entryName, other.entryName);
    }

    public int hashCode() {
        return this.url.hashCode() * 31 + Objects.hashCode(this.entryName);
    }
}

