/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public interface Command {
    public String getCommand();

    public Map<String, String> getOptions();

    public static final class Builder {
        private final String command;
        private final ImmutableMap.Builder<String, String> options = ImmutableMap.builder();

        public static Builder of(String command) {
            Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"Command cannot be null.");
            return new Builder(command);
        }

        public Builder addOption(String key, String value) {
            this.options.put((Object)key, (Object)value);
            return this;
        }

        public Builder addOptions(Map<String, String> map) {
            this.options.putAll(map);
            return this;
        }

        public Command build() {
            return new SimpleCommand(this.command, (Map<String, String>)this.options.build());
        }

        private Builder(String command) {
            this.command = command;
        }

        private static final class SimpleCommand
        implements Command {
            private final String command;
            private final Map<String, String> options;

            SimpleCommand(String command, Map<String, String> options) {
                this.command = command;
                this.options = options;
            }

            @Override
            public String getCommand() {
                return this.command;
            }

            @Override
            public Map<String, String> getOptions() {
                return this.options;
            }

            public int hashCode() {
                return Objects.hashCode((Object[])new Object[]{this.command, this.options});
            }

            public String toString() {
                return Objects.toStringHelper(Command.class).add("command", (Object)this.command).add("options", this.options).toString();
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof Command)) {
                    return false;
                }
                Command other = (Command)obj;
                return this.command.equals(other.getCommand()) && ((Object)this.options).equals(other.getOptions());
            }
        }
    }
}

