/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.api;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.twill.internal.DefaultTwillRunnableSpecification;

public interface TwillRunnableSpecification {
    public String getClassName();

    public String getName();

    public Map<String, String> getConfigs();

    public static final class Builder {
        private String name;
        private Map<String, String> args;

        public static NameSetter with() {
            return new Builder().new NameSetter();
        }

        private Builder() {
        }

        public final class AfterConfigs {
            public TwillRunnableSpecification build() {
                return new DefaultTwillRunnableSpecification(null, Builder.this.name, Builder.this.args);
            }
        }

        public final class AfterName {
            public AfterConfigs withConfigs(Map<String, String> args) {
                Builder.this.args = args;
                return new AfterConfigs();
            }

            public AfterConfigs noConfigs() {
                Builder.this.args = (Map)ImmutableMap.of();
                return new AfterConfigs();
            }
        }

        public final class NameSetter {
            public AfterName setName(String name) {
                Builder.this.name = name;
                return new AfterName();
            }
        }
    }
}

