/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.twill.api.EventHandler;
import org.apache.twill.api.EventHandlerSpecification;
import org.apache.twill.api.Hosts;
import org.apache.twill.api.LocalFile;
import org.apache.twill.api.Racks;
import org.apache.twill.api.ResourceSpecification;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillRunnable;
import org.apache.twill.internal.DefaultLocalFile;
import org.apache.twill.internal.DefaultRuntimeSpecification;
import org.apache.twill.internal.DefaultTwillRunnableSpecification;
import org.apache.twill.internal.DefaultTwillSpecification;

public interface TwillSpecification {
    public String getName();

    public Map<String, RuntimeSpecification> getRunnables();

    public List<Order> getOrders();

    public List<PlacementPolicy> getPlacementPolicies();

    @Nullable
    public EventHandlerSpecification getEventHandler();

    public static final class Builder {
        private String name;
        private Map<String, RuntimeSpecification> runnables = Maps.newHashMap();
        private List<Order> orders = Lists.newArrayList();
        private List<PlacementPolicy> placementPolicies = Lists.newArrayList();
        private EventHandlerSpecification eventHandler;

        public static NameSetter with() {
            return new Builder().new NameSetter();
        }

        private Builder() {
        }

        public final class OrderSetter
        implements FirstOrder,
        NextOrder {
            @Override
            public NextOrder begin(String name, String ... names) {
                this.addOrder(Order.Type.STARTED, name, names);
                return this;
            }

            @Override
            public NextOrder nextWhenStarted(String name, String ... names) {
                this.addOrder(Order.Type.STARTED, name, names);
                return this;
            }

            @Override
            public NextOrder nextWhenCompleted(String name, String ... names) {
                this.addOrder(Order.Type.COMPLETED, name, names);
                return this;
            }

            @Override
            public AfterOrder withEventHandler(EventHandler handler) {
                Builder.this.eventHandler = handler.configure();
                return this;
            }

            @Override
            public TwillSpecification build() {
                HashSet runnableNames = Sets.newHashSet(Builder.this.runnables.keySet());
                for (Order order : Builder.this.orders) {
                    runnableNames.removeAll(order.getNames());
                }
                Builder.this.orders.add(new DefaultTwillSpecification.DefaultOrder(runnableNames, Order.Type.STARTED));
                return new DefaultTwillSpecification(Builder.this.name, Builder.this.runnables, Builder.this.orders, Builder.this.placementPolicies, Builder.this.eventHandler);
            }

            private void addOrder(Order.Type type, String name, String ... names) {
                Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name cannot be null.");
                Preconditions.checkArgument((boolean)Builder.this.runnables.containsKey(name), (Object)"Runnable not exists.");
                HashSet runnableNames = Sets.newHashSet((Object[])new String[]{name});
                for (String runnableName : names) {
                    Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name cannot be null.");
                    Preconditions.checkArgument((boolean)Builder.this.runnables.containsKey(name), (Object)"Runnable not exists.");
                    runnableNames.add(runnableName);
                }
                Builder.this.orders.add(new DefaultTwillSpecification.DefaultOrder(runnableNames, type));
            }
        }

        public static interface AfterOrder {
            public AfterOrder withEventHandler(EventHandler var1);

            public TwillSpecification build();
        }

        public static interface NextOrder
        extends AfterOrder {
            public NextOrder nextWhenStarted(String var1, String ... var2);

            public NextOrder nextWhenCompleted(String var1, String ... var2);
        }

        public static interface FirstOrder {
            public NextOrder begin(String var1, String ... var2);
        }

        public final class PlacementPolicySetter
        implements MorePlacementPolicies,
        AfterPlacementPolicy {
            @Override
            public PlacementPolicySetter add(Hosts hosts, String runnableName, String ... runnableNames) {
                return this.addPlacementPolicy(PlacementPolicy.Type.DEFAULT, hosts, null, runnableName, runnableNames);
            }

            @Override
            public PlacementPolicySetter add(Racks racks, String runnableName, String ... runnableNames) {
                return this.addPlacementPolicy(PlacementPolicy.Type.DEFAULT, null, racks, runnableName, runnableNames);
            }

            @Override
            public PlacementPolicySetter add(Hosts hosts, Racks racks, String runnableName, String ... runnableNames) {
                return this.addPlacementPolicy(PlacementPolicy.Type.DEFAULT, hosts, racks, runnableName, runnableNames);
            }

            @Override
            public PlacementPolicySetter add(PlacementPolicy.Type type, String runnableName, String ... runnableNames) {
                return this.addPlacementPolicy(type, null, null, runnableName, runnableNames);
            }

            private PlacementPolicySetter addPlacementPolicy(PlacementPolicy.Type type, Hosts hosts, Racks racks, String runnableName, String ... runnableNames) {
                Preconditions.checkArgument((runnableName != null ? 1 : 0) != 0, (Object)"Name cannot be null.");
                Preconditions.checkArgument((boolean)Builder.this.runnables.containsKey(runnableName), (Object)"Runnable not exists.");
                Preconditions.checkArgument((!this.contains(runnableName) ? 1 : 0) != 0, (Object)("Runnable (" + runnableName + ") cannot belong to more than one Placement Policy"));
                HashSet runnableNamesSet = Sets.newHashSet((Object[])new String[]{runnableName});
                for (String name : runnableNames) {
                    Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name cannot be null.");
                    Preconditions.checkArgument((boolean)Builder.this.runnables.containsKey(name), (Object)"Runnable not exists.");
                    Preconditions.checkArgument((!this.contains(name) ? 1 : 0) != 0, (Object)("Runnable (" + name + ") cannot belong to more than one Placement Policy"));
                    runnableNamesSet.add(name);
                }
                Builder.this.placementPolicies.add(new DefaultTwillSpecification.DefaultPlacementPolicy(runnableNamesSet, type, hosts, racks));
                return this;
            }

            private boolean contains(String runnableName) {
                for (PlacementPolicy placementPolicy : Builder.this.placementPolicies) {
                    if (!placementPolicy.getNames().contains(runnableName)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public FirstOrder withOrder() {
                return new OrderSetter();
            }

            @Override
            public AfterOrder anyOrder() {
                return new OrderSetter();
            }
        }

        public static interface AfterPlacementPolicy {
            public FirstOrder withOrder();

            public AfterOrder anyOrder();
        }

        public static interface MorePlacementPolicies {
            public PlacementPolicySetter add(Hosts var1, String var2, String ... var3);

            public PlacementPolicySetter add(Racks var1, String var2, String ... var3);

            public PlacementPolicySetter add(Hosts var1, Racks var2, String var3, String ... var4);

            public PlacementPolicySetter add(PlacementPolicy.Type var1, String var2, String ... var3);
        }

        public final class MoreFile
        implements LocalFileAdder {
            private final Function<Collection<LocalFile>, RunnableSetter> completer;
            private final List<LocalFile> files = Lists.newArrayList();

            public MoreFile(Function<Collection<LocalFile>, RunnableSetter> completer) {
                this.completer = completer;
            }

            @Override
            public MoreFile add(String name, File file) {
                return this.add(name, file, false);
            }

            @Override
            public MoreFile add(String name, URI uri) {
                return this.add(name, uri, false);
            }

            @Override
            public MoreFile add(String name, File file, boolean archive) {
                return this.add(name, file.toURI(), archive);
            }

            @Override
            public MoreFile add(String name, URI uri, boolean archive) {
                this.files.add(new DefaultLocalFile(name, uri, -1L, -1L, archive, null));
                return this;
            }

            @Override
            public MoreFile add(String name, File file, String pattern) {
                return this.add(name, file.toURI(), pattern);
            }

            @Override
            public MoreFile add(String name, URI uri, String pattern) {
                this.files.add(new DefaultLocalFile(name, uri, -1L, -1L, true, pattern));
                return this;
            }

            public RunnableSetter apply() {
                return (RunnableSetter)this.completer.apply(this.files);
            }
        }

        public static interface LocalFileAdder {
            public MoreFile add(String var1, File var2);

            public MoreFile add(String var1, URI var2);

            public MoreFile add(String var1, File var2, boolean var3);

            public MoreFile add(String var1, URI var2, boolean var3);

            public MoreFile add(String var1, File var2, String var3);

            public MoreFile add(String var1, URI var2, String var3);
        }

        public final class RuntimeSpecificationAdder {
            private final Function<Collection<LocalFile>, RunnableSetter> completer;

            RuntimeSpecificationAdder(Function<Collection<LocalFile>, RunnableSetter> completer) {
                this.completer = completer;
            }

            public LocalFileAdder withLocalFiles() {
                return new MoreFile(this.completer);
            }

            public RunnableSetter noLocalFiles() {
                return (RunnableSetter)this.completer.apply((Object)ImmutableList.of());
            }
        }

        public final class RunnableSetter
        implements MoreRunnable,
        AfterRunnable {
            @Override
            public RuntimeSpecificationAdder add(TwillRunnable runnable) {
                return this.add(runnable.configure().getName(), runnable);
            }

            @Override
            public RuntimeSpecificationAdder add(TwillRunnable runnable, ResourceSpecification resourceSpec) {
                return this.add(runnable.configure().getName(), runnable, resourceSpec);
            }

            @Override
            public RuntimeSpecificationAdder add(String name, TwillRunnable runnable) {
                return this.add(name, runnable, ResourceSpecification.BASIC);
            }

            @Override
            public RuntimeSpecificationAdder add(String name, TwillRunnable runnable, final ResourceSpecification resourceSpec) {
                final DefaultTwillRunnableSpecification spec = new DefaultTwillRunnableSpecification(runnable.getClass().getName(), name, runnable.configure().getConfigs());
                return new RuntimeSpecificationAdder(new Function<Collection<LocalFile>, RunnableSetter>(){

                    public RunnableSetter apply(Collection<LocalFile> files) {
                        Builder.this.runnables.put(spec.getName(), new DefaultRuntimeSpecification(spec.getName(), spec, resourceSpec, files));
                        return RunnableSetter.this;
                    }
                });
            }

            @Override
            public FirstOrder withOrder() {
                return new OrderSetter();
            }

            @Override
            public AfterOrder anyOrder() {
                return new OrderSetter();
            }

            @Override
            public PlacementPolicySetter withPlacementPolicy() {
                return new PlacementPolicySetter();
            }
        }

        public static interface AfterRunnable {
            public FirstOrder withOrder();

            public AfterOrder anyOrder();

            public PlacementPolicySetter withPlacementPolicy();
        }

        public static interface MoreRunnable {
            public RuntimeSpecificationAdder add(TwillRunnable var1);

            public RuntimeSpecificationAdder add(TwillRunnable var1, ResourceSpecification var2);

            public RuntimeSpecificationAdder add(String var1, TwillRunnable var2);

            public RuntimeSpecificationAdder add(String var1, TwillRunnable var2, ResourceSpecification var3);
        }

        public final class AfterName {
            public MoreRunnable withRunnable() {
                return new RunnableSetter();
            }
        }

        public final class NameSetter {
            public AfterName setName(String name) {
                Builder.this.name = name;
                return new AfterName();
            }
        }
    }

    public static interface PlacementPolicy {
        public Set<String> getNames();

        public Type getType();

        public Set<String> getHosts();

        public Set<String> getRacks();

        public static enum Type {
            DISTRIBUTED,
            DEFAULT;

        }
    }

    public static interface Order {
        public Set<String> getNames();

        public Type getType();

        public static enum Type {
            STARTED,
            COMPLETED;

        }
    }
}

