/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.twill.api.EventHandler;
import org.apache.twill.api.EventHandlerSpecification;

public class DefaultEventHandlerSpecification
implements EventHandlerSpecification {
    private final String className;
    private final Map<String, String> configs;

    public DefaultEventHandlerSpecification(String className, Map<String, String> configs) {
        this.className = className;
        this.configs = configs;
    }

    public DefaultEventHandlerSpecification(EventHandler eventHandler) {
        EventHandlerSpecification spec = eventHandler.configure();
        this.className = eventHandler.getClass().getName();
        this.configs = ImmutableMap.copyOf(spec.getConfigs());
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Map<String, String> getConfigs() {
        return this.configs;
    }
}

