/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.twill.api.EventHandlerSpecification;
import org.apache.twill.api.Hosts;
import org.apache.twill.api.Racks;
import org.apache.twill.api.RuntimeSpecification;
import org.apache.twill.api.TwillSpecification;

public final class DefaultTwillSpecification
implements TwillSpecification {
    private final String name;
    private final Map<String, RuntimeSpecification> runnables;
    private final List<TwillSpecification.Order> orders;
    private final List<TwillSpecification.PlacementPolicy> placementPolicies;
    private final EventHandlerSpecification eventHandler;

    public DefaultTwillSpecification(String name, Map<String, RuntimeSpecification> runnables, List<TwillSpecification.Order> orders, List<TwillSpecification.PlacementPolicy> placementPolicies, EventHandlerSpecification eventHandler) {
        this.name = name;
        this.runnables = ImmutableMap.copyOf(runnables);
        this.orders = ImmutableList.copyOf(orders);
        this.placementPolicies = placementPolicies;
        this.eventHandler = eventHandler;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, RuntimeSpecification> getRunnables() {
        return this.runnables;
    }

    @Override
    public List<TwillSpecification.Order> getOrders() {
        return this.orders;
    }

    @Override
    public List<TwillSpecification.PlacementPolicy> getPlacementPolicies() {
        return this.placementPolicies;
    }

    @Override
    @Nullable
    public EventHandlerSpecification getEventHandler() {
        return this.eventHandler;
    }

    public static final class DefaultPlacementPolicy
    implements TwillSpecification.PlacementPolicy {
        private final Set<String> names;
        private final TwillSpecification.PlacementPolicy.Type type;
        private final Hosts hosts;
        private final Racks racks;

        public DefaultPlacementPolicy(Iterable<String> names, TwillSpecification.PlacementPolicy.Type type, Hosts hosts, Racks racks) {
            this.names = ImmutableSet.copyOf(names);
            this.type = type;
            this.hosts = hosts;
            this.racks = racks;
        }

        public DefaultPlacementPolicy(Iterable<String> names, TwillSpecification.PlacementPolicy.Type type) {
            this(names, type, null, null);
        }

        @Override
        public Set<String> getNames() {
            return this.names;
        }

        @Override
        public TwillSpecification.PlacementPolicy.Type getType() {
            return this.type;
        }

        @Override
        public Set<String> getHosts() {
            if (this.hosts == null) {
                return Collections.emptySet();
            }
            return this.hosts.get();
        }

        @Override
        public Set<String> getRacks() {
            if (this.racks == null) {
                return Collections.emptySet();
            }
            return this.racks.get();
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("names", this.names).add("type", (Object)this.type).add("hosts", (Object)this.hosts).add("racks", (Object)this.racks).toString();
        }
    }

    public static final class DefaultOrder
    implements TwillSpecification.Order {
        private final Set<String> names;
        private final TwillSpecification.Order.Type type;

        public DefaultOrder(Iterable<String> names, TwillSpecification.Order.Type type) {
            this.names = ImmutableSet.copyOf(names);
            this.type = type;
        }

        @Override
        public Set<String> getNames() {
            return this.names;
        }

        @Override
        public TwillSpecification.Order.Type getType() {
            return this.type;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("names", this.names).add("type", (Object)this.type).toString();
        }
    }
}

