/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.uima.ducc.common.jd.files.WorkItemStateManager;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;

public class CacheManager {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)CacheManager.class.getName());
    private static CacheManager instance = new CacheManager();
    private volatile HashMap<String, WorkItemStateManager> wisMap = null;
    private AtomicBoolean inProgress = new AtomicBoolean(false);

    public static CacheManager getInstance() {
        return instance;
    }

    public void update(DuccWorkMap map) {
        String location = "update";
        DuccId jobid2 = null;
        if (this.inProgress.compareAndSet(false, true)) {
            try {
                HashMap<String, WorkItemStateManager> updatedWisMap = new HashMap<String, WorkItemStateManager>();
                for (DuccId jobid2 : map.keySet()) {
                    IDuccWork duccWork = map.findDuccWork(jobid2);
                    switch (duccWork.getDuccType()) {
                        case Job: {
                            IDuccWorkJob job = (IDuccWorkJob)duccWork;
                            String jobNo = job.getId();
                            String userId = job.getStandardInfo().getUser();
                            String jobDir = job.getLogDirectory() + jobNo;
                            WorkItemStateManager workItemStateManager = new WorkItemStateManager(jobDir);
                            workItemStateManager.importData(userId);
                            updatedWisMap.put(jobNo, workItemStateManager);
                        }
                    }
                }
                this.wisMap = updatedWisMap;
                logger.debug(location, jobid2, new Object[]{"size:" + this.wisMap.size()});
            }
            catch (Exception e) {
                logger.error(location, jobid2, (Throwable)e, new Object[0]);
            }
        } else {
            logger.warn(location, jobid2, new Object[]{"skipping: already in progress..."});
        }
        this.inProgress.set(false);
    }

    public WorkItemStateManager getWorkItemStateManager(String jobNo) {
        WorkItemStateManager retVal = this.wisMap.get(jobNo);
        return retVal;
    }
}

