/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.config;

import java.io.Serializable;
import javax.jms.ObjectMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.util.ByteSequence;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsMessage;
import org.apache.camel.model.RouteDefinition;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.ws.DuccBoot;
import org.apache.uima.ducc.ws.WebServerComponent;
import org.apache.uima.ducc.ws.event.WebServerEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class WebServerConfiguration {
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration webServerTransport;
    private DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)WebServerConfiguration.class.getName());
    private DuccId jobid = null;

    public WebServerEventListener webServerDelegateListener(WebServerComponent ws) {
        WebServerEventListener wsel = new WebServerEventListener(ws);
        return wsel;
    }

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String endpoint, final WebServerEventListener delegate) {
        return new RouteBuilder(){
            Processor p;
            {
                this.p = new AccessJmsBody();
            }

            public void configure() {
                ((RouteDefinition)this.from(endpoint).process(this.p)).bean((Object)delegate);
            }
        };
    }

    @Bean
    public WebServerComponent webServer() throws Exception {
        String methodName = "webServer";
        WebServerComponent ws = null;
        try {
            ws = new WebServerComponent(this.common.camelContext(), this.common);
            DuccBoot.boot(this.common);
            WebServerEventListener delegateListener = this.webServerDelegateListener(ws);
            delegateListener.setDuccEventDispatcher(this.webServerTransport.duccEventDispatcher(this.common.orchestratorStateUpdateEndpoint, ws.getContext()));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.orchestratorStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.nodeMetricsEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.rmStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.smStateUpdateEndpoint, delegateListener));
            ws.getContext().addRoutes((RoutesBuilder)this.routeBuilderForIncomingRequests(this.common.pmStateUpdateEndpoint, delegateListener));
        }
        catch (Throwable t) {
            this.duccLogger.error(methodName, this.jobid, t, new Object[0]);
        }
        return ws;
    }

    public class AccessJmsBody
    implements Processor {
        int msglen = 0;
        String objectName = "unknown";

        public void process(Exchange exchange) throws Exception {
            String location = "AccessJmsBody:process";
            try {
                ActiveMQMessage amqMessage;
                JmsMessage msg;
                Message o = exchange.getIn();
                if (o instanceof JmsMessage && (o = (msg = (JmsMessage)o).getJmsMessage()) instanceof ActiveMQMessage && (amqMessage = (ActiveMQMessage)o) instanceof ObjectMessage) {
                    Serializable body = ((ObjectMessage)amqMessage).getObject();
                    ByteSequence bs = amqMessage.getContent();
                    this.msglen = bs.getLength();
                    this.objectName = body.getClass().getName();
                }
                Long pubSize = new Long(this.msglen);
                exchange.getIn().setHeader("pubSize", (Object)pubSize);
                String text = "Message length is " + this.msglen + " for " + this.objectName;
                WebServerConfiguration.this.duccLogger.debug(location, WebServerConfiguration.this.jobid, new Object[]{text});
            }
            catch (Throwable t) {
                WebServerConfiguration.this.duccLogger.error(location, WebServerConfiguration.this.jobid, t, new Object[0]);
            }
        }
    }
}

