/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.util.Properties;

public class DuccHandlerUtils {
    private static String stateAvailable = "Available";
    private static String valueTrue = "True";
    private static String valueFalse = "False";
    private static String valueUp = "Up";
    private static String valueDown = "Down";
    private static String valueGood = "Good";
    private static String valuePoor = "Poor";
    private static String valueError = "Error";
    private static String health_green = "health_green";
    private static String health_red = "health_red";

    public static String getUninterpreted(Properties propertiesMeta, String key) {
        String value;
        String retVal = "";
        if (propertiesMeta != null && key != null && propertiesMeta.containsKey(key) && (value = propertiesMeta.getProperty(key)) != null) {
            retVal = value.trim();
        }
        return retVal;
    }

    public static String getInterpreted(String state, Properties propertiesMeta, String key, String xform4True, String xform4False) {
        String retVal = "";
        if (state != null && state.equals(stateAvailable)) {
            String value = DuccHandlerUtils.getUninterpreted(propertiesMeta, key);
            retVal = (value = value.trim()).equalsIgnoreCase(valueTrue) ? xform4True : (value.equalsIgnoreCase(valueFalse) ? xform4False : value);
        }
        return retVal;
    }

    public static String getInterpretedUpDown(String state, Properties propertiesMeta, String key) {
        return DuccHandlerUtils.getInterpreted(state, propertiesMeta, key, valueUp, valueDown);
    }

    public static String getInterpretedGoodPoor(String state, Properties propertiesMeta, String key) {
        return DuccHandlerUtils.getInterpreted(state, propertiesMeta, key, valueGood, valuePoor);
    }

    private static String openSpan(String spanClass, String spanTitle) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append("span");
        if (spanClass != null) {
            sb.append(" ");
            sb.append("class=");
            sb.append("\"");
            sb.append(spanClass);
            sb.append("\"");
        }
        if (spanTitle != null) {
            sb.append(" ");
            sb.append("title=");
            sb.append("\"");
            sb.append(spanTitle);
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    private static String closeSpan() {
        return "</span>";
    }

    public static String getDecorated(String value) {
        return DuccHandlerUtils.getDecorated(value, null);
    }

    public static String getDecorated(String value, String popup) {
        String retVal = "";
        if (value != null) {
            String tValue = value.trim();
            String tPopup = popup;
            if (tPopup != null) {
                tPopup = popup.replace("\"", "&quot;");
            }
            if (tValue.equalsIgnoreCase(valueDown)) {
                StringBuffer sb = new StringBuffer();
                sb.append(DuccHandlerUtils.openSpan(health_red, tPopup));
                sb.append(tValue);
                sb.append(DuccHandlerUtils.closeSpan());
                retVal = sb.toString();
            } else if (tValue.equalsIgnoreCase(valueUp)) {
                StringBuffer sb = new StringBuffer();
                sb.append(DuccHandlerUtils.openSpan(health_green, tPopup));
                sb.append(tValue);
                sb.append(DuccHandlerUtils.closeSpan());
                retVal = sb.toString();
            } else if (tValue.equalsIgnoreCase(valuePoor)) {
                StringBuffer sb = new StringBuffer();
                sb.append(DuccHandlerUtils.openSpan(health_red, tPopup));
                sb.append(tValue);
                sb.append(DuccHandlerUtils.closeSpan());
                retVal = sb.toString();
            } else if (tValue.equalsIgnoreCase(valueGood)) {
                StringBuffer sb = new StringBuffer();
                sb.append(DuccHandlerUtils.openSpan(health_green, tPopup));
                sb.append(tValue);
                sb.append(DuccHandlerUtils.closeSpan());
                retVal = sb.toString();
            } else if (tValue.equalsIgnoreCase(valueError)) {
                StringBuffer sb = new StringBuffer();
                sb.append(DuccHandlerUtils.openSpan(health_red, tPopup));
                sb.append(tValue);
                sb.append(DuccHandlerUtils.closeSpan());
                retVal = sb.toString();
            } else {
                retVal = value;
            }
        }
        return retVal;
    }

    public static String warn(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_red\">");
        sb.append(text);
        sb.append("</span>");
        return sb.toString();
    }

    public static String down() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_red\">");
        sb.append("down");
        sb.append("</span>");
        return sb.toString();
    }

    public static String up() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_green\">");
        sb.append("up");
        sb.append("</span>");
        return sb.toString();
    }

    public static String up_provisional(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("up" + text);
        sb.append("</span>");
        return sb.toString();
    }

    public static String unknown() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("unknown");
        sb.append("</span>");
        return sb.toString();
    }
}

