/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.ducc.common.json.MonitorInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.authentication.DuccWebAdministrators;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.ws.IListenerOrchestrator;
import org.apache.uima.ducc.ws.server.DuccListeners;
import org.apache.uima.ducc.ws.server.DuccWebMonitorJob;
import org.apache.uima.ducc.ws.server.DuccWebMonitorManagedReservation;
import org.apache.uima.ducc.ws.server.DuccWebProperties;
import org.apache.uima.ducc.ws.server.IWebMonitor;

public class DuccWebMonitor
implements IListenerOrchestrator,
IWebMonitor {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)DuccWebMonitor.class.getName());
    private static DuccId jobid = null;
    public static DuccWebMonitor instance = new DuccWebMonitor();
    public String key_automatic_cancel_minutes = "ducc.ws.automatic.cancel.minutes";
    public String key_node = "ducc.ws.node";
    public String key_head = "ducc.head";
    public String key_port = "ducc.ws.port";
    private Properties properties = new Properties();
    private AtomicInteger updateCounter = new AtomicInteger(0);
    private AtomicBoolean operational = new AtomicBoolean(true);
    private AtomicBoolean statusMessageIssued = new AtomicBoolean(false);
    private String monitor_host = null;
    private String monitor_port = null;
    private String actual_host = null;
    private String actual_port = null;
    private long millisPerMinute = 60000L;
    private long timeoutMinutes = 10L;
    private long timeoutMillis = this.timeoutMinutes * this.millisPerMinute;
    private DuccWebMonitorJob duccWebMonitorJob = null;
    private DuccWebMonitorManagedReservation duccWebMonitorManagedReservation = null;

    public static DuccWebMonitor getInstance() {
        return instance;
    }

    public DuccWebMonitor() {
        this.initialize();
    }

    private void initialize() {
        String location = "initialize";
        this.properties = DuccWebProperties.get();
        String key = this.key_automatic_cancel_minutes;
        if (this.properties.containsKey(key)) {
            String value = this.properties.getProperty(key);
            try {
                this.timeoutMinutes = Long.parseLong(value);
                this.timeoutMillis = this.timeoutMinutes * this.millisPerMinute;
                duccLogger.info(location, jobid, new Object[]{"timeout minutes: " + this.timeoutMinutes});
            }
            catch (Exception e) {
                duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
            }
        } else {
            duccLogger.warn(location, jobid, new Object[]{"not found: " + key});
            duccLogger.info(location, jobid, new Object[]{"timeout minutes (default): " + this.timeoutMinutes});
        }
        String me = System.getProperty("user.name");
        if (!DuccWebAdministrators.getInstance().isAdministrator(me)) {
            duccLogger.warn(location, jobid, new Object[]{me + " is not an administrator"});
        }
        DuccListeners.getInstance().register(this);
        this.monitor_host = this.properties.getProperty(this.key_node);
        if (this.monitor_host == null) {
            this.monitor_host = this.properties.getProperty(this.key_head);
        }
        this.monitor_port = this.properties.getProperty(this.key_port);
        this.duccWebMonitorJob = new DuccWebMonitorJob(this.timeoutMillis);
        this.duccWebMonitorManagedReservation = new DuccWebMonitorManagedReservation(this.timeoutMillis);
    }

    @Override
    public void update(OrchestratorStateDuccEvent duccEvent) {
        String location = "update";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        if (this.operational.get()) {
            this.updateCounter.incrementAndGet();
            this.monitor(duccEvent);
        } else if (!this.statusMessageIssued.getAndSet(true)) {
            duccLogger.info(location, jobid, new Object[]{"auto-cancel monitor disabled"});
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    private void monitor(OrchestratorStateDuccEvent duccEvent) {
        String location = "monitor";
        duccLogger.trace(location, jobid, new Object[]{"enter"});
        this.duccWebMonitorJob.monitor(duccEvent);
        this.duccWebMonitorManagedReservation.monitor(duccEvent);
        if (this.isAutoCancelEnabled()) {
            long nowMillis = System.currentTimeMillis();
            this.duccWebMonitorJob.canceler(nowMillis);
            this.duccWebMonitorManagedReservation.canceler(nowMillis);
        } else {
            duccLogger.debug(location, jobid, new Object[]{"auto-cancel monitor disabled"});
        }
        duccLogger.trace(location, jobid, new Object[]{"exit"});
    }

    @Override
    public void register(String host, String port) {
        String location = "register";
        this.actual_host = host;
        this.actual_port = port;
        if (this.isAutoCancelEnabled()) {
            duccLogger.info(location, jobid, new Object[]{host + ":" + port + " is cancel monitor " + this.monitor_host + ":" + this.monitor_port});
        } else {
            duccLogger.warn(location, jobid, new Object[]{host + ":" + port + " is *not* cancel monitor " + this.monitor_host + ":" + this.monitor_port});
        }
    }

    @Override
    public boolean isAutoCancelEnabled() {
        String monitor_domainless_host;
        String actual_domainless_host;
        if (this.actual_host == null) {
            return false;
        }
        if (this.monitor_host == null) {
            return false;
        }
        if (!this.actual_host.equals(this.monitor_host) && !(actual_domainless_host = this.actual_host.split("\\.")[0]).equals(monitor_domainless_host = this.monitor_host.split("\\.")[0])) {
            return false;
        }
        if (this.actual_port == null) {
            return false;
        }
        if (this.monitor_port == null) {
            return false;
        }
        return this.actual_port.equals(this.monitor_port);
    }

    @Override
    public MonitorInfo renew(IDuccTypes.DuccType duccType, String id) {
        MonitorInfo monitorInfo = new MonitorInfo();
        if (duccType != null && id != null) {
            switch (duccType) {
                case Job: {
                    monitorInfo = this.duccWebMonitorJob.renew(id, this.updateCounter);
                    break;
                }
                case Reservation: {
                    monitorInfo = this.duccWebMonitorManagedReservation.renew(id, this.updateCounter);
                    break;
                }
                case Service: {
                    break;
                }
            }
        }
        return monitorInfo;
    }

    @Override
    public Long getExpiry(IDuccTypes.DuccType duccType, DuccId duccId) {
        Long expiry = null;
        if (duccType != null && duccId != null) {
            switch (duccType) {
                case Job: {
                    expiry = this.duccWebMonitorJob.getExpiry(duccId);
                    break;
                }
                case Reservation: {
                    expiry = this.duccWebMonitorManagedReservation.getExpiry(duccId);
                    break;
                }
                case Service: {
                    break;
                }
            }
        }
        return expiry;
    }

    @Override
    public boolean isCanceled(IDuccTypes.DuccType duccType, DuccId duccId) {
        boolean flag = false;
        if (duccType != null && duccId != null) {
            switch (duccType) {
                case Job: {
                    flag = this.duccWebMonitorJob.isCanceled(duccId);
                    break;
                }
                case Reservation: {
                    flag = this.duccWebMonitorManagedReservation.isCanceled(duccId);
                    break;
                }
                case Service: {
                    break;
                }
            }
        }
        return flag;
    }

    @Override
    public ConcurrentHashMap<DuccId, Long> getExpiryMap(IDuccTypes.DuccType duccType) {
        ConcurrentHashMap<DuccId, Long> eMap = new ConcurrentHashMap<DuccId, Long>();
        if (duccType != null) {
            switch (duccType) {
                case Job: {
                    eMap = this.duccWebMonitorJob.getExpiryMap();
                    break;
                }
                case Reservation: {
                    eMap = this.duccWebMonitorManagedReservation.getExpiryMap();
                    break;
                }
                case Service: {
                    break;
                }
            }
        }
        return eMap;
    }
}

