/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.uima.ducc.common.persistence.services.StateServicesSet;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.ws.registry.ServicesRegistryMapPayload;
import org.apache.uima.ducc.ws.server.DuccCookies;

public class DuccWebUtil {
    private static String key_user = "user";
    private static String key_state = "service-state";
    private static String value_NotAvailable = "NotAvailable";

    public static final void noCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setDateHeader("Expires", 0L);
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, IDuccWork dw) {
        boolean list = false;
        DuccCookies.FilterUsersStyle filterUsersStyle = DuccCookies.getFilterUsersStyle(request);
        if (!users.isEmpty()) {
            String jobUser = dw.getStandardInfo().getUser().trim();
            switch (filterUsersStyle) {
                case IncludePlusActive: {
                    if (!dw.isCompleted()) {
                        list = true;
                        break;
                    }
                    if (!users.contains(jobUser) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                    break;
                }
                case ExcludePlusActive: {
                    if (!dw.isCompleted()) {
                        list = true;
                        break;
                    }
                    if (users.contains(jobUser) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                    break;
                }
                case Include: {
                    if (!users.contains(jobUser) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                    break;
                }
                case Exclude: {
                    if (users.contains(jobUser) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                }
            }
        } else if (!dw.isCompleted()) {
            list = true;
        } else if (maxRecords > 0 && counter < maxRecords) {
            list = true;
        }
        return list;
    }

    public static boolean isAvailable(Properties propertiesMeta) {
        boolean retVal = true;
        try {
            String state = propertiesMeta.getProperty(key_state).trim();
            if (state.equalsIgnoreCase(value_NotAvailable)) {
                retVal = false;
            }
        }
        catch (Exception e) {
            retVal = false;
        }
        return retVal;
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, ServicesRegistryMapPayload entry) {
        Properties propertiesMeta = entry.get("meta");
        return DuccWebUtil.isListable(request, users, maxRecords, counter, propertiesMeta);
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, StateServicesSet entry) {
        Properties propertiesMeta = entry.get("meta");
        return DuccWebUtil.isListable(request, users, maxRecords, counter, propertiesMeta);
    }

    public static final boolean isListable(HttpServletRequest request, ArrayList<String> users, int maxRecords, int counter, Properties propertiesMeta) {
        boolean list = false;
        DuccCookies.FilterUsersStyle filterUsersStyle = DuccCookies.getFilterUsersStyle(request);
        if (!users.isEmpty()) {
            String user = propertiesMeta.getProperty(key_user).trim();
            switch (filterUsersStyle) {
                case IncludePlusActive: {
                    if (DuccWebUtil.isAvailable(propertiesMeta)) {
                        list = true;
                        break;
                    }
                    if (!users.contains(user) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                    break;
                }
                case ExcludePlusActive: {
                    if (DuccWebUtil.isAvailable(propertiesMeta)) {
                        list = true;
                        break;
                    }
                    if (users.contains(user) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                    break;
                }
                case Include: {
                    if (!users.contains(user) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                    break;
                }
                case Exclude: {
                    if (users.contains(user) || maxRecords <= 0 || counter >= maxRecords) break;
                    list = true;
                }
            }
        } else if (DuccWebUtil.isAvailable(propertiesMeta)) {
            list = true;
        } else if (maxRecords > 0 && counter < maxRecords) {
            list = true;
        }
        return list;
    }
}

