/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.uima.ducc.common.jd.files.IWorkItemState;
import org.apache.uima.ducc.common.jd.files.WorkItemStateManager;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.ws.CacheManager;

public class WorkItemStateHelper {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger((String)WorkItemStateHelper.class.getName());
    private WorkItemStateManager workItemStateManager = null;

    public WorkItemStateHelper(IDuccWorkJob job) throws IOException, ClassNotFoundException {
        String jobNo = job.getId();
        String userId = job.getStandardInfo().getUser();
        String jobDir = job.getLogDirectory() + jobNo;
        this.workItemStateManager = CacheManager.getInstance().getWorkItemStateManager(jobNo);
        if (this.workItemStateManager == null) {
            this.workItemStateManager = new WorkItemStateManager(jobDir);
            this.workItemStateManager.importData(userId);
        }
    }

    public double getLeastOperatingMillis(IDuccWorkJob job) {
        String methodName = "getLeastOperatingMillis";
        double retVal = 0.0;
        ConcurrentSkipListMap map = this.workItemStateManager.getMap();
        if (map != null && map.size() != 0) {
            double smallest = 0.0;
            new ConcurrentSkipListMap();
            for (Map.Entry entry : map.entrySet()) {
                IWorkItemState wis = (IWorkItemState)entry.getValue();
                IWorkItemState.State state = wis.getState();
                switch (state) {
                    case operating: {
                        double time = wis.getMillisProcessing();
                        if (smallest == 0.0) {
                            smallest = time;
                            duccLogger.trace(methodName, job.getDuccId(), new Object[]{wis.getWiId() + " " + time + " " + time / 1000.0});
                            break;
                        }
                        if (!(time < smallest)) break;
                        smallest = time;
                        duccLogger.trace(methodName, job.getDuccId(), new Object[]{wis.getWiId() + " " + time + " " + time / 1000.0});
                    }
                }
            }
            retVal = smallest;
        }
        return retVal;
    }

    public double getMostCompletedMillis(IDuccWorkJob job) {
        String methodName = "getMostCompletedMillis";
        double retVal = 0.0;
        ConcurrentSkipListMap map = this.workItemStateManager.getMap();
        if (map != null && map.size() != 0) {
            double biggest = 0.0;
            new ConcurrentSkipListMap();
            for (Map.Entry entry : map.entrySet()) {
                IWorkItemState wis = (IWorkItemState)entry.getValue();
                IWorkItemState.State state = wis.getState();
                switch (state) {
                    case ended: {
                        double time = wis.getMillisProcessing();
                        if (biggest == 0.0) {
                            biggest = time;
                            duccLogger.trace(methodName, job.getDuccId(), new Object[]{wis.getWiId() + " " + time + " " + time / 1000.0});
                            break;
                        }
                        if (!(time > biggest)) break;
                        biggest = time;
                        duccLogger.trace(methodName, job.getDuccId(), new Object[]{wis.getWiId() + " " + time + " " + time / 1000.0});
                    }
                }
            }
            retVal = biggest;
        }
        return retVal;
    }
}

