/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.ProcessInfo;
import org.apache.uima.ducc.ws.types.NodeId;

public class MachineInfo
implements Comparable<MachineInfo> {
    private static DuccLogger logger = DuccLoggerComponents.getWsLogger((String)MachineInfo.class.getName());
    private static DuccId jobid = null;
    private String fileDef;
    private String ip;
    private String name;
    private String memTotal;
    private String memFree;
    private String swapInuse;
    private String swapFree;
    private double cpu;
    private boolean cGroups;
    private List<ProcessInfo> alienPids;
    private long swapDelta;
    private long heartbeat;
    private long heartbeatMax;
    private long heartbeatMaxTOD;
    private long pubSize;
    private long pubSizeMax;
    private MachineStatus machineStatus = MachineStatus.Defined;
    private Boolean responsive = null;
    private Boolean online = null;
    private Boolean blacklisted = null;
    private Integer quantum = null;
    private NodeId nodeid;

    public MachineInfo(String fileDef, String ip, String name, String memTotal, String memFree, String swapInuse, String swapFree, double cpu, boolean cGroups, List<ProcessInfo> alienPids, long heartbeat, long pubSize) {
        this.init(MachineStatus.Defined, fileDef, ip, name, memTotal, memFree, swapInuse, swapFree, cpu, cGroups, alienPids, heartbeat, pubSize);
    }

    public MachineInfo(MachineStatus machineStatus, String fileDef, String ip, String name, String memTotal, String memFree, String swapInuse, String swapFree, double cpu, boolean cGroups, List<ProcessInfo> alienPids, long heartbeat, long pubSize) {
        this.init(machineStatus, fileDef, ip, name, memTotal, memFree, swapInuse, swapFree, cpu, cGroups, alienPids, heartbeat, pubSize);
    }

    private void init(MachineStatus machineStatus, String fileDef, String ip, String name, String memTotal, String memFree, String swapInuse, String swapFree, double cpu, boolean cGroups, List<ProcessInfo> alienPids, long heartbeat, long pubSize) {
        this.machineStatus = machineStatus;
        this.fileDef = fileDef;
        this.ip = ip;
        this.name = name;
        this.memTotal = memTotal;
        this.memFree = memFree;
        this.swapInuse = swapInuse;
        this.swapFree = swapFree;
        this.cpu = cpu;
        this.cGroups = cGroups;
        this.alienPids = alienPids;
        if (this.alienPids == null) {
            this.alienPids = new ArrayList<ProcessInfo>();
        }
        this.swapDelta = 0L;
        this.heartbeat = heartbeat;
        this.heartbeatMax = 0L;
        this.heartbeatMaxTOD = 0L;
        this.pubSize = pubSize;
        this.pubSizeMax = 0L;
        this.nodeid = new NodeId(name);
    }

    public String getStatus() {
        return this.machineStatus.getLowerCaseName();
    }

    public MachineStatus getMachineStatus() {
        return this.machineStatus;
    }

    public void setMachineStatus(MachineStatus machineStatus) {
        this.machineStatus = machineStatus;
    }

    public String getMachineStatusReason() {
        String retVal = "";
        StringBuffer sb = new StringBuffer();
        sb.append(this.getResponsive());
        sb.append(" ");
        sb.append(this.getOnline());
        sb.append(" ");
        sb.append(this.getBlacklisted());
        sb.append(" ");
        retVal = sb.toString().trim();
        return retVal;
    }

    public void setResponsive(boolean value) {
        if (value) {
            this.setResponsive();
        } else {
            this.setNotResponsive();
        }
    }

    public void setResponsive() {
        this.responsive = new Boolean(true);
    }

    public void setNotResponsive() {
        this.responsive = new Boolean(false);
    }

    public String getResponsive() {
        String retVal = "";
        if (this.responsive != null) {
            retVal = this.responsive != false ? "responsive=true" : "responsive=false";
        }
        return retVal;
    }

    public void setOnline(boolean value) {
        if (value) {
            this.setOnline();
        } else {
            this.setNotOnline();
        }
    }

    public void setOnline() {
        this.online = new Boolean(true);
    }

    public void setNotOnline() {
        this.online = new Boolean(false);
    }

    public String getOnline() {
        String retVal = "";
        if (this.online != null) {
            retVal = this.online != false ? "online=true" : "online=false";
        }
        return retVal;
    }

    public void setBlacklisted(boolean value) {
        if (value) {
            this.setBlacklisted();
        } else {
            this.setNotBlacklisted();
        }
    }

    public void setBlacklisted() {
        this.blacklisted = new Boolean(true);
    }

    public void setNotBlacklisted() {
        this.blacklisted = new Boolean(false);
    }

    public String getBlacklisted() {
        String retVal = "";
        if (this.blacklisted != null) {
            retVal = this.blacklisted != false ? "blacklisted=true" : "blacklisted=false";
        }
        return retVal;
    }

    public void setQuantum(Integer quantum) {
        this.quantum = quantum;
    }

    public Integer getQuantum() {
        return this.quantum;
    }

    public String getFileDef() {
        return this.fileDef;
    }

    public String getIp() {
        return this.ip;
    }

    public String getName() {
        return this.name;
    }

    public void setMemTotal(String value) {
        this.memTotal = value;
    }

    public String getMemTotal() {
        return this.memTotal;
    }

    public void setMemFree(String value) {
        this.memFree = value;
    }

    public String getMemFree() {
        return this.memFree;
    }

    public String getSwapInuse() {
        return this.swapInuse;
    }

    public String getSwapFree() {
        return this.swapFree;
    }

    public double getCpu() {
        return this.cpu;
    }

    public boolean getCgroups() {
        return this.cGroups;
    }

    public List<String> getAliens() {
        ArrayList<String> list = new ArrayList<String>();
        for (ProcessInfo processInfo : this.alienPids) {
            String uid = processInfo.getUid();
            String pid = processInfo.getPid();
            String alien = uid + ":" + pid;
            list.add(alien);
        }
        return list;
    }

    public List<ProcessInfo> getAlienPids() {
        return this.alienPids;
    }

    public List<String> getAliensPidsOnly() {
        ArrayList<String> list = new ArrayList<String>();
        for (ProcessInfo processInfo : this.alienPids) {
            list.add(processInfo.getPid());
        }
        return list;
    }

    public long getAlienPidsCount() {
        long retVal = 0L;
        if (this.alienPids != null) {
            retVal = this.alienPids.size();
        }
        return retVal;
    }

    public long getSwapDelta() {
        return this.swapDelta;
    }

    public void setSwapDelta(long value) {
        this.swapDelta = value;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public long getHeartbeatMax() {
        return this.heartbeatMax;
    }

    public void setHeartbeatMax(long value) {
        this.heartbeatMax = value;
    }

    public long getHeartbeatMaxTOD() {
        return this.heartbeatMaxTOD;
    }

    public void setHeartbeatMaxTOD(long value) {
        this.heartbeatMaxTOD = value;
    }

    public long getPubSizeMax() {
        return this.pubSizeMax;
    }

    public void setPubSizeMax(long value) {
        this.pubSizeMax = value;
    }

    public boolean isExpired(long millisLimit) {
        String location = "isExpired";
        long millisElapsed = this.getElapsedSeconds() * 1000L;
        logger.trace(location, jobid, new Object[]{"millisElapsed:" + millisElapsed + " " + "millisLimit:" + millisLimit});
        return millisElapsed > millisLimit;
    }

    public long getElapsedSeconds() {
        long retVal = -1L;
        if (this.heartbeat >= 0L) {
            retVal = (System.currentTimeMillis() - this.heartbeat) / 1000L;
        }
        return retVal;
    }

    public String getElapsed() {
        String retVal = "";
        long elapsedSeconds = this.getElapsedSeconds();
        if (elapsedSeconds >= 0L) {
            retVal = "" + elapsedSeconds;
        }
        return retVal;
    }

    public long getPubSize() {
        return this.pubSize;
    }

    public String getPublicationSizeLast() {
        String retVal = "";
        if (this.pubSize > 0L) {
            retVal = retVal + this.pubSize;
        }
        return retVal;
    }

    public String getPublicationSizeMax() {
        String retVal = "";
        if (this.pubSizeMax > 0L) {
            retVal = retVal + this.pubSizeMax;
        }
        return retVal;
    }

    public String getHeartbeatLast() {
        String retVal = this.getElapsed();
        return retVal;
    }

    public boolean equals(Object object) {
        boolean retVal = false;
        if (object != null && object instanceof MachineInfo) {
            MachineInfo that = (MachineInfo)object;
            retVal = this.hashCode() == that.hashCode();
        }
        return retVal;
    }

    public int hashCode() {
        return this.nodeid.getShortName().hashCode();
    }

    private int compareString(String s1, String s2) {
        int retVal = 0;
        if (s1 != null && s2 != null) {
            retVal = s1.compareTo(s2);
        }
        return retVal;
    }

    private int compareToMachineName(MachineInfo that) {
        int retVal = 0;
        if (this.nodeid != null && that.nodeid != null) {
            retVal = this.compareString(this.nodeid.getShortName(), that.nodeid.getShortName());
        }
        return retVal;
    }

    private int compareToMachineStatus(MachineInfo that) {
        int retVal = 0;
        MachineStatus v1 = this.getMachineStatus();
        MachineStatus v2 = that.getMachineStatus();
        block0 : switch (v1) {
            default: {
                switch (v2) {
                    default: {
                        retVal = 0;
                        break block0;
                    }
                    case Down: {
                        retVal = -1;
                        break block0;
                    }
                    case Up: 
                }
                retVal = -1;
                break;
            }
            case Down: {
                switch (v2) {
                    default: {
                        retVal = 1;
                        break block0;
                    }
                    case Down: {
                        retVal = 0;
                        break block0;
                    }
                    case Up: 
                }
                retVal = -1;
                break;
            }
            case Up: {
                switch (v2) {
                    default: {
                        retVal = 1;
                    }
                    case Defined: {
                        break block0;
                    }
                    case Down: {
                        retVal = 1;
                        break block0;
                    }
                    case Up: 
                }
                retVal = 0;
            }
        }
        return retVal;
    }

    private int compareToMachineSwapInuse(MachineInfo that) {
        int retVal = 0;
        try {
            long v1 = Long.parseLong(this.getSwapInuse());
            long v2 = Long.parseLong(that.getSwapInuse());
            if (v1 > v2) {
                return -1;
            }
            if (v1 < v2) {
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    private int compareToMachineAlienPIDs(MachineInfo that) {
        int retVal = 0;
        try {
            long v1 = this.getAlienPidsCount();
            long v2 = that.getAlienPidsCount();
            if (v1 > v2) {
                return -1;
            }
            if (v1 < v2) {
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return retVal;
    }

    @Override
    public int compareTo(MachineInfo that) {
        int retVal = 0;
        if (that != null) {
            if (retVal == 0) {
                retVal = this.compareToMachineStatus(that);
            }
            if (retVal == 0) {
                retVal = this.compareToMachineSwapInuse(that);
            }
            if (retVal == 0) {
                retVal = this.compareToMachineAlienPIDs(that);
            }
            if (retVal == 0) {
                retVal = this.compareToMachineName(that);
            }
        }
        return retVal;
    }

    public static enum MachineStatus {
        Defined,
        Down,
        Up;


        public String getLowerCaseName() {
            String retVal = this.name().toLowerCase();
            return retVal;
        }
    }
}

